/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printer.idea;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import com.intellij.vcs.log.printer.idea.ColorGenerator;
import com.intellij.vcs.log.printer.idea.GraphCellPainter;
import com.intellij.vcs.log.printer.idea.PositionUtil;
import com.intellij.vcs.log.printer.idea.PrintParameters;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphCellPainter
implements GraphCellPainter {
    private static final Color MARK_COLOR = JBColor.BLACK;
    private static final double ARROW_ANGLE_COS2 = 0.7;
    private static final double ARROW_LENGTH = 0.3;
    private Graphics2D g2;
    @NotNull
    private final ColorGenerator myColorGenerator;

    public SimpleGraphCellPainter(@NotNull ColorGenerator colorGenerator) {
        this.myColorGenerator = colorGenerator;
    }

    protected int getRowHeight() {
        return 22;
    }

    private float[] getDashLength(int edgeLength) {
        int space = this.getRowHeight() / 4 - 1;
        int dash = this.getRowHeight() / 4 + 1;
        int count = edgeLength / (2 * (dash + space));
        assert (count != 0);
        int dashApprox = (edgeLength / 2 - count * space) / count;
        return new float[]{2 * dashApprox, 2 * space};
    }

    @NotNull
    private BasicStroke getOrdinaryStroke() {
        return new BasicStroke(PrintParameters.getLineThickness(this.getRowHeight()), 1, 2);
    }

    @NotNull
    private BasicStroke getSelectedStroke() {
        return new BasicStroke(PrintParameters.getSelectedLineThickness(this.getRowHeight()), 1, 2);
    }

    @NotNull
    private Stroke getDashedStroke(float[] dash) {
        return new BasicStroke(PrintParameters.getLineThickness(this.getRowHeight()), 1, 2, 0.0f, dash, dash[0] / 2.0f);
    }

    @NotNull
    private Stroke getSelectedDashedStroke(float[] dash) {
        return new BasicStroke(PrintParameters.getSelectedLineThickness(this.getRowHeight()), 1, 2, 0.0f, dash, dash[0] / 2.0f);
    }

    private void paintUpLine(int from, int to, @NotNull Color color, boolean hasArrow, boolean isUsual, boolean isSelected, boolean isTerminal) {
        int nodeWidth = PrintParameters.getNodeWidth(this.getRowHeight());
        if (from == to) {
            int x = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2 - 1;
            int y2 = isTerminal ? PrintParameters.getCircleRadius(this.getRowHeight()) / 2 + 1 : 0;
            this.paintLine(color, hasArrow, x, y1, x, y2, x, y2, isUsual, isSelected);
        } else {
            assert (!isTerminal);
            int x1 = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2;
            int x2 = nodeWidth * to + nodeWidth / 2;
            int y2 = -this.getRowHeight() / 2;
            this.paintLine(color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2, isUsual, isSelected);
        }
    }

    private void paintDownLine(int from, int to, @NotNull Color color, boolean hasArrow, boolean isUsual, boolean isSelected, boolean isTerminal) {
        int nodeWidth = PrintParameters.getNodeWidth(this.getRowHeight());
        if (from == to) {
            int y2 = this.getRowHeight() - 1 - (isTerminal ? PrintParameters.getCircleRadius(this.getRowHeight()) / 2 + 1 : 0);
            int y1 = this.getRowHeight() / 2;
            int x = nodeWidth * from + nodeWidth / 2;
            this.paintLine(color, hasArrow, x, y1, x, y2, x, y2, isUsual, isSelected);
        } else {
            assert (!isTerminal);
            int x1 = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2;
            int x2 = nodeWidth * to + nodeWidth / 2;
            int y2 = this.getRowHeight() + this.getRowHeight() / 2;
            this.paintLine(color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2, isUsual, isSelected);
        }
    }

    private void paintLine(@NotNull Color color, boolean hasArrow, int x1, int y1, int x2, int y2, int startArrowX, int startArrowY, boolean isUsual, boolean isSelected) {
        this.g2.setColor(color);
        int length = x1 == x2 ? this.getRowHeight() : (int)Math.ceil(Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)));
        this.setStroke(isUsual || hasArrow, isSelected, length);
        this.g2.drawLine(x1, y1, x2, y2);
        if (hasArrow) {
            Pair<Integer, Integer> rotate1 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            Pair<Integer, Integer> rotate2 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), -Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            this.g2.drawLine(startArrowX, startArrowY, (Integer)rotate1.first, (Integer)rotate1.second);
            this.g2.drawLine(startArrowX, startArrowY, (Integer)rotate2.first, (Integer)rotate2.second);
        }
    }

    @NotNull
    private static Pair<Integer, Integer> rotate(double x, double y, double centerX, double centerY, double cos, double sin, double arrowLength) {
        double translateX = x - centerX;
        double translateY = y - centerY;
        double d = Math.sqrt(translateX * translateX + translateY * translateY);
        double scaleX = arrowLength * translateX / d;
        double scaleY = arrowLength * translateY / d;
        double rotateX = scaleX * cos - scaleY * sin;
        double rotateY = scaleX * sin + scaleY * cos;
        return Pair.create((Object)((int)Math.round(rotateX + centerX)), (Object)((int)Math.round(rotateY + centerY)));
    }

    private void paintCircle(int position, @NotNull Color color, boolean select) {
        int nodeWidth = PrintParameters.getNodeWidth(this.getRowHeight());
        int circleRadius = PrintParameters.getCircleRadius(this.getRowHeight());
        int selectedCircleRadius = PrintParameters.getSelectedCircleRadius(this.getRowHeight());
        int x0 = nodeWidth * position + nodeWidth / 2;
        int y0 = this.getRowHeight() / 2;
        int r = circleRadius;
        if (select) {
            r = selectedCircleRadius;
        }
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - r) + 0.5, (double)(y0 - r) + 0.5, 2 * r, 2 * r);
        this.g2.setColor(color);
        this.g2.fill(circle);
    }

    private void setStroke(boolean usual, boolean select, int edgeLength) {
        if (usual) {
            if (select) {
                this.g2.setStroke(this.getSelectedStroke());
            } else {
                this.g2.setStroke(this.getOrdinaryStroke());
            }
        } else if (select) {
            this.g2.setStroke(this.getSelectedDashedStroke(this.getDashLength(edgeLength)));
        } else {
            this.g2.setStroke(this.getDashedStroke(this.getDashLength(edgeLength)));
        }
    }

    @NotNull
    private Color getColor(@NotNull PrintElement printElement) {
        return this.myColorGenerator.getColor(printElement.getColorId());
    }

    private static boolean isUsual(@NotNull PrintElement printElement) {
        if (!(printElement instanceof EdgePrintElement)) {
            return true;
        }
        EdgePrintElement.LineStyle lineStyle = ((EdgePrintElement)printElement).getLineStyle();
        return lineStyle == EdgePrintElement.LineStyle.SOLID;
    }

    @Override
    public void draw(@NotNull Graphics2D g2, @NotNull Collection<? extends PrintElement> printElements) {
        this.g2 = g2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (PrintElement printElement : printElements) {
            if (printElement.isSelected()) continue;
            this.drawElement(printElement, false);
        }
        List selected = ContainerUtil.filter(printElements, (Condition)new Condition<PrintElement>(){

            public boolean value(PrintElement printElement) {
                return printElement.isSelected();
            }
        });
        for (PrintElement printElement : selected) {
            this.drawElement(printElement, true);
        }
        for (PrintElement printElement : selected) {
            this.drawElement(printElement, false);
        }
    }

    protected void drawElement(@NotNull PrintElement printElement, boolean isSelected) {
        if (printElement instanceof EdgePrintElement) {
            if (isSelected) {
                this.printEdge(MARK_COLOR, true, (EdgePrintElement)printElement);
            } else {
                this.printEdge(this.getColor(printElement), false, (EdgePrintElement)printElement);
            }
        }
        if (printElement instanceof NodePrintElement) {
            int position = printElement.getPositionInCurrentRow();
            if (isSelected) {
                this.paintCircle(position, MARK_COLOR, true);
            } else {
                this.paintCircle(position, this.getColor(printElement), false);
            }
        }
    }

    private void printEdge(@NotNull Color color, boolean isSelected, @NotNull EdgePrintElement edgePrintElement) {
        int from = edgePrintElement.getPositionInCurrentRow();
        int to = edgePrintElement.getPositionInOtherRow();
        boolean isUsual = SimpleGraphCellPainter.isUsual((PrintElement)edgePrintElement);
        if (edgePrintElement.getType() == EdgePrintElement.Type.DOWN) {
            this.paintDownLine(from, to, color, edgePrintElement.hasArrow(), isUsual, isSelected, edgePrintElement instanceof TerminalEdgePrintElement);
        } else {
            this.paintUpLine(from, to, color, edgePrintElement.hasArrow(), isUsual, isSelected, edgePrintElement instanceof TerminalEdgePrintElement);
        }
    }

    @Override
    @Nullable
    public PrintElement mouseOver(@NotNull Collection<? extends PrintElement> printElements, int x, int y) {
        int nodeWidth = PrintParameters.getNodeWidth(this.getRowHeight());
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof NodePrintElement)) continue;
            int circleRadius = PrintParameters.getCircleRadius(this.getRowHeight());
            if (!PositionUtil.overNode(printElement.getPositionInCurrentRow(), x, y, this.getRowHeight(), nodeWidth, circleRadius)) continue;
            return printElement;
        }
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof EdgePrintElement)) continue;
            EdgePrintElement edgePrintElement = (EdgePrintElement)printElement;
            float lineThickness = PrintParameters.getLineThickness(this.getRowHeight());
            if (!(edgePrintElement.getType() == EdgePrintElement.Type.DOWN ? PositionUtil.overDownEdge(edgePrintElement.getPositionInCurrentRow(), edgePrintElement.getPositionInOtherRow(), x, y, this.getRowHeight(), nodeWidth, lineThickness) : PositionUtil.overUpEdge(edgePrintElement.getPositionInOtherRow(), edgePrintElement.getPositionInCurrentRow(), x, y, this.getRowHeight(), nodeWidth, lineThickness))) continue;
            return printElement;
        }
        return null;
    }
}

