/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.VcsUser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserImpl
implements VcsUser {
    @NotNull
    private static final Pattern NAME_WITH_DOT = Pattern.compile("(\\w*)\\.(\\w*)");
    @NotNull
    private static final Pattern NAME_WITH_SPACE = Pattern.compile("(\\w*) (\\w*)");
    @NotNull
    private final String myName;
    @NotNull
    private final String myEmail;

    public VcsUserImpl(@NotNull String name, @NotNull String email) {
        this.myName = name;
        this.myEmail = email;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getEmail() {
        return this.myEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsUserImpl user = (VcsUserImpl)o;
        return this.myName.equals(user.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName + "<" + this.myEmail + ">";
    }

    public static boolean isSamePerson(@NotNull VcsUser user1, @NotNull VcsUser user2) {
        return VcsUserImpl.getNameInStandardForm(user1.getName()).equals(VcsUserImpl.getNameInStandardForm(user2.getName()));
    }

    @NotNull
    public static String getNameInStandardForm(@NotNull String name) {
        Pair<String, String> firstAndLastName = VcsUserImpl.getFirstAndLastName(name);
        if (firstAndLastName != null) {
            return ((String)firstAndLastName.first).toLowerCase() + " " + ((String)firstAndLastName.second).toLowerCase();
        }
        return name.toLowerCase();
    }

    @Nullable
    public static Pair<String, String> getFirstAndLastName(@NotNull String name) {
        Matcher nameWithDotMatcher = NAME_WITH_DOT.matcher(name);
        if (nameWithDotMatcher.matches()) {
            return Pair.create((Object)nameWithDotMatcher.group(1), (Object)nameWithDotMatcher.group(2));
        }
        Matcher nameWithSpaceMatcher = NAME_WITH_SPACE.matcher(name);
        if (nameWithSpaceMatcher.matches()) {
            return Pair.create((Object)nameWithSpaceMatcher.group(1), (Object)nameWithSpaceMatcher.group(2));
        }
        return null;
    }
}

