/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.vcs.log.data.VcsLogHashMapImpl;
import com.intellij.vcs.log.impl.VcsRootsRegistry;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootsRegistryImpl
implements VcsRootsRegistry,
Disposable {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsRootsRegistry.class);
    @NotNull
    private final PersistentStringEnumerator myEnumerator;
    private static final int VERSION = 0;

    public VcsRootsRegistryImpl(@NotNull Project project2) {
        this.myEnumerator = VcsRootsRegistryImpl.createEnumerator(VcsRootsRegistryImpl.getStorageFile(project2));
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    @NotNull
    private static File getStorageFile(@NotNull Project project2) {
        File rootsCache = new File(VcsLogHashMapImpl.LOG_CACHE, "roots");
        String logId = PathUtilRt.suggestFileName((String)project2.getName(), (boolean)true, (boolean)true) + "." + project2.getBaseDir().getPath().hashCode();
        File mapFile = new File(rootsCache, logId + "." + 0);
        if (!mapFile.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(rootsCache, logId));
        }
        return mapFile;
    }

    @NotNull
    private static PersistentStringEnumerator createEnumerator(final @NotNull File storageFile) {
        try {
            return (PersistentStringEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<PersistentStringEnumerator, IOException>(){

                public PersistentStringEnumerator compute() throws IOException {
                    return new PersistentStringEnumerator(storageFile);
                }
            }, (File)storageFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create persistent storage for vcs roots.", e);
        }
    }

    public void dispose() {
        try {
            this.myEnumerator.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public int getId(@NotNull VirtualFile root) {
        try {
            return this.myEnumerator.enumerate(root.getPath());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public VirtualFile getRootById(int id) {
        try {
            String path = this.myEnumerator.valueOf(id);
            if (path == null) {
                throw new RuntimeException("Can not find path by id " + id);
            }
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null) {
                LOG.info("Can not find file by path " + path);
                return null;
            }
            return file2;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

