/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;

    @NotNull
    public static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Collection<VcsRef> refs) {
        return VcsLogUtil.groupByRoot(refs, new Function<VcsRef, VirtualFile>(){

            @NotNull
            public VirtualFile fun(@NotNull VcsRef ref) {
                return ref.getRoot();
            }
        });
    }

    @NotNull
    public static <T extends VcsShortCommitDetails> MultiMap<VirtualFile, T> groupByRoot(@NotNull Collection<T> commits) {
        return VcsLogUtil.groupByRoot(commits, new Function<T, VirtualFile>(){

            @NotNull
            public VirtualFile fun(@NotNull T commit) {
                return commit.getRoot();
            }
        });
    }

    @NotNull
    private static <T> MultiMap<VirtualFile, T> groupByRoot(@NotNull Collection<T> items, @NotNull Function<T, VirtualFile> rootGetter) {
        MultiMap map = new MultiMap<VirtualFile, T>(){

            @NotNull
            protected Map<VirtualFile, Collection<T>> createMap() {
                return new TreeMap(new Comparator<VirtualFile>(){

                    @Override
                    public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
                        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
                    }
                });
            }
        };
        for (T item : items) {
            map.putValue(rootGetter.fun(item), item);
        }
        return map;
    }

    @NotNull
    public static List<Integer> getVisibleCommits(final @NotNull VisibleGraph<Integer> visibleGraph) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return (Integer)visibleGraph.getRowInfo(index).getCommit();
            }

            @Override
            public int size() {
                return visibleGraph.getVisibleCommitCount();
            }
        };
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<FilePath> files, @NotNull Set<VirtualFile> roots) {
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots, (Comparator)new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile root1, VirtualFile root2) {
                return root1.getPath().compareTo(root2.getPath());
            }
        });
        for (FilePath filePath : files) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)root, (boolean)false)) continue;
                selectedRoots.add(root);
            }
        }
        return selectedRoots;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (rootFilter == null && structureFilter == null) {
            return new HashSet<VirtualFile>(roots);
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet<VirtualFile>(roots)) : roots;
        return new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(final @NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        if (filterCollection.getStructureFilter() == null) {
            return Collections.emptySet();
        }
        Collection files = filterCollection.getStructureFilter().getFiles();
        return new HashSet<FilePath>(ContainerUtil.filter((Collection)files, (Condition)new Condition<FilePath>(){

            public boolean value(FilePath filePath) {
                VirtualFile virtualFile = filePath.getVirtualFile();
                return root.equals(virtualFile) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
            }
        }));
    }

    @NotNull
    public static List<VcsFullCommitDetails> collectFirstPackOfLoadedSelectedDetails(@NotNull VcsLog log) {
        ArrayList result = ContainerUtil.newArrayList();
        for (VcsFullCommitDetails next : log.getSelectedDetails()) {
            if (next instanceof LoadingDetails) {
                return Collections.emptyList();
            }
            result.add(next);
            if (result.size() < 1000) continue;
            break;
        }
        return result;
    }

    @NotNull
    public static <T> List<T> collectFirstPack(@NotNull List<T> list, int max) {
        return list.subList(0, Math.min(list.size(), max));
    }

    @NotNull
    public static Collection<VcsRef> getVisibleBranches(@NotNull VcsLog log, final @NotNull Set<VirtualFile> visibleRoots) {
        return ContainerUtil.filter((Collection)log.getAllReferences(), (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return visibleRoots.contains(ref.getRoot());
            }
        });
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUiImpl logUi) {
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi.getDataPack().getLogProviders().keySet();
        return VcsLogUtil.getAllVisibleRoots(roots, filters.getRootFilter(), filters.getStructureFilter());
    }

    @Nullable
    public static String getSingleFilteredBranch(@NotNull VcsLogBranchFilter filter, @NotNull VcsLogRefs refs) {
        String branchName = null;
        HashSet checkedRoots = ContainerUtil.newHashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }
}

