/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.logProvider");
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogSettings mySettings;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    private volatile VcsLogUiImpl myUi;

    public VcsLogManager(@NotNull Project project2, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties) {
        this.myProject = project2;
        this.mySettings = settings;
        this.myUiProperties = uiProperties;
    }

    @NotNull
    public JComponent initContent(@NotNull Collection<VcsRoot> roots, @Nullable String contentTabName) {
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        Map<VirtualFile, VcsLogProvider> logProviders = VcsLogManager.findLogProviders(roots, this.myProject);
        Consumer<VisiblePack> visiblePackConsumer = new Consumer<VisiblePack>(){

            public void consume(final VisiblePack pack) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (VcsLogManager.this.myUi != null && !Disposer.isDisposed((Disposable)VcsLogManager.this.myUi)) {
                            VcsLogManager.this.myUi.setVisiblePack(pack);
                        }
                    }
                });
            }
        };
        final VcsLogDataHolder logDataHolder = new VcsLogDataHolder(this.myProject, this, logProviders, this.mySettings, this.myUiProperties, visiblePackConsumer);
        this.myUi = new VcsLogUiImpl(logDataHolder, this.myProject, this.mySettings, new VcsLogColorManagerImpl(logProviders.keySet()), this.myUiProperties, logDataHolder.getFilterer());
        this.myUi.addLogListener(logDataHolder.getContainingBranchesGetter());
        Object logRefresher = contentTabName != null ? new PostponableLogRefresher(this.myProject, logDataHolder, contentTabName) : new VcsLogRefresher(){

            public void refresh(@NotNull VirtualFile root) {
                logDataHolder.refresh(Collections.singletonList(root));
            }
        };
        VcsLogManager.refreshLogOnVcsEvents(logProviders, logRefresher, this);
        logDataHolder.initialize();
        final VcsLogGraphTable graphTable = this.myUi.getTable();
        if (graphTable.getRowCount() > 0) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    graphTable.setRowSelectionInterval(0, 0);
                }
            });
        }
        return this.myUi.getMainFrame().getMainComponent();
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogRefresher refresher, @NotNull Disposable parentDisposable) {
        MultiMap providers2roots = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            providers2roots.putValue((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), refresher);
            Disposer.register((Disposable)parentDisposable, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots, @NotNull Project project2) {
        HashMap logProviders = ContainerUtil.newHashMap();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])Extensions.getExtensions(LOG_PROVIDER_EP, (AreaInstance)project2);
        block0: for (VcsRoot root : roots) {
            AbstractVcs vcs = root.getVcs();
            VirtualFile path = root.getPath();
            if (vcs == null || path == null) {
                LOG.error("Skipping invalid VCS root: " + root);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path, provider);
                continue block0;
            }
        }
        return logProviders;
    }

    @Nullable
    public VcsLogUiImpl getLogUi() {
        return this.myUi;
    }

    public void dispose() {
        this.myUi = null;
    }

    private static class PostponableLogRefresher
    implements VcsLogRefresher,
    Disposable {
        private static final String TOOLWINDOW_ID = ChangesViewContentManager.TOOLWINDOW_ID;
        @NotNull
        private final VcsLogDataHolder myDataHolder;
        @NotNull
        private final ToolWindowManagerImpl myToolWindowManager;
        @NotNull
        private final ToolWindowImpl myToolWindow;
        @NotNull
        private final String myTabName;
        @NotNull
        private final MyRefreshPostponedEventsListener myPostponedEventsListener;
        @NotNull
        private final Set<VirtualFile> myRootsToRefresh = ContainerUtil.newConcurrentSet();

        public PostponableLogRefresher(@NotNull Project project2, @NotNull VcsLogDataHolder dataHolder, @NotNull String contentTabName) {
            this.myDataHolder = dataHolder;
            this.myToolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project2);
            this.myToolWindow = (ToolWindowImpl)this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID);
            this.myTabName = contentTabName;
            Disposer.register((Disposable)dataHolder, (Disposable)this);
            this.myPostponedEventsListener = new MyRefreshPostponedEventsListener();
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            this.myToolWindowManager.addToolWindowManagerListener(this.myPostponedEventsListener);
        }

        public void refresh(@NotNull VirtualFile root) {
            if (this.isOurContentPaneShowing()) {
                this.myDataHolder.refresh(Collections.singleton(root));
            } else {
                this.myRootsToRefresh.add(root);
            }
        }

        public void dispose() {
            this.myToolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            this.myToolWindowManager.removeToolWindowManagerListener(this.myPostponedEventsListener);
        }

        private boolean isOurContentPaneShowing() {
            if (this.myToolWindowManager.isToolWindowRegistered(TOOLWINDOW_ID) && this.myToolWindow.isVisible()) {
                Content content = this.myToolWindow.getContentManager().getSelectedContent();
                return content != null && content.getTabName().equals(this.myTabName);
            }
            return false;
        }

        private void refreshPostponedRoots() {
            HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>(this.myRootsToRefresh);
            this.myRootsToRefresh.removeAll(toRefresh);
            this.myDataHolder.refresh(toRefresh);
        }

        private class MyRefreshPostponedEventsListener
        extends ContentManagerAdapter
        implements ToolWindowManagerListener {
            private MyRefreshPostponedEventsListener() {
            }

            public void selectionChanged(ContentManagerEvent event) {
                this.refreshRootsIfNeeded();
            }

            @Override
            public void stateChanged() {
                this.refreshRootsIfNeeded();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
            }

            private void refreshRootsIfNeeded() {
                if (PostponableLogRefresher.this.isOurContentPaneShowing()) {
                    PostponableLogRefresher.this.refreshPostponedRoots();
                }
            }
        }
    }
}

