/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.primitives.Ints;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogUiImpl myUi;

    public VcsLogImpl(@NotNull VcsLogDataHolder holder, @NotNull VcsLogUiImpl ui) {
        this.myDataHolder = holder;
        this.myUi = ui;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        final int[] rows = this.myUi.getTable().getSelectedRows();
        return new AbstractList<CommitId>(){

            @Override
            @NotNull
            public CommitId get(int index) {
                return ((GraphTableModel)VcsLogImpl.this.myUi.getTable().getModel()).getCommitIdAtRow(rows[index]);
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        final int[] rows = this.myUi.getTable().getSelectedRows();
        return new AbstractList<VcsFullCommitDetails>(){

            @Override
            @NotNull
            public VcsFullCommitDetails get(int index) {
                return (VcsFullCommitDetails)VcsLogImpl.this.myDataHolder.getCommitDetailsGetter().getCommitData(rows[index], (GraphTableModel)VcsLogImpl.this.myUi.getTable().getModel());
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
    }

    public void requestSelectedDetails(@NotNull Consumer<List<VcsFullCommitDetails>> consumer, @Nullable ProgressIndicator indicator) {
        List rowsList = Ints.asList((int[])this.myUi.getTable().getSelectedRows());
        this.myDataHolder.getCommitDetailsGetter().loadCommitsData(rowsList, (GraphTableModel)this.myUi.getTable().getModel(), (Consumer)consumer, indicator);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        return this.myDataHolder.getContainingBranchesGetter().getContainingBranchesFromCache(root, commitHash);
    }

    @NotNull
    public Collection<VcsRef> getAllReferences() {
        return this.myUi.getDataPack().getRefsModel().getAllRefs();
    }

    @NotNull
    public Future<Boolean> jumpToReference(final String reference) {
        Collection<VcsRef> references = this.getAllReferences();
        List matchingRefs = ContainerUtil.findAll(references, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getName().startsWith(reference);
            }
        });
        if (matchingRefs.isEmpty()) {
            return this.myUi.jumpToCommitByPartOfHash(reference);
        }
        VcsRef ref = Collections.min(matchingRefs, new VcsGoToRefComparator(this.myUi.getDataPack().getLogProviders()));
        return this.myUi.jumpToCommit(ref.getCommitHash(), ref.getRoot());
    }

    @NotNull
    public Collection<VcsLogProvider> getLogProviders() {
        return this.myDataHolder.getLogProviders();
    }
}

