/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    public static final String TAB_NAME = "Log";
    private static final Logger LOG = Logger.getInstance(VcsLogContentProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogManager myLogManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final JPanel myContainer = new JBPanel((LayoutManager)new BorderLayout());
    private MessageBusConnection myConnection;

    public VcsLogContentProvider(@NotNull Project project2, @NotNull ProjectLevelVcsManager manager, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties) {
        this.myProject = project2;
        this.myVcsManager = manager;
        this.myLogManager = new VcsLogManager(project2, settings, uiProperties);
    }

    @Nullable
    public static VcsLogManager findLogManager(@NotNull Project project2) {
        Object[] eps = (ChangesViewContentEP[])project2.getExtensions(ChangesViewContentEP.EP_NAME);
        ChangesViewContentEP ep = (ChangesViewContentEP)ContainerUtil.find((Object[])eps, (Condition)new Condition<ChangesViewContentEP>(){

            public boolean value(ChangesViewContentEP ep) {
                return ep.getClassName().equals(VcsLogContentProvider.class.getName());
            }
        });
        if (ep == null) {
            LOG.warn("Proper content provider ep not found among [" + VcsLogContentProvider.toString((ChangesViewContentEP[])eps) + "]");
            return null;
        }
        ChangesViewContentProvider instance = ep.getInstance(project2);
        if (!(instance instanceof VcsLogContentProvider)) {
            LOG.error("Class name matches, but the class doesn't. class name: " + ep.getClassName() + ", class: " + ep.getClass());
            return null;
        }
        VcsLogContentProvider provider = (VcsLogContentProvider)instance;
        return provider.myLogManager;
    }

    @NotNull
    private static String toString(@NotNull ChangesViewContentEP[] eps) {
        return StringUtil.join((Object[])eps, (Function)new Function<ChangesViewContentEP, String>(){

            public String fun(ChangesViewContentEP ep) {
                return String.format("%s-%s-%s", ep.tabName, ep.className, ep.predicateClassName);
            }
        }, (String)",");
    }

    @Override
    public JComponent initContent() {
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new MyVcsListener());
        this.initContentInternal();
        return this.myContainer;
    }

    private void initContentInternal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myContainer.add((Component)this.myLogManager.initContent(Arrays.asList(this.myVcsManager.getAllVcsRoots()), TAB_NAME), "Center");
    }

    @Override
    public void disposeContent() {
        this.myConnection.disconnect();
        this.myContainer.removeAll();
        Disposer.dispose((Disposable)this.myLogManager);
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project2) {
            return !VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project2).getAllVcsRoots()), project2).isEmpty();
        }
    }

    private class MyVcsListener
    implements VcsListener {
        private MyVcsListener() {
        }

        public void directoryMappingChanged() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    VcsLogContentProvider.this.myContainer.removeAll();
                    Disposer.dispose((Disposable)VcsLogContentProvider.this.myLogManager);
                    VcsLogContentProvider.this.initContentInternal();
                }
            });
        }
    }
}

