/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.awt.Cursor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearGraphUtils {
    public static final LinearGraphController.LinearGraphAnswer DEFAULT_GRAPH_ANSWER = new LinearGraphController.LinearGraphAnswer(null, Cursor.getDefaultCursor(), null, null);

    public static boolean intEqual(@Nullable Integer value, int number) {
        return value != null && value == number;
    }

    public static boolean isEdgeUp(@NotNull GraphEdge edge, int nodeIndex) {
        return LinearGraphUtils.intEqual(edge.getDownNodeIndex(), nodeIndex);
    }

    public static boolean isEdgeDown(@NotNull GraphEdge edge, int nodeIndex) {
        return LinearGraphUtils.intEqual(edge.getUpNodeIndex(), nodeIndex);
    }

    public static boolean isNormalEdge(@Nullable GraphEdge edge) {
        if (edge != null && edge.getType().isNormalEdge()) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return true;
        }
        return false;
    }

    @Nullable
    public static NormalEdge asNormalEdge(@Nullable GraphEdge edge) {
        if (LinearGraphUtils.isNormalEdge(edge)) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return NormalEdge.create(edge.getUpNodeIndex(), edge.getDownNodeIndex());
        }
        return null;
    }

    public static int getNotNullNodeIndex(@NotNull GraphEdge edge) {
        if (edge.getUpNodeIndex() != null) {
            return edge.getUpNodeIndex();
        }
        assert (edge.getDownNodeIndex() != null);
        return edge.getDownNodeIndex();
    }

    @NotNull
    public static List<Integer> getUpNodes(@NotNull LinearGraph graph, int nodeIndex) {
        return ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_UP), (Function)new Function<GraphEdge, Integer>(){

            @Nullable
            public Integer fun(GraphEdge graphEdge) {
                return graphEdge.getUpNodeIndex();
            }
        });
    }

    @NotNull
    public static List<Integer> getDownNodes(@NotNull LinearGraph graph, int nodeIndex) {
        return ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_DOWN), (Function)new Function<GraphEdge, Integer>(){

            @Nullable
            public Integer fun(GraphEdge graphEdge) {
                return graphEdge.getDownNodeIndex();
            }
        });
    }

    @NotNull
    public static List<Integer> getDownNodesIncludeNotLoad(@NotNull LinearGraph graph, final int nodeIndex) {
        return ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL), (Function)new Function<GraphEdge, Integer>(){

            @Nullable
            public Integer fun(GraphEdge graphEdge) {
                if (LinearGraphUtils.isEdgeDown(graphEdge, nodeIndex)) {
                    if (graphEdge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                        return graphEdge.getTargetId();
                    }
                    return graphEdge.getDownNodeIndex();
                }
                return null;
            }
        });
    }

    @NotNull
    public static LiteLinearGraph asLiteLinearGraph(final @NotNull LinearGraph graph) {
        return new LiteLinearGraph(){

            @Override
            public int nodesCount() {
                return graph.nodesCount();
            }

            @Override
            @NotNull
            public List<Integer> getNodes(final int nodeIndex, @NotNull LiteLinearGraph.NodeFilter filter) {
                return ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, filter.edgeFilter), (Function)new Function<GraphEdge, Integer>(){

                    public Integer fun(GraphEdge edge) {
                        if (LinearGraphUtils.isEdgeUp(edge, nodeIndex)) {
                            return edge.getUpNodeIndex();
                        }
                        if (LinearGraphUtils.isEdgeDown(edge, nodeIndex)) {
                            return edge.getDownNodeIndex();
                        }
                        return null;
                    }
                });
            }
        };
    }

    @NotNull
    public static LinearGraphController.LinearGraphAnswer createCursorAnswer(boolean handCursor) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (handCursor) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        return new LinearGraphController.LinearGraphAnswer(null, cursor, null, null);
    }

    @NotNull
    public static Cursor getCursor(boolean hand) {
        if (hand) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public static LinearGraphController.LinearGraphAnswer createSelectedAnswer(@NotNull LinearGraph linearGraph, @NotNull Collection<Integer> selectedNodeIndexes) {
        HashSet selectedId = ContainerUtil.newHashSet();
        for (Integer nodeIndex : selectedNodeIndexes) {
            if (nodeIndex == null) continue;
            selectedId.add(linearGraph.getNodeId(nodeIndex));
        }
        return new LinearGraphController.LinearGraphAnswer(null, LinearGraphUtils.getCursor(true), null, selectedId);
    }

    @Nullable
    public static GraphEdge getEdge(@NotNull LinearGraph graph, int up, int down) {
        List<GraphEdge> edges = graph.getAdjacentEdges(up, EdgeFilter.NORMAL_DOWN);
        for (GraphEdge edge : edges) {
            if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), down)) continue;
            return edge;
        }
        return null;
    }

    @NotNull
    public static Set<Integer> convertNodeIndexesToIds(final @NotNull LinearGraph graph, @NotNull Collection<Integer> nodeIndexes) {
        return ContainerUtil.map2Set(nodeIndexes, (Function)new Function<Integer, Integer>(){

            public Integer fun(Integer nodeIndex) {
                return graph.getNodeId(nodeIndex);
            }
        });
    }

    @NotNull
    public static Set<Integer> convertIdsToNodeIndexes(final @NotNull LinearGraph graph, @NotNull Collection<Integer> ids) {
        List result = ContainerUtil.mapNotNull(ids, (Function)new Function<Integer, Integer>(){

            public Integer fun(Integer id) {
                return graph.getNodeIndex(id);
            }
        });
        return ContainerUtil.newHashSet((Iterable)result);
    }
}

