/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.collapsing.EdgeStorageWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearBekGraph
implements LinearGraph {
    @NotNull
    protected final LinearGraph myGraph;
    @NotNull
    protected final EdgeStorageWrapper myHiddenEdges;
    @NotNull
    protected final EdgeStorageWrapper myDottedEdges;

    public LinearBekGraph(@NotNull LinearGraph graph) {
        this.myGraph = graph;
        this.myHiddenEdges = EdgeStorageWrapper.createSimpleEdgeStorage();
        this.myDottedEdges = EdgeStorageWrapper.createSimpleEdgeStorage();
    }

    @Override
    public int nodesCount() {
        return this.myGraph.nodesCount();
    }

    @Override
    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
        ArrayList<GraphEdge> result = new ArrayList<GraphEdge>();
        result.addAll(this.myDottedEdges.getAdjacentEdges(nodeIndex, filter));
        result.addAll(this.myGraph.getAdjacentEdges(nodeIndex, filter));
        result.removeAll(this.myHiddenEdges.getAdjacentEdges(nodeIndex, filter));
        return result;
    }

    @Override
    @NotNull
    public GraphNode getGraphNode(int nodeIndex) {
        return this.myGraph.getGraphNode(nodeIndex);
    }

    @Override
    public int getNodeId(int nodeIndex) {
        return this.myGraph.getNodeId(nodeIndex);
    }

    @Override
    @Nullable
    public Integer getNodeIndex(int nodeId) {
        return this.myGraph.getNodeIndex(nodeId);
    }

    public Collection<GraphEdge> expandEdge(@NotNull GraphEdge edge) {
        HashSet result = ContainerUtil.newHashSet();
        assert (edge.getType() == GraphEdgeType.DOTTED);
        this.myDottedEdges.removeEdge(edge);
        Integer tail = edge.getUpNodeIndex();
        Integer firstChild = edge.getDownNodeIndex();
        assert (tail != null) : "Collapsed from to an unloaded node";
        assert (firstChild != null) : "Collapsed edge to an unloaded node";
        List<GraphEdge> downDottedEdges = this.myHiddenEdges.getAdjacentEdges(tail, EdgeFilter.NORMAL_DOWN);
        List<GraphEdge> upDottedEdges = this.myHiddenEdges.getAdjacentEdges(firstChild, EdgeFilter.NORMAL_UP);
        for (GraphEdge e : ContainerUtil.concat(downDottedEdges, upDottedEdges)) {
            this.myHiddenEdges.removeEdge(e);
            if (e.getType() == GraphEdgeType.DOTTED) {
                result.addAll(this.expandEdge(e));
                continue;
            }
            result.add(e);
        }
        return result;
    }

    public static class WorkingLinearBekGraph
    extends LinearBekGraph {
        private final LinearBekGraph myLinearGraph;

        public WorkingLinearBekGraph(@NotNull LinearBekGraph graph) {
            super(graph.myGraph);
            this.myLinearGraph = graph;
        }

        public Collection<GraphEdge> getAddedEdges() {
            Set<GraphEdge> result = this.myDottedEdges.getEdges();
            result.removeAll(ContainerUtil.filter(this.myHiddenEdges.getEdges(), (Condition)new Condition<GraphEdge>(){

                public boolean value(GraphEdge graphEdge) {
                    return graphEdge.getType() == GraphEdgeType.DOTTED;
                }
            }));
            result.removeAll(this.myLinearGraph.myDottedEdges.getEdges());
            return result;
        }

        public Collection<GraphEdge> getRemovedEdges() {
            HashSet result = ContainerUtil.newHashSet();
            Set<GraphEdge> hidden = this.myHiddenEdges.getEdges();
            result.addAll(ContainerUtil.filter(hidden, (Condition)new Condition<GraphEdge>(){

                public boolean value(GraphEdge graphEdge) {
                    return graphEdge.getType() != GraphEdgeType.DOTTED;
                }
            }));
            result.addAll(ContainerUtil.intersection(hidden, this.myLinearGraph.myDottedEdges.getEdges()));
            result.removeAll(this.myLinearGraph.myHiddenEdges.getEdges());
            return result;
        }

        public void applyChanges() {
            this.myLinearGraph.myDottedEdges.removeAll();
            this.myLinearGraph.myHiddenEdges.removeAll();
            for (GraphEdge e : this.myDottedEdges.getEdges()) {
                this.myLinearGraph.myDottedEdges.createEdge(e);
            }
            for (GraphEdge e : this.myHiddenEdges.getEdges()) {
                this.myLinearGraph.myHiddenEdges.createEdge(e);
            }
        }
    }
}

