/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranchCreator;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranchMerger;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BekSorter {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final GraphLayoutImpl myGraphLayout;
    @NotNull
    private final TimestampGetter myTimestampGetter;

    @NotNull
    public static BekIntMap createBekMap(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout, @NotNull TimestampGetter timestampGetter) {
        BekSorter bekSorter = new BekSorter(permanentGraph, graphLayout, timestampGetter);
        List<Integer> result = bekSorter.getResult();
        assert (result.size() == permanentGraph.nodesCount());
        return BekSorter.createBekIntMap(result);
    }

    private static BekIntMap createBekIntMap(final List<Integer> result) {
        int[] reverseMap = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            reverseMap[result.get((int)i).intValue()] = i;
        }
        final IntList compressedBekMap = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return result.size();
            }

            @Override
            public int get(int index) {
                return (Integer)result.get(index);
            }
        }, 30);
        final IntList compressedReverseMap = CompressedIntList.newInstance(reverseMap);
        return new BekIntMap(){

            @Override
            public int size() {
                return compressedBekMap.size();
            }

            @Override
            public int getBekIndex(int usualIndex) {
                return compressedReverseMap.get(usualIndex);
            }

            @Override
            public int getUsualIndex(int bekIndex) {
                return compressedBekMap.get(bekIndex);
            }
        };
    }

    private BekSorter(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout, @NotNull TimestampGetter timestampGetter) {
        this.myPermanentGraph = permanentGraph;
        this.myGraphLayout = graphLayout;
        this.myTimestampGetter = timestampGetter;
    }

    public List<Integer> getResult() {
        BekBranchCreator bekBranchCreator = new BekBranchCreator(this.myPermanentGraph, this.myGraphLayout);
        Pair<List<BekBranch>, BekEdgeRestrictions> branches = bekBranchCreator.getResult();
        BekBranchMerger bekBranchMerger = new BekBranchMerger((List)branches.first, (BekEdgeRestrictions)branches.second, this.myTimestampGetter);
        return bekBranchMerger.getResult();
    }
}

