/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.DottedFilterEdgesGenerator;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredController
extends CascadeController {
    @NotNull
    private final CollapsedGraph myCollapsedGraph;

    protected FilteredController(@NotNull CascadeController delegateLinearGraphController, @NotNull PermanentGraphInfo permanentGraphInfo, @NotNull Set<Integer> matchedIds) {
        super(delegateLinearGraphController, permanentGraphInfo);
        UnsignedBitSet initVisibility = new UnsignedBitSet();
        for (Integer matchedId : matchedIds) {
            initVisibility.set(matchedId, true);
        }
        this.myCollapsedGraph = CollapsedGraph.newInstance(delegateLinearGraphController.getCompiledGraph(), initVisibility);
        DottedFilterEdgesGenerator.update(this.myCollapsedGraph, 0, this.myCollapsedGraph.getDelegatedGraph().nodesCount() - 1);
    }

    @Override
    @NotNull
    public LinearGraphController.LinearGraphAnswer performLinearGraphAction(@NotNull LinearGraphController.LinearGraphAction action) {
        LinearGraphController.LinearGraphAnswer answer = this.performAction(action);
        if (answer != null) {
            return answer;
        }
        return LinearGraphUtils.DEFAULT_GRAPH_ANSWER;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        return null;
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer == LinearGraphUtils.DEFAULT_GRAPH_ANSWER) {
            return delegateAnswer;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        return this.myCollapsedGraph.getCompiledGraph();
    }
}

