/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CascadeController
implements LinearGraphController {
    @Nullable
    private final CascadeController myDelegateController;
    @NotNull
    protected final PermanentGraphInfo myPermanentGraphInfo;

    protected CascadeController(@Nullable CascadeController delegateController, @NotNull PermanentGraphInfo permanentGraphInfo) {
        this.myDelegateController = delegateController;
        this.myPermanentGraphInfo = permanentGraphInfo;
    }

    @Override
    @NotNull
    public LinearGraphController.LinearGraphAnswer performLinearGraphAction(@NotNull LinearGraphController.LinearGraphAction action) {
        LinearGraphController.LinearGraphAnswer answer = this.performAction(action);
        if (answer == null && this.myDelegateController != null) {
            answer = this.myDelegateController.performLinearGraphAction(new VisibleGraphImpl.LinearGraphActionImpl(this.convertToDelegate(action.getAffectedElement()), action.getType()));
            answer = this.delegateGraphChanged(answer);
        }
        if (answer != null) {
            return answer;
        }
        return LinearGraphUtils.DEFAULT_GRAPH_ANSWER;
    }

    @Nullable
    private PrintElementWithGraphElement convertToDelegate(@Nullable PrintElementWithGraphElement element) {
        if (element == null) {
            return null;
        }
        GraphElement convertedGraphElement = this.convertToDelegate(element.getGraphElement());
        if (convertedGraphElement == null) {
            return null;
        }
        return PrintElementWithGraphElement.converted(element, convertedGraphElement);
    }

    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        return graphElement;
    }

    @NotNull
    protected CascadeController getDelegateController() {
        assert (this.myDelegateController != null);
        return this.myDelegateController;
    }

    @NotNull
    public PermanentGraphInfo getPermanentGraphInfo() {
        return this.myPermanentGraphInfo;
    }

    @NotNull
    protected abstract LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer var1);

    @Nullable
    protected abstract LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction var1);
}

