/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.utils.IntIntMultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EdgeStorage {
    private static final int EDGE_TYPE_BITS = 4;
    private static final int EDGE_BITS_OFFSET = 28;
    private static final int COMPRESSED_NODE_ID_MASK = 0xFFFFFFF;
    private static final int MAX_EDGE_TYPE_COUNT = 16;
    private static final int MAX_NODE_ID = 0x7FFFFFF;
    private static final int MIN_NODE_ID = -134217728;
    public static final int NULL_ID = -134217728;
    @NotNull
    private final IntIntMultiMap myEdges = new IntIntMultiMap();

    public EdgeStorage() {
        assert (GraphEdgeType.values().length <= 16);
    }

    public void createEdge(int mainNodeId, int additionId, GraphEdgeType edgeType) {
        if (edgeType.isNormalEdge()) {
            this.myEdges.putValue(mainNodeId, EdgeStorage.compressEdge(additionId, edgeType));
            this.myEdges.putValue(additionId, EdgeStorage.compressEdge(mainNodeId, edgeType));
        } else {
            this.myEdges.putValue(mainNodeId, EdgeStorage.compressEdge(additionId, edgeType));
        }
    }

    public void removeEdge(int mainNodeId, int additionId, GraphEdgeType edgeType) {
        if (edgeType.isNormalEdge()) {
            this.myEdges.remove(mainNodeId, EdgeStorage.compressEdge(additionId, edgeType));
            this.myEdges.remove(additionId, EdgeStorage.compressEdge(mainNodeId, edgeType));
        } else {
            this.myEdges.remove(mainNodeId, EdgeStorage.compressEdge(additionId, edgeType));
        }
    }

    public List<Pair<Integer, GraphEdgeType>> getEdges(int nodeId) {
        return ContainerUtil.map(this.myEdges.get(nodeId), (Function)new Function<Integer, Pair<Integer, GraphEdgeType>>(){

            public Pair<Integer, GraphEdgeType> fun(Integer compressEdge) {
                return Pair.create((Object)EdgeStorage.convertToInteger(EdgeStorage.retrievedNodeId(compressEdge)), (Object)((Object)EdgeStorage.retrievedType(compressEdge)));
            }
        });
    }

    public int[] getKnownIds() {
        return this.myEdges.keys();
    }

    @Nullable
    private static Integer convertToInteger(int value) {
        return value == -134217728 ? null : Integer.valueOf(value);
    }

    private static int compressEdge(int nodeId, GraphEdgeType edgeType) {
        assert (nodeId == -134217728 || nodeId < 0x7FFFFFF && nodeId > -134217728);
        int type = edgeType.ordinal();
        return type << 28 | 0xFFFFFFF & nodeId;
    }

    @NotNull
    private static GraphEdgeType retrievedType(int compressEdge) {
        int type = compressEdge >>> 28;
        return GraphEdgeType.values()[type];
    }

    private static int retrievedNodeId(int compressEdge) {
        return compressEdge << 4 >> 4;
    }

    public void removeAll() {
        this.myEdges.clear();
    }
}

