/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.collapsing.EdgeStorage;
import com.intellij.vcs.log.graph.collapsing.EdgeStorageWrapper;
import com.intellij.vcs.log.graph.collapsing.GraphNodesVisibility;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.ListIntToIntMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapsedGraph {
    @NotNull
    private final LinearGraph myDelegatedGraph;
    @NotNull
    private final UnsignedBitSet myMatchedNodeId;
    @NotNull
    private final GraphNodesVisibility myDelegateNodesVisibility;
    @NotNull
    private final UpdatableIntToIntMap myNodesMap;
    @NotNull
    private final EdgeStorage myEdgeStorage;
    @NotNull
    private final CompiledGraph myCompiledGraph;
    @NotNull
    private final AtomicReference<Modification> myCurrentModification = new AtomicReference<Object>(null);

    public static CollapsedGraph newInstance(@NotNull LinearGraph delegateGraph, @NotNull UnsignedBitSet matchedNodeId) {
        return new CollapsedGraph(delegateGraph, matchedNodeId, matchedNodeId.clone(), new EdgeStorage());
    }

    public static CollapsedGraph updateInstance(@NotNull CollapsedGraph prevCollapsedGraph, @NotNull LinearGraph newDelegateGraph) {
        UnsignedBitSet visibleNodesId = prevCollapsedGraph.myDelegateNodesVisibility.getNodeVisibilityById();
        return new CollapsedGraph(newDelegateGraph, prevCollapsedGraph.myMatchedNodeId, visibleNodesId, prevCollapsedGraph.myEdgeStorage);
    }

    private CollapsedGraph(@NotNull LinearGraph delegatedGraph, @NotNull UnsignedBitSet matchedNodeId, @NotNull UnsignedBitSet visibleNodesId, @NotNull EdgeStorage edgeStorage) {
        this.myDelegatedGraph = delegatedGraph;
        this.myMatchedNodeId = matchedNodeId;
        this.myDelegateNodesVisibility = new GraphNodesVisibility(delegatedGraph, visibleNodesId);
        this.myNodesMap = ListIntToIntMap.newInstance(this.myDelegateNodesVisibility.asFlags());
        this.myEdgeStorage = edgeStorage;
        this.myCompiledGraph = new CompiledGraph();
    }

    @NotNull
    public LinearGraph getDelegatedGraph() {
        return this.myDelegatedGraph;
    }

    public boolean isNodeVisible(int delegateNodeIndex) {
        return this.myDelegateNodesVisibility.isVisible(delegateNodeIndex);
    }

    @NotNull
    public Modification startModification() {
        Modification modification = new Modification();
        if (this.myCurrentModification.compareAndSet(null, modification)) {
            return modification;
        }
        throw new RuntimeException("Can not start a new modification while the other one is still running.");
    }

    @NotNull
    public LinearGraph getCompiledGraph() {
        this.assertNotUnderModification();
        return this.myCompiledGraph;
    }

    public int convertToDelegateNodeIndex(int compiledNodeIndex) {
        this.assertNotUnderModification();
        return this.myNodesMap.getLongIndex(compiledNodeIndex);
    }

    @NotNull
    public UnsignedBitSet getMatchedNodeId() {
        return this.myMatchedNodeId;
    }

    public boolean isMyCollapsedEdge(int upNodeIndex, int downNodeIndex) {
        return new EdgeStorageWrapper(this.myEdgeStorage, this.myDelegatedGraph).hasEdge(upNodeIndex, downNodeIndex);
    }

    private void assertNotUnderModification() {
        Modification modification = this.myCurrentModification.get();
        if (modification != null && modification.myProgress == 1) {
            throw new IllegalStateException("CompiledGraph is under modification");
        }
    }

    private class CompiledGraph
    implements LinearGraph {
        @NotNull
        private final EdgeStorageWrapper myEdgeStorageWrapper;

        private CompiledGraph() {
            this.myEdgeStorageWrapper = new EdgeStorageWrapper(CollapsedGraph.this.myEdgeStorage, this);
        }

        @Override
        public int nodesCount() {
            CollapsedGraph.this.assertNotUnderModification();
            return CollapsedGraph.this.myNodesMap.shortSize();
        }

        @NotNull
        private GraphEdge createEdge(@NotNull GraphEdge delegateEdge, @Nullable Integer upNodeIndex, @Nullable Integer downNodeIndex) {
            return new GraphEdge(upNodeIndex, downNodeIndex, delegateEdge.getTargetId(), delegateEdge.getType());
        }

        @Nullable
        private Integer compiledNodeIndex(@Nullable Integer delegateNodeIndex) {
            if (delegateNodeIndex == null) {
                return null;
            }
            if (CollapsedGraph.this.myDelegateNodesVisibility.isVisible(delegateNodeIndex)) {
                return CollapsedGraph.this.myNodesMap.getShortIndex(delegateNodeIndex);
            }
            return -1;
        }

        private boolean isVisibleEdge(@Nullable Integer compiledUpNode, @Nullable Integer compiledDownNode) {
            if (compiledUpNode != null && compiledUpNode == -1) {
                return false;
            }
            return compiledDownNode == null || compiledDownNode != -1;
        }

        @Override
        @NotNull
        public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
            CollapsedGraph.this.assertNotUnderModification();
            List result = ContainerUtil.newSmartList();
            int delegateIndex = CollapsedGraph.this.myNodesMap.getLongIndex(nodeIndex);
            for (GraphEdge delegateEdge : CollapsedGraph.this.myDelegatedGraph.getAdjacentEdges(delegateIndex, filter)) {
                Integer compiledDownIndex;
                Integer compiledUpIndex = this.compiledNodeIndex(delegateEdge.getUpNodeIndex());
                if (!this.isVisibleEdge(compiledUpIndex, compiledDownIndex = this.compiledNodeIndex(delegateEdge.getDownNodeIndex()))) continue;
                result.add(this.createEdge(delegateEdge, compiledUpIndex, compiledDownIndex));
            }
            result.addAll(this.myEdgeStorageWrapper.getAdjacentEdges(nodeIndex, filter));
            return result;
        }

        @Override
        @NotNull
        public GraphNode getGraphNode(int nodeIndex) {
            CollapsedGraph.this.assertNotUnderModification();
            int delegateIndex = CollapsedGraph.this.myNodesMap.getLongIndex(nodeIndex);
            GraphNode graphNode = CollapsedGraph.this.myDelegatedGraph.getGraphNode(delegateIndex);
            return new GraphNode(nodeIndex, graphNode.getType());
        }

        @Override
        public int getNodeId(int nodeIndex) {
            CollapsedGraph.this.assertNotUnderModification();
            int delegateIndex = CollapsedGraph.this.myNodesMap.getLongIndex(nodeIndex);
            return CollapsedGraph.this.myDelegatedGraph.getNodeId(delegateIndex);
        }

        @Override
        @Nullable
        public Integer getNodeIndex(int nodeId) {
            CollapsedGraph.this.assertNotUnderModification();
            Integer delegateIndex = CollapsedGraph.this.myDelegatedGraph.getNodeIndex(nodeId);
            if (delegateIndex == null) {
                return null;
            }
            if (CollapsedGraph.this.myDelegateNodesVisibility.isVisible(delegateIndex)) {
                return CollapsedGraph.this.myNodesMap.getShortIndex(delegateIndex);
            }
            return null;
        }
    }

    public class Modification {
        private static final int COLLECTING = 0;
        private static final int APPLYING = 1;
        private static final int DONE = 2;
        @NotNull
        private final EdgeStorageWrapper myEdgesToAdd = EdgeStorageWrapper.createSimpleEdgeStorage();
        @NotNull
        private final EdgeStorageWrapper myEdgesToRemove = EdgeStorageWrapper.createSimpleEdgeStorage();
        @NotNull
        private final TIntHashSet myNodesToHide = new TIntHashSet();
        @NotNull
        private final TIntHashSet myNodesToShow = new TIntHashSet();
        private boolean myClearEdges = false;
        private boolean myClearVisibility = false;
        private volatile int myProgress = 0;
        private int minAffectedNodeIndex = Integer.MAX_VALUE;
        private int maxAffectedNodeIndex = Integer.MIN_VALUE;

        private void touchIndex(int nodeIndex) {
            assert (this.myProgress == 0);
            this.minAffectedNodeIndex = Math.min(this.minAffectedNodeIndex, nodeIndex);
            this.maxAffectedNodeIndex = Math.max(this.maxAffectedNodeIndex, nodeIndex);
        }

        private void touchAll() {
            assert (this.myProgress == 0);
            this.minAffectedNodeIndex = 0;
            this.maxAffectedNodeIndex = CollapsedGraph.this.getDelegatedGraph().nodesCount() - 1;
        }

        private void touchEdge(@NotNull GraphEdge edge) {
            assert (this.myProgress == 0);
            if (edge.getUpNodeIndex() != null) {
                this.touchIndex(edge.getUpNodeIndex());
            }
            if (edge.getDownNodeIndex() != null) {
                this.touchIndex(edge.getDownNodeIndex());
            }
        }

        public void showNode(int nodeIndex) {
            assert (this.myProgress == 0);
            this.myNodesToShow.add(nodeIndex);
            this.touchIndex(nodeIndex);
        }

        public void hideNode(int nodeIndex) {
            assert (this.myProgress == 0);
            this.myNodesToHide.add(nodeIndex);
            this.touchIndex(nodeIndex);
        }

        public void createEdge(@NotNull GraphEdge edge) {
            assert (this.myProgress == 0);
            this.myEdgesToAdd.createEdge(edge);
            this.touchEdge(edge);
        }

        public void removeEdge(@NotNull GraphEdge edge) {
            assert (this.myProgress == 0);
            this.myEdgesToRemove.createEdge(edge);
            this.touchEdge(edge);
        }

        public void removeAdditionalEdges() {
            assert (this.myProgress == 0);
            this.myClearEdges = true;
            this.touchAll();
        }

        public void resetNodesVisibility() {
            assert (this.myProgress == 0);
            this.myClearVisibility = true;
            this.touchAll();
        }

        @NotNull
        EdgeStorageWrapper getEdgesToAdd() {
            assert (this.myProgress == 0);
            return this.myEdgesToAdd;
        }

        boolean isNodeHidden(int nodeIndex) {
            assert (this.myProgress == 0);
            return this.myNodesToHide.contains(nodeIndex);
        }

        boolean isNodeShown(int nodeIndex) {
            assert (this.myProgress == 0);
            return this.myNodesToShow.contains(nodeIndex);
        }

        public void apply() {
            assert (CollapsedGraph.this.myCurrentModification.get() == this);
            this.myProgress = 1;
            if (this.myClearVisibility) {
                CollapsedGraph.this.myDelegateNodesVisibility.setNodeVisibilityById(CollapsedGraph.this.myMatchedNodeId.clone());
            }
            if (this.myClearEdges) {
                CollapsedGraph.this.myEdgeStorage.removeAll();
            }
            TIntIterator toShow = this.myNodesToShow.iterator();
            while (toShow.hasNext()) {
                CollapsedGraph.this.myDelegateNodesVisibility.show(toShow.next());
            }
            TIntIterator toHide = this.myNodesToHide.iterator();
            while (toHide.hasNext()) {
                CollapsedGraph.this.myDelegateNodesVisibility.hide(toHide.next());
            }
            EdgeStorageWrapper edgeStorageWrapper = new EdgeStorageWrapper(CollapsedGraph.this.myEdgeStorage, CollapsedGraph.this.getDelegatedGraph());
            for (GraphEdge edge : this.myEdgesToAdd.getEdges()) {
                edgeStorageWrapper.createEdge(edge);
            }
            for (GraphEdge edge : this.myEdgesToRemove.getEdges()) {
                edgeStorageWrapper.removeEdge(edge);
            }
            if (this.minAffectedNodeIndex != Integer.MAX_VALUE && this.maxAffectedNodeIndex != Integer.MIN_VALUE) {
                CollapsedGraph.this.myNodesMap.update(this.minAffectedNodeIndex, this.maxAffectedNodeIndex);
            }
            this.myProgress = 2;
            CollapsedGraph.this.myCurrentModification.set(null);
        }
    }
}

