/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterController
extends CascadeController {
    @NotNull
    private CollapsedGraph myCollapsedGraph;
    private final Set<Integer> myIdsOfVisibleBranches;

    public BranchFilterController(@NotNull CascadeController delegateLinearGraphController, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @Nullable Set<Integer> idsOfVisibleBranches) {
        super(delegateLinearGraphController, permanentGraphInfo);
        this.myIdsOfVisibleBranches = idsOfVisibleBranches;
        this.updateCollapsedGraph();
    }

    private void updateCollapsedGraph() {
        UnsignedBitSet initVisibility = ReachableNodes.getReachableNodes(this.myPermanentGraphInfo.getPermanentLinearGraph(), this.myIdsOfVisibleBranches);
        this.myCollapsedGraph = CollapsedGraph.newInstance(this.getDelegateController().getCompiledGraph(), initVisibility);
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        if (delegateAnswer.getGraphChanges() != null) {
            this.updateCollapsedGraph();
        }
        return delegateAnswer;
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        return this.myCollapsedGraph.getCompiledGraph();
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        return CollapsedController.convertToDelegate(graphElement, this.myCollapsedGraph);
    }
}

