/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.api.elements;

import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import org.jetbrains.annotations.NotNull;

public final class GraphNode
implements GraphElement {
    private final int myNodeIndex;
    @NotNull
    private final GraphNodeType myType;

    public GraphNode(int nodeIndex) {
        this(nodeIndex, GraphNodeType.USUAL);
    }

    public GraphNode(int nodeIndex, @NotNull GraphNodeType type) {
        this.myNodeIndex = nodeIndex;
        this.myType = type;
    }

    public int getNodeIndex() {
        return this.myNodeIndex;
    }

    @NotNull
    public GraphNodeType getType() {
        return this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphNode graphNode = (GraphNode)o;
        if (this.myNodeIndex != graphNode.myNodeIndex) {
            return false;
        }
        return this.myType == graphNode.myType;
    }

    public int hashCode() {
        int result = this.myNodeIndex;
        result = 31 * result + this.myType.hashCode();
        return result;
    }
}

