/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GraphColorManagerImpl
implements GraphColorManager<Integer> {
    private static final Logger LOG = Logger.getInstance(GraphColorManagerImpl.class);
    static final int DEFAULT_COLOR = 0;
    @NotNull
    private final RefsModel myRefsModel;
    @NotNull
    private final NotNullFunction<Integer, Hash> myHashGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogRefManager> myRefManagers;
    @NotNull
    private final LinkedHashMap<Integer, Integer> myErrorWasReported = new LinkedHashMap<Integer, Integer>(10){

        protected boolean removeEldestEntry(Map.Entry<Integer, Integer> eldest) {
            return this.size() > 100;
        }
    };

    public GraphColorManagerImpl(@NotNull RefsModel refsModel, @NotNull NotNullFunction<Integer, Hash> hashGetter, @NotNull Map<VirtualFile, VcsLogRefManager> refManagers) {
        this.myRefsModel = refsModel;
        this.myHashGetter = hashGetter;
        this.myRefManagers = refManagers;
    }

    public int getColorOfBranch(Integer headCommit) {
        Collection<VcsRef> refs = this.myRefsModel.refsToCommit(headCommit);
        if (this.isEmptyRefs(refs, headCommit)) {
            return 0;
        }
        VcsRef firstRef = Collections.min(refs, this.myRefManagers.get(this.getFirstRoot(refs)).getBranchLayoutComparator());
        return firstRef.getName().hashCode();
    }

    @NotNull
    private VirtualFile getFirstRoot(@NotNull Collection<VcsRef> refs) {
        return refs.iterator().next().getRoot();
    }

    private boolean isEmptyRefs(@NotNull Collection<VcsRef> refs, int head) {
        if (refs.isEmpty()) {
            if (!this.myErrorWasReported.containsKey((Object)head)) {
                this.myErrorWasReported.put((Object)head, (Object)head);
                LOG.warn("No references found at head " + head + " which corresponds to hash " + this.myHashGetter.fun((Object)head));
            }
            return true;
        }
        return false;
    }

    public int getColorOfFragment(Integer headCommit, int magicIndex) {
        return magicIndex;
    }

    public int compareHeads(Integer head1, Integer head2) {
        VcsLogRefManager refManager2;
        if (head1.equals(head2)) {
            return 0;
        }
        Collection<VcsRef> refs1 = this.myRefsModel.refsToCommit(head1);
        Collection<VcsRef> refs2 = this.myRefsModel.refsToCommit(head2);
        boolean firstEmpty = this.isEmptyRefs(refs1, head1);
        boolean secondEmpty = this.isEmptyRefs(refs2, head2);
        if (firstEmpty && secondEmpty) {
            return head1 - head2;
        }
        if (firstEmpty) {
            return 1;
        }
        if (secondEmpty) {
            return -1;
        }
        VirtualFile root1 = this.getFirstRoot(refs1);
        VirtualFile root2 = this.getFirstRoot(refs2);
        VcsLogRefManager refManager1 = this.myRefManagers.get(root1);
        if (!refManager1.equals(refManager2 = this.myRefManagers.get(root2))) {
            return VcsLogUtil.compareRoots(root1, root2);
        }
        VcsRef bestRef = (VcsRef)ContainerUtil.sorted((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{refs1, refs2}), (Comparator)refManager1.getBranchLayoutComparator()).get(0);
        return refs1.contains(bestRef) ? -1 : 1;
    }
}

