/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitCountStage;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.EmptyVisibleGraph;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VisiblePackBuilder {
    private static final Logger LOG = Logger.getInstance(VisiblePackBuilder.class);
    @NotNull
    private final VcsLogHashMap myHashMap;
    @NotNull
    private final Map<Integer, VcsCommitMetadata> myTopCommitsDetailsCache;
    @NotNull
    private final DataGetter<VcsFullCommitDetails> myCommitDetailsGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;

    VisiblePackBuilder(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogHashMap hashMap, @NotNull Map<Integer, VcsCommitMetadata> topCommitsDetailsCache, @NotNull DataGetter<VcsFullCommitDetails> detailsGetter) {
        this.myHashMap = hashMap;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myCommitDetailsGetter = detailsGetter;
        this.myLogProviders = providers;
    }

    @NotNull
    Pair<VisiblePack, CommitCountStage> build(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        VcsLogHashFilter hashFilter = filters.getHashFilter();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            return Pair.create((Object)this.applyHashFilter(dataPack, hashFilter.getHashes(), sortType), (Object)((Object)commitCount));
        }
        Set<Integer> matchingHeads = this.getMatchingHeads(dataPack.getRefs(), dataPack.getLogProviders().keySet(), filters);
        List detailsFilters = filters.getDetailsFilters();
        Collection<CommitId> matchingCommits = null;
        boolean canRequestMore = false;
        if (!detailsFilters.isEmpty()) {
            if (commitCount == CommitCountStage.INITIAL && (matchingCommits = this.filterInMemory(dataPack.getPermanentGraph(), detailsFilters, matchingHeads)).size() < commitCount.getCount()) {
                commitCount = commitCount.next();
                matchingCommits = null;
            }
            if (matchingCommits == null) {
                try {
                    matchingCommits = VisiblePackBuilder.getFilteredDetailsFromTheVcs(this.myLogProviders, filters, commitCount.getCount());
                }
                catch (VcsException e) {
                    matchingCommits = Collections.emptyList();
                    LOG.error((Throwable)e);
                }
            }
            canRequestMore = matchingCommits.size() >= commitCount.getCount();
        }
        VisibleGraph visibleGraph = VisiblePackBuilder.matchesNothing(matchingHeads) || VisiblePackBuilder.matchesNothing(matchingCommits) ? EmptyVisibleGraph.getInstance() : dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, this.getMatchedCommitIndex(matchingCommits));
        return Pair.create((Object)new VisiblePack(dataPack, visibleGraph, canRequestMore, filters), (Object)((Object)commitCount));
    }

    private static <T> boolean matchesNothing(@Nullable Collection<T> matchingSet) {
        return matchingSet != null && matchingSet.isEmpty();
    }

    private VisiblePack applyHashFilter(@NotNull DataPack dataPack, @NotNull Collection<String> hashes, @NotNull PermanentGraph.SortType sortType) {
        Set indices = ContainerUtil.map2SetNotNull(hashes, (Function)new Function<String, Integer>(){

            public Integer fun(String partOfHash) {
                CommitId commitId = VisiblePackBuilder.this.myHashMap.findCommitId(new CommitIdByStringCondition(partOfHash));
                return commitId != null ? Integer.valueOf(VisiblePackBuilder.this.myHashMap.getCommitIndex(commitId.getHash(), commitId.getRoot())) : null;
            }
        });
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, indices);
        return new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, false, new VcsLogFilterCollectionImpl(null, null, new VcsLogHashFilterImpl(hashes), null, null, null, null));
    }

    @Nullable
    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Set<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        VcsLogBranchFilter branchFilter = filters.getBranchFilter();
        VcsLogRootFilter rootFilter = filters.getRootFilter();
        VcsLogStructureFilter structureFilter = filters.getStructureFilter();
        if (branchFilter == null && rootFilter == null && structureFilter == null) {
            return null;
        }
        Set<Integer> filteredByBranch = null;
        if (branchFilter != null) {
            filteredByBranch = this.getMatchingHeads(refs, branchFilter);
        }
        Set<Integer> filteredByFile = this.getMatchingHeads(refs, VcsLogUtil.getAllVisibleRoots(roots, rootFilter, structureFilter));
        if (filteredByBranch == null) {
            return filteredByFile;
        }
        if (filteredByFile == null) {
            return filteredByBranch;
        }
        return new HashSet(ContainerUtil.intersection(filteredByBranch, filteredByFile));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, final @NotNull VcsLogBranchFilter filter) {
        return new HashSet((Collection)ContainerUtil.mapNotNull((Collection)refs.getBranches(), (Function)new Function<VcsRef, Integer>(){

            public Integer fun(@NotNull VcsRef ref) {
                boolean acceptRef = filter.matches(ref.getName());
                return acceptRef ? Integer.valueOf(VisiblePackBuilder.this.myHashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot())) : null;
            }
        }));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots) {
        HashSet result = new HashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!roots.contains(branch.getRoot())) continue;
            result.add(this.myHashMap.getCommitIndex(branch.getCommitHash(), branch.getRoot()));
        }
        return result;
    }

    @NotNull
    private Collection<CommitId> filterInMemory(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        GraphCommit commit;
        VcsCommitMetadata data;
        ArrayList result = ContainerUtil.newArrayList();
        Iterator iterator = permanentGraph.getAllCommits().iterator();
        while (iterator.hasNext() && (data = this.getDetailsFromCache((Integer)(commit = (GraphCommit)iterator.next()).getId())) != null) {
            if (!this.matchesAllFilters(data, permanentGraph, detailsFilters, matchingHeads)) continue;
            result.add(new CommitId((Hash)data.getId(), data.getRoot()));
        }
        return result;
    }

    private boolean matchesAllFilters(final @NotNull VcsCommitMetadata commit, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        boolean matchesAllDetails = ContainerUtil.and(detailsFilters, (Condition)new Condition<VcsLogDetailsFilter>(){

            public boolean value(VcsLogDetailsFilter filter) {
                return filter.matches(commit);
            }
        });
        return matchesAllDetails && this.matchesAnyHead(permanentGraph, commit, matchingHeads);
    }

    private boolean matchesAnyHead(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull VcsCommitMetadata commit, @Nullable Set<Integer> matchingHeads) {
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.myHashMap.getCommitIndex((Hash)commit.getId(), commit.getRoot());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), matchingHeads);
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(final int commitIndex) {
        VcsCommitMetadata details = this.myTopCommitsDetailsCache.get(commitIndex);
        if (details != null) {
            return details;
        }
        return (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<VcsCommitMetadata>(){

            public VcsCommitMetadata compute() {
                return (VcsCommitMetadata)VisiblePackBuilder.this.myCommitDetailsGetter.getCommitDataIfAvailable(commitIndex);
            }
        });
    }

    @NotNull
    private static Collection<CommitId> getFilteredDetailsFromTheVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(providers.keySet(), filterCollection.getRootFilter(), filterCollection.getStructureFilter());
        ArrayList logs = ContainerUtil.newArrayList();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            final VirtualFile root = entry.getKey();
            if (!visibleRoots.contains(root) || filterCollection.getUserFilter() != null && filterCollection.getUserFilter().getUserNames(root).isEmpty()) continue;
            VcsLogFilterCollection rootSpecificCollection = filterCollection;
            if (rootSpecificCollection.getStructureFilter() != null) {
                rootSpecificCollection = VisiblePackBuilder.replaceStructureFilter(filterCollection, ContainerUtil.newHashSet(VcsLogUtil.getFilteredFilesForRoot(root, filterCollection)));
            }
            List matchingCommits = entry.getValue().getCommitsMatchingFilter(root, rootSpecificCollection, maxCount);
            logs.addAll(ContainerUtil.map((Collection)matchingCommits, (Function)new Function<TimedVcsCommit, CommitId>(){

                public CommitId fun(TimedVcsCommit commit) {
                    return new CommitId((Hash)commit.getId(), root);
                }
            }));
        }
        return logs;
    }

    @NotNull
    private static VcsLogFilterCollection replaceStructureFilter(@NotNull VcsLogFilterCollection filterCollection, @NotNull Set<FilePath> files) {
        return new VcsLogFilterCollectionImpl(filterCollection.getBranchFilter(), filterCollection.getUserFilter(), filterCollection.getHashFilter(), filterCollection.getDateFilter(), filterCollection.getTextFilter(), new VcsLogStructureFilterImpl((Collection<FilePath>)files), filterCollection.getRootFilter());
    }

    @Nullable
    private Set<Integer> getMatchedCommitIndex(@Nullable Collection<CommitId> commits) {
        if (commits == null) {
            return null;
        }
        return ContainerUtil.map2Set(commits, (Function)new Function<CommitId, Integer>(){

            public Integer fun(CommitId commitId) {
                return VisiblePackBuilder.this.myHashMap.getCommitIndex(commitId.getHash(), commitId.getRoot());
            }
        });
    }
}

