/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.EmptyVisibleGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VisiblePack
implements VcsLogDataPack {
    public static final VisiblePack EMPTY = new VisiblePack(DataPack.EMPTY, EmptyVisibleGraph.getInstance(), false, VcsLogFilterCollectionImpl.EMPTY);
    @NotNull
    private final DataPack myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;
    @NotNull
    private final VcsLogFilterCollection myFilters;

    VisiblePack(@NotNull DataPack dataPack, @NotNull VisibleGraph<Integer> graph, boolean canRequestMore, @NotNull VcsLogFilterCollection filters) {
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph;
        this.myCanRequestMore = canRequestMore;
        this.myFilters = filters;
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        return this.myVisibleGraph;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.myDataPack.getLogProviders();
    }

    @NotNull
    public VcsLogRefs getRefs() {
        return this.myDataPack.getRefs();
    }

    @NotNull
    public RefsModel getRefsModel() {
        return this.myDataPack.getRefsModel();
    }

    @NotNull
    public PermanentGraph<Integer> getPermanentGraph() {
        return this.myDataPack.getPermanentGraph();
    }

    public boolean isFull() {
        return this.myDataPack.isFull();
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        return this.myFilters;
    }
}

