/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsRootsRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogHashMapImpl
implements Disposable,
VcsLogHashMap {
    public static final VcsLogHashMap EMPTY = new VcsLogHashMap(){

        @Override
        public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
            return 0;
        }

        @Override
        @NotNull
        public CommitId getCommitId(int commitIndex) {
            throw new UnsupportedOperationException("Illegal access to empty hash map by index " + commitIndex);
        }

        @Override
        @Nullable
        public CommitId findCommitId(@NotNull Condition<CommitId> string) {
            return null;
        }
    };
    @NotNull
    public static final File LOG_CACHE = new File(PathManager.getSystemPath(), "vcs-log");
    @NotNull
    private static final File LOG_CACHE_APP_DIR = new File(LOG_CACHE, "hashes");
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsLogHashMap.class);
    private static final int VERSION = 2;
    private final PersistentEnumerator<CommitId> myPersistentEnumerator;

    public VcsLogHashMapImpl(final @NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) throws IOException {
        VcsLogHashMapImpl.cleanupOldNaming(project2, logProviders);
        String logId = VcsLogHashMapImpl.calcLogId(project2, logProviders);
        final File mapFile = new File(LOG_CACHE_APP_DIR, logId + "." + 2);
        if (!mapFile.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(LOG_CACHE_APP_DIR, logId));
        }
        Disposer.register((Disposable)project2, (Disposable)this);
        this.myPersistentEnumerator = (PersistentEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<PersistentEnumerator<CommitId>, IOException>(){

            public PersistentEnumerator<CommitId> compute() throws IOException {
                return new PersistentEnumerator(mapFile, (KeyDescriptor)new MyCommitIdKeyDescriptor(project2), Page.PAGE_SIZE);
            }
        }, (File)mapFile);
    }

    @NotNull
    private static String calcLogId(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        int hashcode = VcsLogHashMapImpl.calcLogProvidersHash(logProviders);
        return project2.getLocationHash() + "." + Integer.toHexString(hashcode);
    }

    private static void cleanupOldNaming(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        int hashcode = VcsLogHashMapImpl.calcLogProvidersHash(providers);
        String oldLogId = project2.getName() + "." + hashcode;
        FileUtil.delete((File)new File(LOG_CACHE, oldLogId));
    }

    private static int calcLogProvidersHash(final @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        List sortedRoots = ContainerUtil.sorted(logProviders.keySet(), (Comparator)new Comparator<VirtualFile>(){

            @Override
            public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return StringUtil.join((Collection)sortedRoots, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile root) {
                return root.getPath() + "." + ((VcsLogProvider)logProviders.get(root)).getSupportedVcs().getName();
            }
        }, (String)".").hashCode();
    }

    @Nullable
    private CommitId doGetCommitId(int index) throws IOException {
        return (CommitId)this.myPersistentEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) throws IOException {
        return this.myPersistentEnumerator.enumerate((Object)new CommitId(hash, root));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        try {
            return this.getOrPut(hash, root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public CommitId getCommitId(int commitIndex) {
        try {
            CommitId commitId = this.doGetCommitId(commitIndex);
            if (commitId == null) {
                throw new RuntimeException("Unknown commit index: " + commitIndex);
            }
            return commitId;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public CommitId findCommitId(final @NotNull Condition<CommitId> condition) {
        try {
            final Ref hashRef = Ref.create();
            this.myPersistentEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<CommitId>(){

                protected boolean accept(CommitId commitId) {
                    boolean matches = condition.value((Object)commitId);
                    if (matches) {
                        hashRef.set((Object)commitId);
                    }
                    return matches;
                }
            });
            return (CommitId)hashRef.get();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void flush() {
        this.myPersistentEnumerator.force();
    }

    public void dispose() {
        try {
            this.myPersistentEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static class MyCommitIdKeyDescriptor
    implements KeyDescriptor<CommitId> {
        private final VcsRootsRegistry myRootsRegistry;

        public MyCommitIdKeyDescriptor(@NotNull Project project2) {
            this.myRootsRegistry = (VcsRootsRegistry)ServiceManager.getService((Project)project2, VcsRootsRegistry.class);
        }

        public void save(@NotNull DataOutput out, CommitId value) throws IOException {
            ((HashImpl)value.getHash()).write(out);
            out.writeInt(this.myRootsRegistry.getId(value.getRoot()));
        }

        public CommitId read(@NotNull DataInput in) throws IOException {
            Hash hash = HashImpl.read(in);
            VirtualFile root = this.myRootsRegistry.getRootById(in.readInt());
            if (root == null) {
                return null;
            }
            return new CommitId(hash, root);
        }

        public int getHashCode(CommitId value) {
            return value.hashCode();
        }

        public boolean isEqual(CommitId val1, CommitId val2) {
            return val1.equals((Object)val2);
        }
    }
}

