/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.data.VcsLogFiltererImpl;
import com.intellij.vcs.log.data.VcsLogHashMapImpl;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.util.StopWatch;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogDataHolder
implements Disposable,
VcsLogDataProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogDataHolder.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final BackgroundTaskQueue myDataLoaderQueue;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    @NotNull
    private final VcsLogSettings mySettings;
    private final Map<VirtualFile, VcsUser> myCurrentUser = ContainerUtil.newHashMap();
    private final Consumer<DataPack> myDataPackUpdateHandler;
    @NotNull
    private final Map<Integer, VcsCommitMetadata> myTopCommitsDetailsCache = ContainerUtil.newConcurrentMap();
    private final VcsUserRegistryImpl myUserRegistry;
    private final VcsLogHashMapImpl myHashMap;
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private final VcsLogRefresher myRefresher;
    private final VcsLogFiltererImpl myFilterer;

    public VcsLogDataHolder(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties, @NotNull Consumer<VisiblePack> visiblePackConsumer) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project2;
        this.myLogProviders = logProviders;
        this.myDataLoaderQueue = new BackgroundTaskQueue(project2, "Loading history...");
        this.mySettings = settings;
        this.myUserRegistry = (VcsUserRegistryImpl)ServiceManager.getService((Project)project2, VcsUserRegistry.class);
        try {
            this.myHashMap = new VcsLogHashMapImpl(this.myProject, logProviders);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myMiniDetailsGetter = new MiniDetailsGetter((VcsLogHashMap)this.myHashMap, logProviders, this.myTopCommitsDetailsCache, (Disposable)this);
        this.myDetailsGetter = new CommitDetailsGetter(this.myHashMap, logProviders, this);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
        this.myFilterer = new VcsLogFiltererImpl(this.myProject, this.myLogProviders, this.myHashMap, this.myTopCommitsDetailsCache, this.myDetailsGetter, PermanentGraph.SortType.values()[uiProperties.getBekSortType()], visiblePackConsumer);
        this.myDataPackUpdateHandler = new Consumer<DataPack>(){

            public void consume(DataPack dataPack) {
                VcsLogDataHolder.this.myFilterer.onRefresh(dataPack);
            }
        };
        this.myRefresher = new VcsLogRefresherImpl(this.myProject, this.myHashMap, this.myLogProviders, this.myUserRegistry, this.myTopCommitsDetailsCache, this.myDataPackUpdateHandler, new Consumer<Exception>(){

            public void consume(Exception e) {
                if (!(e instanceof ProcessCanceledException)) {
                    LOG.error((Throwable)e);
                }
            }
        }, this.mySettings.getRecentCommitsCount());
    }

    @NotNull
    public VcsLogFilterer getFilterer() {
        return this.myFilterer;
    }

    @NotNull
    public CommitId getCommitId(int commitIndex) {
        return this.myHashMap.getCommitId(commitIndex);
    }

    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        return this.myHashMap.getCommitIndex(hash, root);
    }

    @NotNull
    public VcsLogHashMapImpl getHashMap() {
        return this.myHashMap;
    }

    public void initialize() {
        final StopWatch initSw = StopWatch.start("initialize");
        this.myDataLoaderQueue.clear();
        this.runInBackground(new ThrowableConsumer<ProgressIndicator, VcsException>(){

            public void consume(ProgressIndicator indicator) throws VcsException {
                VcsLogDataHolder.this.resetState();
                VcsLogDataHolder.this.readCurrentUser();
                DataPack dataPack = VcsLogDataHolder.this.myRefresher.readFirstBlock();
                VcsLogDataHolder.this.myDataPackUpdateHandler.consume((Object)dataPack);
                initSw.report();
            }
        }, "Loading History...");
    }

    private void readCurrentUser() {
        StopWatch sw = StopWatch.start("readCurrentUser");
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.myLogProviders.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                VcsUser me = entry.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        sw.report();
    }

    private void resetState() {
        this.myTopCommitsDetailsCache.clear();
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        return this.myUserRegistry.getUsers();
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        return this.myCurrentUser;
    }

    public boolean isMultiRoot() {
        return this.myLogProviders.size() > 1;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        return this.myLogProviders.keySet();
    }

    @NotNull
    public Collection<VcsLogProvider> getLogProviders() {
        return this.myLogProviders.values();
    }

    @NotNull
    public VcsLogSettings getSettings() {
        return this.mySettings;
    }

    public ContainingBranchesGetter getContainingBranchesGetter() {
        return this.myContainingBranchesGetter;
    }

    private void runInBackground(final ThrowableConsumer<ProgressIndicator, VcsException> task, String title) {
        this.myDataLoaderQueue.run(new Task.Backgroundable(this.myProject, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                try {
                    task.consume((Object)indicator);
                }
                catch (VcsException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void refreshCompletely() {
        this.initialize();
    }

    public void refresh(@NotNull Collection<VirtualFile> roots) {
        this.myRefresher.refresh(roots);
    }

    @Nullable
    public VcsCommitMetadata getTopCommitDetails(@NotNull Integer commitId) {
        return this.myTopCommitsDetailsCache.get(commitId);
    }

    public CommitDetailsGetter getCommitDetailsGetter() {
        return this.myDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        return this.myMiniDetailsGetter;
    }

    public void dispose() {
        this.myDataLoaderQueue.clear();
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        return this.myLogProviders.get(root);
    }

    @NotNull
    public VcsUserRegistryImpl getUserRegistry() {
        return this.myUserRegistry;
    }
}

