/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RefsModel
implements VcsLogRefs {
    @NotNull
    private final Map<VirtualFile, Set<VcsRef>> myRefs;
    @NotNull
    private final VcsLogHashMap myHashMap;
    @NotNull
    private final Collection<VcsRef> myBranches;
    @NotNull
    private final MultiMap<CommitId, VcsRef> myRefsToHashes;
    @NotNull
    private final TIntObjectHashMap<SmartList<VcsRef>> myRefsToIndices;

    public RefsModel(@NotNull Map<VirtualFile, Set<VcsRef>> refsByRoot, @NotNull VcsLogHashMap hashMap) {
        this.myRefs = refsByRoot;
        this.myHashMap = hashMap;
        List allRefs = ContainerUtil.concat(refsByRoot.values());
        this.myBranches = ContainerUtil.filter((Collection)allRefs, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getType().isBranch();
            }
        });
        this.myRefsToHashes = RefsModel.prepareRefsMap(allRefs);
        this.myRefsToIndices = this.prepareRefsToIndicesMap(allRefs);
    }

    @NotNull
    private TIntObjectHashMap<SmartList<VcsRef>> prepareRefsToIndicesMap(@NotNull Collection<VcsRef> refs) {
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (VcsRef ref : refs) {
            int index = this.myHashMap.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            SmartList list = (SmartList)map.get(index);
            if (list == null) {
                list = new SmartList();
                map.put(index, (Object)list);
            }
            list.add((Object)ref);
        }
        return map;
    }

    @NotNull
    private static MultiMap<CommitId, VcsRef> prepareRefsMap(@NotNull Collection<VcsRef> refs) {
        MultiMap map = MultiMap.createSmart();
        for (VcsRef ref : refs) {
            map.putValue((Object)new CommitId(ref.getCommitHash(), ref.getRoot()), (Object)ref);
        }
        return map;
    }

    @NotNull
    public Collection<VcsRef> refsToCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        CommitId commitId = new CommitId(hash, root);
        if (this.myRefsToHashes.containsKey((Object)commitId)) {
            return this.myRefsToHashes.get((Object)commitId);
        }
        return Collections.emptyList();
    }

    @NotNull
    public Collection<VcsRef> refsToCommit(int index) {
        return this.myRefsToIndices.containsKey(index) ? (Collection)this.myRefsToIndices.get(index) : Collections.emptyList();
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        return this.myBranches;
    }

    @NotNull
    public Collection<VcsRef> getAllRefs() {
        return new ArrayList<VcsRef>(this.myRefsToHashes.values());
    }

    @NotNull
    public Map<VirtualFile, Set<VcsRef>> getAllRefsByRoot() {
        return this.myRefs;
    }
}

