/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogHashMapImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.util.StopWatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DataPack {
    public static final DataPack EMPTY = DataPack.createEmptyInstance();
    @NotNull
    private final RefsModel myRefsModel;
    @NotNull
    private final PermanentGraph<Integer> myPermanentGraph;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    private boolean myFull;

    DataPack(@NotNull RefsModel refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, boolean full) {
        this.myRefsModel = refsModel;
        this.myPermanentGraph = permanentGraph;
        this.myLogProviders = providers;
        this.myFull = full;
    }

    @NotNull
    static DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, Set<VcsRef>> refs, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogHashMap hashMap, boolean full) {
        RefsModel refsModel = new RefsModel(refs, hashMap);
        PermanentGraph<Integer> graph = DataPack.buildPermanentGraph(commits, refsModel, hashMap, providers);
        return new DataPack(refsModel, graph, providers, full);
    }

    @NotNull
    private static PermanentGraph<Integer> buildPermanentGraph(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull RefsModel refsModel, final @NotNull VcsLogHashMap hashMap, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (commits.isEmpty()) {
            return EmptyPermanentGraph.getInstance();
        }
        NotNullFunction<Integer, Hash> hashGetter = new NotNullFunction<Integer, Hash>(){

            @NotNull
            public Hash fun(Integer commitIndex) {
                return hashMap.getCommitId(commitIndex).getHash();
            }
        };
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(refsModel, hashGetter, DataPack.getRefManagerMap(providers));
        Set<Integer> branches = DataPack.getBranchCommitHashIndexes(refsModel.getAllRefs(), hashMap);
        StopWatch sw = StopWatch.start("building graph");
        PermanentGraphImpl<Integer> permanentGraph = PermanentGraphImpl.newInstance(commits, colorManager, branches);
        sw.report();
        return permanentGraph;
    }

    @NotNull
    private static Set<Integer> getBranchCommitHashIndexes(@NotNull Collection<VcsRef> allRefs, @NotNull VcsLogHashMap hashMap) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (VcsRef vcsRef : allRefs) {
            if (!vcsRef.getType().isBranch()) continue;
            result.add(hashMap.getCommitIndex(vcsRef.getCommitHash(), vcsRef.getRoot()));
        }
        return result;
    }

    @NotNull
    private static Map<VirtualFile, VcsLogRefManager> getRefManagerMap(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        HashMap map = ContainerUtil.newHashMap();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getReferenceManager());
        }
        return map;
    }

    @NotNull
    private static DataPack createEmptyInstance() {
        RefsModel emptyModel = new RefsModel(Collections.emptyMap(), VcsLogHashMapImpl.EMPTY);
        return new DataPack(emptyModel, EmptyPermanentGraph.getInstance(), Collections.emptyMap(), false);
    }

    @NotNull
    public VcsLogRefs getRefs() {
        return this.myRefsModel;
    }

    @NotNull
    public RefsModel getRefsModel() {
        return this.myRefsModel;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.myLogProviders;
    }

    @NotNull
    public PermanentGraph<Integer> getPermanentGraph() {
        return this.myPermanentGraph;
    }

    public boolean isFull() {
        return this.myFull;
    }

    public String toString() {
        return "{DataPack. " + this.myPermanentGraph.getAllCommits().size() + " commits in " + this.myLogProviders.keySet().size() + " roots}";
    }
}

