/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter
implements VcsLogListener {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<Task> myTaskExecutor;
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private SLRUMap<CommitId, List<String>> myCache = ContainingBranchesGetter.createCache();
    @NotNull
    private Map<VirtualFile, ContainedInBranchCondition> myConditions = ContainerUtil.newHashMap();
    @Nullable
    private Runnable myLoadingFinishedListener;
    private int myCurrentBranchesChecksum;
    @Nullable
    private VcsLogRefs myRefs;
    @Nullable
    private PermanentGraph<Integer> myGraph;

    ContainingBranchesGetter(@NotNull VcsLogDataHolder dataHolder, @NotNull Disposable parentDisposable) {
        this.myDataHolder = dataHolder;
        this.myTaskExecutor = new SequentialLimitedLifoExecutor<Task>(parentDisposable, 10, new ThrowableConsumer<Task, Throwable>(){

            public void consume(final Task task) throws Throwable {
                final List<String> branches = task.getContainingBranches(ContainingBranchesGetter.this.myDataHolder);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        task.cache.put((Object)new CommitId(task.hash, task.root), (Object)branches);
                        ContainingBranchesGetter.this.notifyListener();
                    }
                });
            }
        });
    }

    public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        if (refreshHappened) {
            this.myRefs = dataPack.getRefs();
            Collection currentBranches = this.myRefs.getBranches();
            int checksum = currentBranches.hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
            this.myGraph = dataPack.getPermanentGraph();
        }
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        Map<VirtualFile, ContainedInBranchCondition> conditions = this.myConditions;
        this.myConditions = ContainerUtil.newHashMap();
        for (ContainedInBranchCondition c : conditions.values()) {
            c.dispose();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ContainingBranchesGetter.this.notifyListener();
            }
        });
    }

    public void setTaskCompletedListener(@NotNull Runnable runnable2) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListener = runnable2;
    }

    private void notifyListener() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        if (this.myLoadingFinishedListener != null) {
            this.myLoadingFinishedListener.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        List refs = (List)this.myCache.get((Object)new CommitId(hash, root));
        if (refs == null) {
            this.myTaskExecutor.queue(new Task(root, hash, this.myCache, this.myGraph, this.myRefs));
        }
        return refs;
    }

    public List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.myCache.get((Object)new CommitId(hash, root));
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(final @NotNull String branchName, final @NotNull VirtualFile root) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        if (this.myRefs == null || this.myGraph == null) {
            return Conditions.alwaysFalse();
        }
        VcsRef branchRef = (VcsRef)ContainerUtil.find((Iterable)this.myRefs.getBranches(), (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef vcsRef) {
                return vcsRef.getRoot().equals(root) && vcsRef.getName().equals(branchName);
            }
        });
        if (branchRef == null) {
            return Conditions.alwaysFalse();
        }
        ContainedInBranchCondition condition = this.myConditions.get(root);
        if (condition == null || !condition.getBranch().equals(branchName)) {
            condition = new ContainedInBranchCondition((Condition<Integer>)this.myGraph.getContainedInBranchCondition(Collections.singleton(this.myDataHolder.getCommitIndex(branchRef.getCommitHash(), branchRef.getRoot()))), branchName);
            this.myConditions.put(root, condition);
        }
        return condition;
    }

    @NotNull
    private static SLRUMap<CommitId, List<String>> createCache() {
        return new SLRUMap(1000, 1000);
    }

    private class ContainedInBranchCondition
    implements Condition<CommitId> {
        @NotNull
        private final Condition<Integer> myCondition;
        @NotNull
        private final String myBranch;
        private volatile boolean isDisposed = false;

        public ContainedInBranchCondition(@NotNull Condition<Integer> condition, String branch) {
            this.myCondition = condition;
            this.myBranch = branch;
        }

        @NotNull
        public String getBranch() {
            return this.myBranch;
        }

        public boolean value(CommitId commitId) {
            if (this.isDisposed) {
                return false;
            }
            return this.myCondition.value((Object)ContainingBranchesGetter.this.myDataHolder.getCommitIndex(commitId.getHash(), commitId.getRoot()));
        }

        public void dispose() {
            this.isDisposed = true;
        }
    }

    private static class Task {
        private final VirtualFile root;
        private final Hash hash;
        private final SLRUMap<CommitId, List<String>> cache;
        @Nullable
        private final VcsLogRefs refs;
        @Nullable
        private final PermanentGraph<Integer> graph;

        public Task(VirtualFile root, Hash hash, SLRUMap<CommitId, List<String>> cache, @Nullable PermanentGraph<Integer> graph, @Nullable VcsLogRefs refs) {
            this.root = root;
            this.hash = hash;
            this.cache = cache;
            this.graph = graph;
            this.refs = refs;
        }

        @NotNull
        public List<String> getContainingBranches(VcsLogDataHolder dataHolder) {
            try {
                VcsLogProvider provider = dataHolder.getLogProvider(this.root);
                if (this.graph != null && this.refs != null && ((Boolean)VcsLogProperties.get((VcsLogProvider)provider, (VcsLogProperties.VcsLogProperty)VcsLogProperties.LIGHTWEIGHT_BRANCHES)).booleanValue()) {
                    Set branchesIndexes = this.graph.getContainingBranches((Object)dataHolder.getCommitIndex(this.hash, this.root));
                    Collection branchesRefs = new HashSet();
                    for (Integer index : branchesIndexes) {
                        branchesRefs.addAll(this.refs.refsToCommit(index.intValue()));
                    }
                    branchesRefs = ContainerUtil.sorted(branchesRefs, (Comparator)provider.getReferenceManager().getLabelsOrderComparator());
                    ArrayList<String> branchesList = new ArrayList<String>();
                    for (VcsRef ref : branchesRefs) {
                        if (!ref.getType().isBranch()) continue;
                        branchesList.add(ref.getName());
                    }
                    return branchesList;
                }
                ArrayList<String> branches = new ArrayList<String>(provider.getContainingBranches(this.root, this.hash));
                Collections.sort(branches);
                return branches;
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                return Collections.emptyList();
            }
        }
    }
}

