/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.reflect;

import com.intellij.util.ParameterizedTypeImpl;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomExtensionsRegistrarImpl
implements DomExtensionsRegistrar {
    private final List<DomExtensionImpl> myAttributes = new SmartList();
    private final List<DomExtensionImpl> myFixeds = new SmartList();
    private final List<DomExtensionImpl> myCollections = new SmartList();
    private final Set<Object> myDependencies = new THashSet();
    private final List<DomExtensionImpl> myCustoms = new SmartList();

    public List<DomExtensionImpl> getAttributes() {
        return this.myAttributes;
    }

    public List<DomExtensionImpl> getFixeds() {
        return this.myFixeds;
    }

    public List<DomExtensionImpl> getCollections() {
        return this.myCollections;
    }

    public List<DomExtensionImpl> getCustoms() {
        return this.myCustoms;
    }

    @NotNull
    public final DomExtension registerFixedNumberChildrenExtension(@NotNull XmlName name, @NotNull Type type, int count) {
        assert (count > 0);
        return DomExtensionsRegistrarImpl.addExtension(this.myFixeds, name, type).setCount(count);
    }

    @NotNull
    public DomExtension registerFixedNumberChildExtension(@NotNull XmlName name, @NotNull Type type) {
        return this.registerFixedNumberChildrenExtension(name, type, 1);
    }

    @NotNull
    public DomExtension registerCollectionChildrenExtension(@NotNull XmlName name, @NotNull Type type) {
        return DomExtensionsRegistrarImpl.addExtension(this.myCollections, name, type);
    }

    @NotNull
    public DomExtension registerGenericAttributeValueChildExtension(@NotNull XmlName name, Type parameterType) {
        return DomExtensionsRegistrarImpl.addExtension(this.myAttributes, name, (Type)new ParameterizedTypeImpl(GenericAttributeValue.class, new Type[]{parameterType}));
    }

    @NotNull
    public DomExtension registerAttributeChildExtension(@NotNull XmlName name, @NotNull Type type) {
        assert (GenericAttributeValue.class.isAssignableFrom(ReflectionUtil.getRawType((Type)type)));
        return DomExtensionsRegistrarImpl.addExtension(this.myAttributes, name, type);
    }

    @NotNull
    public DomExtension registerCustomChildrenExtension(@NotNull Type type) {
        return this.registerCustomChildrenExtension(type, CustomDomChildrenDescription.AttributeDescriptor.EMPTY);
    }

    @NotNull
    public DomExtension registerCustomChildrenExtension(@NotNull Type type, @NotNull CustomDomChildrenDescription.TagNameDescriptor descriptor) {
        DomExtensionImpl extension = DomExtensionsRegistrarImpl.addExtension(this.myCustoms, null, type);
        extension.setTagNameDescriptor(descriptor);
        return extension;
    }

    @NotNull
    public DomExtension registerCustomChildrenExtension(@NotNull Type type, @NotNull CustomDomChildrenDescription.AttributeDescriptor attributeDescriptor) {
        DomExtensionImpl extension = DomExtensionsRegistrarImpl.addExtension(this.myCustoms, null, type);
        extension.setAttributesDescriptor(attributeDescriptor);
        return extension;
    }

    private static DomExtensionImpl addExtension(List<DomExtensionImpl> list, @Nullable XmlName name, Type type) {
        DomExtensionImpl extension = new DomExtensionImpl(type, name);
        list.add(extension);
        return extension;
    }

    public final void addDependencies(Object[] deps) {
        ContainerUtil.addAll(this.myDependencies, (Object[])deps);
    }

    public Object[] getDependencies() {
        return this.myDependencies.toArray();
    }
}

