/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhysicalDomParentStrategy
implements DomParentStrategy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.PhysicalDomParentStrategy");
    private XmlElement myElement;
    private final DomManagerImpl myDomManager;

    public PhysicalDomParentStrategy(@NotNull XmlElement element, DomManagerImpl domManager) {
        this.myElement = element;
        this.myDomManager = domManager;
    }

    @Override
    public DomInvocationHandler getParentHandler() {
        XmlTag parentTag = PhysicalDomParentStrategy.getParentTag(this.myElement);
        assert (parentTag != null);
        return this.myDomManager.getDomHandler((XmlElement)parentTag);
    }

    @Nullable
    public static XmlTag getParentTag(XmlElement xmlElement) {
        return (XmlTag)PhysicalDomParentStrategy.getParentTagCandidate(xmlElement);
    }

    @Nullable
    public static PsiElement getParentTagCandidate(XmlElement xmlElement) {
        PsiElement parent = xmlElement.getParent();
        return parent instanceof XmlEntityRef ? parent.getParent() : parent;
    }

    @Override
    @NotNull
    public final XmlElement getXmlElement() {
        return this.myElement;
    }

    @Override
    @NotNull
    public DomParentStrategy refreshStrategy(DomInvocationHandler handler2) {
        return this;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        this.myElement = element;
        return this;
    }

    public String toString() {
        return "Physical:" + this.myElement;
    }

    @Override
    @NotNull
    public DomParentStrategy clearXmlElement() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        return new VirtualDomParentStrategy(parent);
    }

    @Override
    public String checkValidity() {
        return this.myElement.isValid() ? null : "Invalid PSI";
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler handler2) {
        return DomImplUtil.getFile(handler2);
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    public boolean equals(Object o) {
        return PhysicalDomParentStrategy.strategyEquals(this, o);
    }

    public static boolean strategyEquals(DomParentStrategy strategy, Object o) {
        if (strategy == o) {
            return true;
        }
        if (!(o instanceof DomParentStrategy)) {
            return false;
        }
        XmlElement thatElement = ((DomParentStrategy)o).getXmlElement();
        if (thatElement == null) {
            return false;
        }
        XmlElement element = strategy.getXmlElement();
        if (element == null) {
            return false;
        }
        if (PhysicalDomParentStrategy.xmlElementsEqual((PsiElement)element, (PsiElement)thatElement)) {
            PsiElement nav2;
            PsiElement nav1;
            if (element != thatElement && (nav1 = element.getNavigationElement()) != (nav2 = thatElement.getNavigationElement())) {
                PsiElement curContext = PhysicalDomParentStrategy.findIncluder((PsiElement)element);
                PsiElement navContext = PhysicalDomParentStrategy.findIncluder(nav1);
                LOG.error((Object)LogMessageEx.createEvent("x:include processing error", "nav1,nav2=" + nav1 + ", " + nav2 + ";\n" + nav1.getContainingFile() + ":" + nav1.getTextRange().getStartOffset() + "!=" + nav2.getContainingFile() + ":" + nav2.getTextRange().getStartOffset() + ";\n" + (nav1 == element) + ";" + (nav2 == thatElement) + ";\n" + "contexts equal: " + (curContext == navContext) + ";\n" + "curContext?.physical=" + (curContext != null && curContext.isPhysical()) + ";\n" + "navContext?.physical=" + (navContext != null && navContext.isPhysical()) + ";\n" + "myElement.physical=" + element.isPhysical() + ";\n" + "thatElement.physical=" + thatElement.isPhysical() + "\n" + DebugUtil.currentStackTrace(), new Attachment("Including tag text 1.xml", curContext == null ? "null" : curContext.getText()), new Attachment("Including tag text 2.xml", navContext == null ? "null" : navContext.getText())));
                throw new AssertionError();
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement findIncluder(PsiElement cur) {
        while (cur != null && !cur.isPhysical()) {
            cur = cur.getParent();
        }
        return cur;
    }

    private static boolean xmlElementsEqual(@NotNull PsiElement fst, @NotNull PsiElement snd) {
        if (fst.equals(snd)) {
            return true;
        }
        if (fst.isValid() && fst.isPhysical() || snd.isValid() && snd.isPhysical()) {
            return false;
        }
        if (fst.getTextLength() != snd.getTextLength()) {
            return false;
        }
        if (fst.getStartOffsetInParent() != snd.getStartOffsetInParent()) {
            return false;
        }
        PsiElement nav1 = fst.getNavigationElement();
        PsiElement nav2 = snd.getNavigationElement();
        return nav1 != null && nav1.equals(nav2);
    }

    public int hashCode() {
        if (!this.myElement.isPhysical()) {
            return this.myElement.getNavigationElement().hashCode();
        }
        return this.myElement.hashCode();
    }
}

