/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomCustomAnnotationChecker;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtendsClassChecker
extends DomCustomAnnotationChecker<ExtendClass> {
    private static final GenericValueReferenceProvider ourProvider = new GenericValueReferenceProvider();

    @NotNull
    public Class<ExtendClass> getAnnotationClass() {
        return ExtendClass.class;
    }

    public List<DomElementProblemDescriptor> checkForProblems(@NotNull ExtendClass extend, @NotNull DomElement _element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (!(_element instanceof GenericDomValue)) {
            return Collections.emptyList();
        }
        GenericDomValue element = (GenericDomValue)_element;
        if (!ExtendsClassChecker.isPsiClassType(element)) {
            return Collections.emptyList();
        }
        Object valueObject = element.getValue();
        PsiClass psiClass = null;
        if (valueObject instanceof PsiClass) {
            psiClass = (PsiClass)valueObject;
        } else if (valueObject instanceof PsiClassType) {
            psiClass = ((PsiClassType)valueObject).resolve();
        }
        if (psiClass != null) {
            return ExtendsClassChecker.checkExtendClass(element, psiClass, extend.value(), extend.instantiatable(), extend.canBeDecorator(), extend.allowInterface(), extend.allowNonPublic(), extend.allowAbstract(), extend.allowEnum(), holder);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<DomElementProblemDescriptor> checkExtendClass(GenericDomValue element, PsiClass value, String name, boolean instantiatable, boolean canBeDecorator, boolean allowInterface, boolean allowNonPublic, boolean allowAbstract, boolean allowEnum, DomElementAnnotationHolder holder) {
        Project project2 = element.getManager().getProject();
        PsiClass extendClass = JavaPsiFacade.getInstance((Project)project2).findClass(name, GlobalSearchScope.allScope((Project)project2));
        SmartList list = new SmartList();
        if (extendClass != null && !name.equals(value.getQualifiedName()) && !value.isInheritor(extendClass, true)) {
            String message = DomBundle.message((String)"class.is.not.a.subclass", (Object[])new Object[]{value.getQualifiedName(), extendClass.getQualifiedName()});
            list.add((Object)holder.createProblem((DomElement)element, message, new LocalQuickFix[0]));
        }
        if (instantiatable) {
            if (value.hasModifierProperty("abstract")) {
                list.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.is.not.concrete", (Object[])new Object[]{value.getQualifiedName()}), new LocalQuickFix[0]));
            } else if (!allowNonPublic && !value.hasModifierProperty("public")) {
                list.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.is.not.public", (Object[])new Object[]{value.getQualifiedName()}), new LocalQuickFix[0]));
            } else if (!PsiUtil.hasDefaultConstructor((PsiClass)value, (boolean)true)) {
                if (canBeDecorator) {
                    boolean hasConstructor = false;
                    for (PsiMethod method : value.getConstructors()) {
                        PsiClass psiClass;
                        PsiType psiType;
                        PsiTypeElement typeElement;
                        PsiParameterList psiParameterList = method.getParameterList();
                        if (psiParameterList.getParametersCount() != 1 || (typeElement = psiParameterList.getParameters()[0].getTypeElement()) == null || !((psiType = typeElement.getType()) instanceof PsiClassType) || (psiClass = ((PsiClassType)psiType).resolve()) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)extendClass, (boolean)true)) continue;
                        hasConstructor = true;
                        break;
                    }
                    if (!hasConstructor) {
                        list.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.decorator.or.has.default.constructor", (Object[])new Object[]{value.getQualifiedName()}), new LocalQuickFix[0]));
                    }
                } else {
                    list.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.has.no.default.constructor", (Object[])new Object[]{value.getQualifiedName()}), new LocalQuickFix[0]));
                }
            }
        }
        if (!allowInterface && value.isInterface()) {
            list.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"interface.not.allowed", (Object[])new Object[]{value.getQualifiedName()}), new LocalQuickFix[0]));
        }
        if (!allowEnum && value.isEnum()) {
            list.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"enum.not.allowed", (Object[])new Object[]{value.getQualifiedName()}), new LocalQuickFix[0]));
        }
        if (!allowAbstract && value.hasModifierProperty("abstract") && !value.isInterface()) {
            list.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"abstract.class.not.allowed", (Object[])new Object[]{value.getQualifiedName()}), new LocalQuickFix[0]));
        }
        return list;
    }

    public static List<DomElementProblemDescriptor> checkExtendsClassInReferences(GenericDomValue element, DomElementAnnotationHolder holder) {
        PsiReference[] references;
        if (!ExtendsClassChecker.isPsiClassType(element)) {
            return Collections.emptyList();
        }
        Object valueObject = element.getValue();
        if (!(valueObject instanceof PsiClass)) {
            return Collections.emptyList();
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)element);
        if (valueElement == null) {
            return Collections.emptyList();
        }
        for (PsiReference reference : references = ourProvider.getReferencesByElement((PsiElement)valueElement, new ProcessingContext())) {
            String[] value;
            if (!(reference instanceof JavaClassReference)) continue;
            PsiReferenceProvider psiReferenceProvider = ((JavaClassReference)reference).getProvider();
            String[] stringArray = value = psiReferenceProvider instanceof JavaClassReferenceProvider ? JavaClassReferenceProvider.EXTEND_CLASS_NAMES.getValue(((JavaClassReferenceProvider)psiReferenceProvider).getOptions()) : null;
            if (value == null || value.length == 0) continue;
            for (String className : value) {
                List<DomElementProblemDescriptor> problemDescriptors = ExtendsClassChecker.checkExtendClass(element, (PsiClass)valueObject, className, false, false, true, false, true, true, holder);
                if (problemDescriptors.isEmpty()) continue;
                return problemDescriptors;
            }
        }
        return Collections.emptyList();
    }

    private static boolean isPsiClassType(GenericDomValue element) {
        Class genericValueParameter = DomUtil.getGenericValueParameter((Type)element.getDomElementType());
        return genericValueParameter != null && (ReflectionUtil.isAssignable((Class)genericValueParameter, PsiClass.class) || ReflectionUtil.isAssignable((Class)genericValueParameter, PsiType.class));
    }
}

