/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.DummyEvaluatedXmlName;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.ConvertAnnotationImpl;
import com.intellij.util.xml.impl.CustomDomChildrenDescriptionImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.DynamicGenericInfo;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.GetInvocation;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.SetInvocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.StubParentStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomInvocationHandler<T extends AbstractDomChildDescriptionImpl, Stub extends DomStub>
extends UserDataHolderBase
implements InvocationHandler,
DomElement,
SemElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomInvocationHandler");
    public static final Method ACCEPT_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"accept", (Class[])new Class[]{DomElementVisitor.class});
    public static final Method ACCEPT_CHILDREN_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"acceptChildren", (Class[])new Class[]{DomElementVisitor.class});
    private static final JavaMethod ourGetValue = JavaMethod.getMethod(GenericValue.class, (JavaMethodSignature)new JavaMethodSignature("getValue", new Class[0]));
    private final Type myType;
    private final DomManagerImpl myManager;
    private final EvaluatedXmlName myTagName;
    private final T myChildDescription;
    private DomParentStrategy myParentStrategy;
    private volatile long myLastModCount;
    private volatile DomElement myProxy;
    private DomGenericInfoEx myGenericInfo;
    private final InvocationCache myInvocationCache;
    private volatile Converter myScalarConverter = null;
    private volatile SmartFMap<Method, Invocation> myAccessorInvocations = SmartFMap.emptyMap();
    @Nullable
    protected Stub myStub;

    protected DomInvocationHandler(Type type, DomParentStrategy parentStrategy, @NotNull EvaluatedXmlName tagName, T childDescription, DomManagerImpl manager, boolean dynamic, @Nullable Stub stub) {
        this.myManager = manager;
        this.myParentStrategy = parentStrategy;
        this.myTagName = tagName;
        this.myChildDescription = childDescription;
        this.myStub = stub;
        this.myLastModCount = manager.getPsiModificationCount();
        this.myType = this.narrowType(type);
        this.myInvocationCache = manager.getApplicationComponent().getInvocationCache(this.getRawType());
        this.refreshGenericInfo(dynamic);
        if (stub != null) {
            ((DomStub)((Object)stub)).setHandler(this);
        }
    }

    protected Type narrowType(@NotNull Type nominalType) {
        return nominalType;
    }

    @Nullable
    public DomElement getParent() {
        DomInvocationHandler handler2 = this.getParentHandler();
        return handler2 == null ? null : handler2.getProxy();
    }

    protected final void assertValid() {
        String s = this.checkValidity();
        if (s != null) {
            throw new AssertionError((Object)(this.myType.toString() + " @" + this.hashCode() + "\nclass=" + ((Object)((Object)this)).getClass() + "\nxml=" + this.getXmlElement() + "; " + s));
        }
    }

    @Nullable
    final DomInvocationHandler getParentHandler() {
        return this.getParentStrategy().getParentHandler();
    }

    @Nullable
    public Stub getStub() {
        return this.myStub;
    }

    @NotNull
    public final Type getDomElementType() {
        return this.myType;
    }

    @Nullable
    protected String getValue() {
        XmlTag tag = this.getXmlTag();
        return tag == null ? null : DomInvocationHandler.getTagValue(tag);
    }

    protected void setValue(final @Nullable String value) {
        final XmlTag tag = this.ensureTagExists();
        this.myManager.runChange(new Runnable(){

            @Override
            public void run() {
                DomInvocationHandler.setTagValue(tag, value);
            }
        });
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
    }

    public void copyFrom(final DomElement other) {
        if (other == this.getProxy()) {
            return;
        }
        assert (other.getDomElementType().equals(this.myType)) : "Can't copy from " + other.getDomElementType() + " to " + this.myType;
        if (other.getXmlElement() == null) {
            this.undefine();
            return;
        }
        this.myManager.performAtomicChange(new Runnable(){

            @Override
            public void run() {
                DomInvocationHandler.this.ensureXmlElementExists();
                DomInvocationHandler otherInvocationHandler = DomManagerImpl.getDomInvocationHandler(other);
                assert (otherInvocationHandler != null) : other;
                DomGenericInfoEx genericInfo = otherInvocationHandler.getGenericInfo();
                for (AttributeChildDescriptionImpl description : genericInfo.getAttributeChildrenDescriptions()) {
                    description.getDomAttributeValue(DomInvocationHandler.this).setStringValue(description.getDomAttributeValue(other).getStringValue());
                }
                for (AttributeChildDescriptionImpl description : genericInfo.getFixedChildrenDescriptions()) {
                    List list = description.getValues(DomInvocationHandler.this.getProxy());
                    List otherValues = description.getValues(other);
                    for (int i = 0; i < list.size(); ++i) {
                        DomElement otherValue = (DomElement)otherValues.get(i);
                        DomElement value = (DomElement)list.get(i);
                        if (!DomUtil.hasXml((DomElement)otherValue)) {
                            value.undefine();
                            continue;
                        }
                        value.copyFrom(otherValue);
                    }
                }
                for (AttributeChildDescriptionImpl description : genericInfo.getCollectionChildrenDescriptions()) {
                    for (DomElement value : description.getValues(DomInvocationHandler.this.getProxy())) {
                        value.undefine();
                    }
                    for (DomElement otherValue : description.getValues(other)) {
                        description.addValue(DomInvocationHandler.this.getProxy(), otherValue.getDomElementType()).copyFrom(otherValue);
                    }
                }
                String stringValue = otherInvocationHandler.getValue();
                if (StringUtil.isNotEmpty((String)stringValue)) {
                    DomInvocationHandler.this.setValue(stringValue);
                }
            }
        });
        if (!this.myManager.getSemService().isInsideAtomicChange()) {
            this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
        }
    }

    public <T extends DomElement> T createStableCopy() {
        XmlTag tag = this.getXmlTag();
        if (tag != null && tag.isPhysical()) {
            DomElement existing = this.myManager.getDomElement(tag);
            assert (existing != null) : existing + "\n---------\n" + tag.getParent().getText() + "\n-----------\n" + tag.getText();
            assert (this.getProxy().equals(existing)) : existing + "\n---------\n" + tag.getParent().getText() + "\n-----------\n" + tag.getText() + "\n----\n" + (Object)((Object)this) + " != " + (Object)((Object)DomManagerImpl.getDomInvocationHandler(existing));
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myManager.getProject()).createSmartPsiElementPointer((PsiElement)tag);
            return this.myManager.createStableValue(new StableCopyFactory((SmartPsiElementPointer<XmlTag>)pointer, this.myType, ((Object)((Object)this)).getClass()));
        }
        return (T)this.createPathStableCopy();
    }

    protected DomElement createPathStableCopy() {
        throw new UnsupportedOperationException();
    }

    public final <T extends DomElement> T createMockCopy(boolean physical) {
        Object copy = this.myManager.createMockElement(this.getRawType(), this.getProxy().getModule(), physical);
        copy.copyFrom(this.getProxy());
        return (T)copy;
    }

    @NotNull
    public String getXmlElementNamespace() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "this operation should be performed on the DOM having a physical parent, your DOM may be not very fresh";
        XmlElement element = parent.getXmlElement();
        assert (element != null);
        return this.getXmlName().getNamespace(element, this.getFile());
    }

    @Nullable
    public String getXmlElementNamespaceKey() {
        return this.getXmlName().getXmlName().getNamespaceKey();
    }

    public final Module getModule() {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getFile());
        return module2 != null ? module2 : (Module)DomUtil.getFile((DomElement)this).getUserData(DomManager.MOCK_ELEMENT_MODULE);
    }

    public XmlTag ensureTagExists() {
        this.assertValid();
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            return tag;
        }
        tag = this.setEmptyXmlTag();
        this.setXmlElement((XmlElement)tag);
        DomElement element = this.getProxy();
        this.myManager.fireEvent(new DomEvent(element, true));
        this.addRequiredChildren();
        this.myManager.cacheHandler(this.getCacheKey(), (XmlElement)tag, this);
        return this.getXmlTag();
    }

    public XmlElement getXmlElement() {
        return this.getParentStrategy().getXmlElement();
    }

    public boolean exists() {
        return this.getParentStrategy().isPhysical();
    }

    private DomParentStrategy getParentStrategy() {
        this.myParentStrategy = this.myParentStrategy.refreshStrategy(this);
        return this.myParentStrategy;
    }

    public XmlElement ensureXmlElementExists() {
        return this.ensureTagExists();
    }

    protected final XmlTag createChildTag(EvaluatedXmlName tagName) {
        String localName = tagName.getXmlName().getLocalName();
        if (localName.contains(":")) {
            try {
                return XmlElementFactory.getInstance((Project)this.myManager.getProject()).createTagFromText((CharSequence)("<" + localName + "/>"));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        XmlElement element = this.getXmlElement();
        assert (element != null);
        return this.getXmlTag().createChildTag(localName, tagName.getNamespace(element, this.getFile()), null, false);
    }

    public final boolean isValid() {
        return this.checkValidity() == null;
    }

    String toStringEx() {
        return this.myType.toString() + " @" + this.hashCode() + "&handler=" + super.toString() + "&cd=" + this.myChildDescription + "&ps=" + this.myParentStrategy;
    }

    @Nullable
    protected String checkValidity() {
        ProgressManager.checkCanceled();
        DomParentStrategy parentStrategy = this.getParentStrategy();
        String error = parentStrategy.checkValidity();
        if (error != null) {
            return "Strategy: " + error;
        }
        long modCount = this.myManager.getPsiModificationCount();
        if (this.myLastModCount == modCount) {
            return null;
        }
        XmlElement xmlElement = parentStrategy.getXmlElement();
        if (xmlElement != null) {
            DomInvocationHandler actual = this.myManager.getDomHandler(xmlElement);
            if (!this.equals((Object)actual)) {
                return "element changed: " + this.toStringEx() + "!=" + (actual == null ? null : actual.toStringEx());
            }
            this.myLastModCount = modCount;
            return null;
        }
        DomInvocationHandler parent = this.getParentHandler();
        if (parent == null) {
            return "no parent: " + this.getDomElementType();
        }
        error = parent.checkValidity();
        if (error != null) {
            return "parent: " + error;
        }
        this.myLastModCount = modCount;
        return null;
    }

    @NotNull
    public final DomGenericInfoEx getGenericInfo() {
        return this.myGenericInfo;
    }

    protected abstract void undefineInternal();

    public final void undefine() {
        this.undefineInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteTag(XmlTag tag) {
        boolean changing = this.myManager.setChanging(true);
        try {
            tag.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    protected final void fireUndefinedEvent() {
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
    }

    protected abstract XmlTag setEmptyXmlTag();

    protected void addRequiredChildren() {
        for (AbstractDomChildrenDescription description : this.getGenericInfo().getChildrenDescriptions()) {
            if (description instanceof DomAttributeChildDescription) {
                Required required = (Required)description.getAnnotation(Required.class);
                if (required == null || !required.value()) continue;
                ((DomElement)description.getValues(this.getProxy()).get(0)).ensureXmlElementExists();
                continue;
            }
            if (!(description instanceof DomFixedChildDescription)) continue;
            DomFixedChildDescription childDescription = (DomFixedChildDescription)description;
            List values = null;
            int count = childDescription.getCount();
            for (int i = 0; i < count; ++i) {
                Required required = (Required)childDescription.getAnnotation(i, Required.class);
                if (required == null || !required.value()) continue;
                if (values == null) {
                    values = description.getValues(this.getProxy());
                }
                ((DomElement)values.get(i)).ensureTagExists();
            }
        }
    }

    @NotNull
    public final String getXmlElementName() {
        return this.myTagName.getXmlName().getLocalName();
    }

    @NotNull
    public final EvaluatedXmlName getXmlName() {
        return this.myTagName;
    }

    public void accept(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        this.myManager.getApplicationComponent().getVisitorDescription(visitor.getClass()).acceptElement(visitor, this.getProxy());
    }

    public void acceptChildren(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        DomElement element = this.getProxy();
        List descriptions = this.getGenericInfo().getChildrenDescriptions();
        int descriptionsSize = descriptions.size();
        for (int i = 0; i < descriptionsSize; ++i) {
            AbstractDomChildrenDescription description = (AbstractDomChildrenDescription)descriptions.get(i);
            List values = description.getValues(element);
            int valuesSize = values.size();
            for (int j = 0; j < valuesSize; ++j) {
                DomElement value = (DomElement)values.get(j);
                value.accept(visitor);
            }
        }
    }

    @NotNull
    protected final Converter getScalarConverter() {
        Converter converter = this.myScalarConverter;
        if (converter == null) {
            converter = this.myScalarConverter = this.createConverter(ourGetValue);
        }
        return converter;
    }

    @NotNull
    private Converter createConverter(final JavaMethod method) {
        Converter converter;
        Type returnType = method.getGenericReturnType();
        Type type = returnType == Void.TYPE ? method.getGenericParameterTypes()[0] : returnType;
        Class parameter = DomUtil.substituteGenericType((Type)type, (Type)this.myType);
        if (parameter == null) {
            LOG.error(type + " " + this.myType);
        }
        if ((converter = this.getConverter(new AnnotatedElement(){

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return DomInvocationHandler.this.myInvocationCache.getMethodAnnotation(method, annotationClass);
            }
        }, parameter)) == null && type instanceof TypeVariable) {
            converter = this.getConverter((AnnotatedElement)this, DomUtil.getGenericValueParameter((Type)this.myType));
        }
        if (converter == null) {
            converter = this.myManager.getConverterManager().getConverterByClass(parameter);
        }
        if (converter == null) {
            throw new AssertionError((Object)("No converter specified: String<->" + parameter.getName() + "; method=" + method + "; place=" + this.myChildDescription));
        }
        return converter;
    }

    public final T getChildDescription() {
        return this.myChildDescription;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation;
        AbstractDomChildrenDescription childDescription = this.getChildDescription();
        if (childDescription != null && (annotation = childDescription.getAnnotation(annotationClass)) != null) {
            return (T)annotation;
        }
        return this.getClassAnnotation(annotationClass);
    }

    protected <T extends Annotation> T getClassAnnotation(Class<T> annotationClass) {
        return this.myInvocationCache.getClassAnnotation(annotationClass);
    }

    @Nullable
    private Converter getConverter(AnnotatedElement annotationProvider, Class parameter) {
        Resolve resolveAnnotation = (Resolve)annotationProvider.getAnnotation(Resolve.class);
        if (resolveAnnotation != null) {
            Class aClass = resolveAnnotation.value();
            if (!DomElement.class.equals((Object)aClass)) {
                return DomResolveConverter.createConverter((Class)aClass);
            }
            LOG.assertTrue(parameter != null, (Object)"You should specify @Resolve#value() parameter");
            return DomResolveConverter.createConverter((Class)parameter);
        }
        ConverterManager converterManager = this.myManager.getConverterManager();
        Convert convertAnnotation = (Convert)annotationProvider.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            if (convertAnnotation instanceof ConvertAnnotationImpl) {
                return ((ConvertAnnotationImpl)convertAnnotation).getConverter();
            }
            return converterManager.getConverterInstance(convertAnnotation.value());
        }
        return null;
    }

    @NotNull
    public final DomElement getProxy() {
        DomElement proxy = this.myProxy;
        if (proxy == null) {
            Class[] classArray;
            Class<?> rawType = this.getRawType();
            Class<Object> implementation = this.myManager.getApplicationComponent().getImplementation(rawType);
            boolean isInterface = rawType.isInterface();
            if (implementation == null && !isInterface) {
                implementation = rawType;
            }
            if (isInterface) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = rawType;
            } else {
                classArray = ArrayUtil.EMPTY_CLASS_ARRAY;
            }
            this.myProxy = proxy = AdvancedProxy.createProxy(this, implementation, classArray);
        }
        return proxy;
    }

    @NotNull
    public final XmlFile getFile() {
        return this.getParentStrategy().getContainingFile(this);
    }

    @NotNull
    public DomNameStrategy getNameStrategy() {
        Class<?> rawType = this.getRawType();
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(rawType, this.isAttribute());
        if (strategy != null) {
            return strategy;
        }
        DomInvocationHandler handler2 = this.getParentHandler();
        return handler2 == null ? DomNameStrategy.HYPHEN_STRATEGY : handler2.getNameStrategy();
    }

    protected boolean isAttribute() {
        return false;
    }

    @NotNull
    public ElementPresentation getPresentation() {
        ElementPresentationTemplate template = this.getChildDescription().getPresentationTemplate();
        if (template != null) {
            return template.createPresentation(this.getProxy());
        }
        return new ElementPresentation(){

            public String getElementName() {
                return ElementPresentationManager.getElementName((Object)DomInvocationHandler.this.getProxy());
            }

            public String getTypeName() {
                return ElementPresentationManager.getTypeNameForObject((Object)DomInvocationHandler.this.getProxy());
            }

            public Icon getIcon() {
                return ElementPresentationManager.getIconOld((Object)DomInvocationHandler.this.getProxy());
            }
        };
    }

    public final GlobalSearchScope getResolveScope() {
        return DomUtil.getFile((DomElement)this).getResolveScope();
    }

    private static <T extends DomElement> T _getParentOfType(Class<T> requiredClass, DomElement element) {
        while (element != null && !requiredClass.isInstance(element)) {
            element = element.getParent();
        }
        return (T)element;
    }

    public final <T extends DomElement> T getParentOfType(Class<T> requiredClass, boolean strict) {
        return DomInvocationHandler._getParentOfType(requiredClass, strict ? this.getParent() : this.getProxy());
    }

    @NotNull
    final IndexedElementInvocationHandler getFixedChild(Pair<FixedChildDescriptionImpl, Integer> info) {
        FixedChildDescriptionImpl description = (FixedChildDescriptionImpl)info.first;
        XmlName xmlName = description.getXmlName();
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(xmlName);
        if (this.myStub != null && description.isStubbed()) {
            List<DomStub> stubs = ((DomStub)((Object)this.myStub)).getChildrenByName(xmlName.getLocalName(), xmlName.getNamespaceKey());
            DomStub stub = stubs.isEmpty() ? null : stubs.get(0);
            StubParentStrategy strategy = stub == null ? new StubParentStrategy.Empty((DomStub)((Object)this.myStub)) : new StubParentStrategy(stub);
            return new IndexedElementInvocationHandler(evaluatedXmlName, description, 0, strategy, this.myManager, (ElementStub)stub);
        }
        XmlTag tag = this.getXmlTag();
        int index = (Integer)info.second;
        if (tag != null) {
            if (!tag.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)tag);
            }
            XmlTag[] subTags = tag.getSubTags();
            int subTagsLength = subTags.length;
            for (int i = 0; i < subTagsLength; ++i) {
                XmlTag xmlTag = subTags[i];
                if (xmlTag.isValid()) continue;
                throw new PsiInvalidElementAccessException((PsiElement)xmlTag, "invalid children of valid tag: " + tag.getText() + "; subtag=" + xmlTag + "; index=" + i);
            }
            List<XmlTag> tags = DomImplUtil.findSubTags(subTags, evaluatedXmlName, this.getFile());
            if (tags.size() > index) {
                XmlTag child = tags.get(index);
                IndexedElementInvocationHandler semElement = (IndexedElementInvocationHandler)this.myManager.getSemService().getSemElement(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (PsiElement)child);
                if (semElement == null) {
                    IndexedElementInvocationHandler take2 = (IndexedElementInvocationHandler)this.myManager.getSemService().getSemElement(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (PsiElement)child);
                    throw new AssertionError((Object)("No DOM at XML. Parent=" + tag + "; child=" + child + "; index=" + index + "; second attempt=" + (Object)((Object)take2)));
                }
                return semElement;
            }
        }
        return new IndexedElementInvocationHandler(evaluatedXmlName, description, index, new VirtualDomParentStrategy(this), this.myManager, null);
    }

    @NotNull
    final AttributeChildInvocationHandler getAttributeChild(AttributeChildDescriptionImpl description) {
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(description.getXmlName());
        if (this.myStub != null && description.isStubbed()) {
            AttributeStub stub = ((DomStub)((Object)this.myStub)).getAttributeStub(description.getXmlName());
            StubParentStrategy strategy = StubParentStrategy.createAttributeStrategy(stub, this.myStub);
            return new AttributeChildInvocationHandler(evaluatedXmlName, description, this.myManager, strategy, stub);
        }
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            String ns = evaluatedXmlName.getNamespace((XmlElement)tag, this.getFile());
            XmlAttribute attribute = tag.getAttribute(description.getXmlName().getLocalName(), ns.equals(tag.getNamespace()) ? null : ns);
            if (attribute != null) {
                PsiUtilCore.ensureValid((PsiElement)attribute);
                AttributeChildInvocationHandler semElement = (AttributeChildInvocationHandler)this.myManager.getSemService().getSemElement(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (PsiElement)attribute);
                if (semElement == null) {
                    AttributeChildInvocationHandler take2 = (AttributeChildInvocationHandler)this.myManager.getSemService().getSemElement(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (PsiElement)attribute);
                    throw new AssertionError((Object)("No DOM at XML. Parent=" + tag + "; attribute=" + attribute + "; second attempt=" + (Object)((Object)take2)));
                }
                return semElement;
            }
        }
        return new AttributeChildInvocationHandler(evaluatedXmlName, description, this.myManager, new VirtualDomParentStrategy(this), null);
    }

    @Nullable
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.findInvocation(method).invoke(this, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    @NotNull
    private Invocation findInvocation(Method method) {
        Invocation invocation = (Invocation)this.myAccessorInvocations.get((Object)method);
        if (invocation != null) {
            return invocation;
        }
        invocation = this.myInvocationCache.getInvocation(method);
        if (invocation != null) {
            return invocation;
        }
        JavaMethod javaMethod = this.myInvocationCache.getInternedMethod(method);
        invocation = this.myGenericInfo.createInvocation(javaMethod);
        if (invocation != null) {
            this.myInvocationCache.putInvocation(method, invocation);
            return invocation;
        }
        if (this.myInvocationCache.isTagValueGetter(javaMethod)) {
            invocation = new GetInvocation(this.createConverter(javaMethod));
        } else if (this.myInvocationCache.isTagValueSetter(javaMethod)) {
            invocation = new SetInvocation(this.createConverter(javaMethod));
        } else {
            throw new RuntimeException("No implementation for method " + method.toString() + " in class " + this.myType);
        }
        this.myAccessorInvocations = this.myAccessorInvocations.plus((Object)method, (Object)invocation);
        return invocation;
    }

    private static void setTagValue(XmlTag tag, String value) {
        tag.getValue().setText(value);
    }

    private static String getTagValue(XmlTag tag) {
        return tag.getValue().getTrimmedText();
    }

    public final String toString() {
        if (ReflectionUtil.isAssignable(GenericValue.class, this.getRawType())) {
            return ((GenericValue)this.getProxy()).getStringValue();
        }
        return this.myType.toString() + " @" + this.hashCode();
    }

    public final Class<?> getRawType() {
        return ReflectionUtil.getRawType((Type)this.myType);
    }

    @Nullable
    public XmlTag getXmlTag() {
        return (XmlTag)this.getXmlElement();
    }

    @Nullable
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler parentHandler) {
        return null;
    }

    protected final void detach() {
        this.setXmlElement(null);
    }

    final SemKey getCacheKey() {
        if (this instanceof AttributeChildInvocationHandler) {
            return DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY;
        }
        if (this instanceof DomRootInvocationHandler) {
            return DomManagerImpl.DOM_HANDLER_KEY;
        }
        if (this instanceof IndexedElementInvocationHandler) {
            return DomManagerImpl.DOM_INDEXED_HANDLER_KEY;
        }
        if (this.getChildDescription() instanceof CustomDomChildrenDescription) {
            return DomManagerImpl.DOM_CUSTOM_HANDLER_KEY;
        }
        return DomManagerImpl.DOM_COLLECTION_HANDLER_KEY;
    }

    protected final void setXmlElement(XmlElement element) {
        this.refreshGenericInfo(element != null && !this.isAttribute());
        this.myStub = null;
        this.myParentStrategy = element == null ? this.myParentStrategy.clearXmlElement() : this.myParentStrategy.setXmlElement(element);
    }

    private void refreshGenericInfo(boolean dynamic) {
        StaticGenericInfo staticInfo = this.myManager.getApplicationComponent().getStaticGenericInfo(this.myType);
        this.myGenericInfo = dynamic ? new DynamicGenericInfo(this, staticInfo) : staticInfo;
    }

    @NotNull
    public final DomManagerImpl getManager() {
        return this.myManager;
    }

    public final DomElement addCollectionChild(CollectionChildDescriptionImpl description, Type type, int index) throws IncorrectOperationException {
        EvaluatedXmlName name = this.createEvaluatedXmlName(description.getXmlName());
        XmlTag tag = this.addEmptyTag(name, index);
        CollectionElementInvocationHandler handler2 = new CollectionElementInvocationHandler(type, tag, description, this, null);
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
        this.getManager().getTypeChooserManager().getTypeChooser(description.getType()).distinguishTag(tag, type);
        handler2.addRequiredChildren();
        return handler2.getProxy();
    }

    protected final void createFixedChildrenTags(EvaluatedXmlName tagName, FixedChildDescriptionImpl description, int count) {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < count) {
            this.getFixedChild((Pair<FixedChildDescriptionImpl, Integer>)Pair.create((Object)description, (Object)(count - 1))).ensureTagExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlTag addEmptyTag(EvaluatedXmlName tagName, int index) throws IncorrectOperationException {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < index) {
            index = subTags.size();
        }
        boolean changing = this.myManager.setChanging(true);
        try {
            XmlTag newTag = this.createChildTag(tagName);
            if (index == 0) {
                if (subTags.isEmpty()) {
                    XmlTag xmlTag = (XmlTag)tag.add((PsiElement)newTag);
                    return xmlTag;
                }
                XmlTag xmlTag = (XmlTag)tag.addBefore((PsiElement)newTag, (PsiElement)subTags.get(0));
                return xmlTag;
            }
            XmlTag xmlTag = (XmlTag)tag.addAfter((PsiElement)newTag, (PsiElement)subTags.get(index - 1));
            return xmlTag;
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    @NotNull
    public final EvaluatedXmlName createEvaluatedXmlName(XmlName xmlName) {
        return this.getXmlName().evaluateChildName(xmlName);
    }

    public List<? extends DomElement> getCollectionChildren(final AbstractCollectionChildDescription description) {
        XmlTag tag;
        if (this.myStub != null && description.isStubbed()) {
            if (description instanceof DomChildDescriptionImpl) {
                XmlName xmlName = ((DomChildDescriptionImpl)((Object)description)).getXmlName();
                List<DomStub> stubs = ((DomStub)((Object)this.myStub)).getChildrenByName(xmlName.getLocalName(), xmlName.getNamespaceKey());
                return ContainerUtil.map(stubs, (Function)new Function<DomStub, DomElement>(){

                    public DomElement fun(DomStub stub) {
                        return stub.getOrCreateHandler((DomChildDescriptionImpl)((Object)description), DomInvocationHandler.this.myManager).getProxy();
                    }
                });
            }
            if (description instanceof CustomDomChildrenDescriptionImpl) {
                List<DomStub> stubs = ((DomStub)((Object)this.myStub)).getChildrenStubs();
                return ContainerUtil.mapNotNull(stubs, (Function)new NullableFunction<DomStub, DomElement>(){

                    @Nullable
                    public DomElement fun(DomStub stub) {
                        if (stub instanceof ElementStub && stub.isCustom()) {
                            DummyEvaluatedXmlName name = new DummyEvaluatedXmlName(stub.getName(), "");
                            return new CollectionElementInvocationHandler((EvaluatedXmlName)name, (CustomDomChildrenDescriptionImpl)description, DomInvocationHandler.this.myManager, (ElementStub)stub).getProxy();
                        }
                        return null;
                    }
                });
            }
        }
        if ((tag = this.getXmlTag()) == null) {
            return Collections.emptyList();
        }
        List<XmlTag> subTags = this.getCollectionSubTags(description, tag);
        if (subTags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomElement> elements = new ArrayList<DomElement>(subTags.size());
        for (XmlTag subTag : subTags) {
            SemKey<CollectionElementInvocationHandler> key = description instanceof CustomDomChildrenDescription ? DomManagerImpl.DOM_CUSTOM_HANDLER_KEY : DomManagerImpl.DOM_COLLECTION_HANDLER_KEY;
            DomInvocationHandler semElement = (DomInvocationHandler)this.myManager.getSemService().getSemElement(key, (PsiElement)subTag);
            if (semElement == null) {
                String msg = "No child for subTag '" + subTag.getName() + "' in tag '" + tag.getName() + "' using key " + key + "; subtag count=" + subTags.size();
                DomInvocationHandler anyDom = this.myManager.getDomHandler((XmlElement)subTag);
                if (anyDom != null) {
                    msg = msg + "\n sub-dom=" + (Object)((Object)anyDom) + " with " + anyDom.getChildDescription();
                }
                throw new AssertionError((Object)msg);
            }
            elements.add(semElement.getProxy());
        }
        return Collections.unmodifiableList(elements);
    }

    private List<XmlTag> getCollectionSubTags(@NotNull AbstractCollectionChildDescription description, @NotNull XmlTag tag) {
        if (description instanceof CollectionChildDescriptionImpl) {
            return ((CollectionChildDescriptionImpl)description).getCollectionSubTags(this, tag);
        }
        return DomImplUtil.getCustomSubTags(this, tag.getSubTags(), this.getFile());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        DomInvocationHandler that = (DomInvocationHandler)((Object)o);
        if (!((AbstractDomChildDescriptionImpl)this.myChildDescription).equals(that.myChildDescription)) {
            return false;
        }
        return this.getParentStrategy().equals(that.getParentStrategy());
    }

    public int hashCode() {
        return ((AbstractDomChildDescriptionImpl)this.myChildDescription).hashCode();
    }

    private static class StableCopyFactory<T extends DomElement>
    implements NullableFactory<T> {
        private final SmartPsiElementPointer<XmlTag> myPointer;
        private final Type myType;
        private final Class<? extends DomInvocationHandler> myHandlerClass;

        public StableCopyFactory(SmartPsiElementPointer<XmlTag> pointer, Type type, Class<? extends DomInvocationHandler> aClass) {
            this.myPointer = pointer;
            this.myType = type;
            this.myHandlerClass = aClass;
        }

        public T create() {
            XmlTag tag = (XmlTag)this.myPointer.getElement();
            if (tag == null || !tag.isValid()) {
                return null;
            }
            DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (element == null || !element.getDomElementType().equals(this.myType)) {
                return null;
            }
            DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element);
            if (handler2 == null || !((Object)((Object)handler2)).getClass().equals(this.myHandlerClass)) {
                return null;
            }
            return (T)element;
        }
    }
}

