/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.getters.XmlAttributeValueGetter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class DomCompletionContributor
extends CompletionContributor {
    private final GenericValueReferenceProvider myProvider = new GenericValueReferenceProvider();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        if (this.domKnowsBetter(parameters, result)) {
            result.stopHere();
        }
    }

    private boolean domKnowsBetter(CompletionParameters parameters, CompletionResultSet result) {
        PsiReference[] references;
        XmlAttributeDescriptor descriptor;
        XmlAttributeValue element = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttributeValue.class);
        if (element == null) {
            return false;
        }
        if (DomCompletionContributor.isSchemaEnumerated((PsiElement)element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) != null && descriptor.getDefaultValue() != null && (references = this.myProvider.getReferencesByElement((PsiElement)element, new ProcessingContext())).length > 0) {
            return LegacyCompletionContributor.completeReference(parameters, result);
        }
        return false;
    }

    public static boolean isSchemaEnumerated(PsiElement element) {
        PsiElement parent;
        XmlTag simpleContent;
        if (element instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)element)) != null && XmlUtil.collectEnumerationValues(simpleContent, (java.util.HashSet<String>)new HashSet())) {
            return true;
        }
        if (element instanceof XmlAttributeValue && (parent = element.getParent()) instanceof XmlAttribute) {
            XmlAttributeDescriptor descriptor = ((XmlAttribute)parent).getDescriptor();
            if (descriptor != null && descriptor.isEnumerated()) {
                return true;
            }
            String[] enumeratedValues = XmlAttributeValueGetter.getEnumeratedValues((XmlAttribute)parent);
            if (enumeratedValues != null && enumeratedValues.length > 0) {
                String value;
                String string = value = descriptor == null ? null : descriptor.getDefaultValue();
                if (value == null || enumeratedValues.length != 1 || !value.equals(enumeratedValues[0])) {
                    return true;
                }
            }
        }
        return false;
    }
}

