/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomApplicationComponent {
    private final FactoryMap<String, Set<DomFileDescription>> myRootTagName2FileDescription = new FactoryMap<String, Set<DomFileDescription>>(){

        protected Set<DomFileDescription> create(String key) {
            return new THashSet();
        }
    };
    private final Set<DomFileDescription> myAcceptingOtherRootTagNamesDescriptions = new THashSet();
    private final ImplementationClassCache myCachedImplementationClasses = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager myTypeChooserManager = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final FactoryMap<Class, DomElementsAnnotator> myClass2Annotator = new ConcurrentFactoryMap<Class, DomElementsAnnotator>(){

        protected DomElementsAnnotator create(Class key) {
            DomFileDescription desc = DomApplicationComponent.this.findFileDescription(key);
            return desc == null ? null : desc.createAnnotator();
        }
    };
    private final FactoryMap<Class, StaticGenericInfo> myGenericInfos = new FactoryMap<Class, StaticGenericInfo>(){

        protected Map<Class, StaticGenericInfo> createMap() {
            return ContainerUtil.createConcurrentSoftValueMap();
        }

        @Nullable
        protected StaticGenericInfo create(Class type) {
            return new StaticGenericInfo(type);
        }
    };
    private final FactoryMap<Class, InvocationCache> myInvocationCaches = new FactoryMap<Class, InvocationCache>(){

        protected Map<Class, InvocationCache> createMap() {
            return ContainerUtil.createConcurrentSoftValueMap();
        }

        @Nullable
        protected InvocationCache create(Class key) {
            return new InvocationCache(key);
        }
    };
    private final ConcurrentFactoryMap<Class<? extends DomElementVisitor>, VisitorDescription> myVisitorDescriptions = new ConcurrentFactoryMap<Class<? extends DomElementVisitor>, VisitorDescription>(){

        @NotNull
        protected VisitorDescription create(Class<? extends DomElementVisitor> key) {
            return new VisitorDescription(key);
        }
    };

    public DomApplicationComponent() {
        for (DomFileDescription description : (DomFileDescription[])Extensions.getExtensions((ExtensionPointName)DomFileDescription.EP_NAME)) {
            this.registerFileDescription(description);
        }
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ServiceManager.getService(DomApplicationComponent.class);
    }

    public int getCumulativeVersion(boolean forStubs) {
        int result = 0;
        for (DomFileDescription description : this.getAllFileDescriptions()) {
            if (forStubs) {
                if (!description.hasStubs()) continue;
                result += description.getStubVersion();
                result += description.getRootTagName().hashCode();
                continue;
            }
            result += description.getVersion();
            result += description.getRootTagName().hashCode();
        }
        return result;
    }

    public final synchronized Set<DomFileDescription> getFileDescriptions(String rootTagName) {
        return (Set)this.myRootTagName2FileDescription.get((Object)rootTagName);
    }

    public final synchronized Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return this.myAcceptingOtherRootTagNamesDescriptions;
    }

    public final synchronized void registerFileDescription(DomFileDescription description) {
        ((Set)this.myRootTagName2FileDescription.get((Object)description.getRootTagName())).add(description);
        if (description.acceptsOtherRootTagNames()) {
            this.myAcceptingOtherRootTagNamesDescriptions.add(description);
        }
        Map implementations = description.getImplementations();
        for (Map.Entry entry : implementations.entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.myTypeChooserManager.copyFrom(description.getTypeChooserManager());
    }

    public synchronized List<DomFileDescription> getAllFileDescriptions() {
        ArrayList result = ContainerUtil.newArrayList();
        for (Set descriptions : this.myRootTagName2FileDescription.values()) {
            result.addAll(descriptions);
        }
        result.addAll(this.myAcceptingOtherRootTagNamesDescriptions);
        return result;
    }

    @Nullable
    private synchronized DomFileDescription findFileDescription(Class rootElementClass) {
        for (Set descriptions : this.myRootTagName2FileDescription.values()) {
            for (DomFileDescription description : descriptions) {
                if (description.getRootElementClass() != rootElementClass) continue;
                return description;
            }
        }
        for (DomFileDescription description : this.myAcceptingOtherRootTagNamesDescriptions) {
            if (description.getRootElementClass() != rootElementClass) continue;
            return description;
        }
        return null;
    }

    public DomElementsAnnotator getAnnotator(Class rootElementClass) {
        return (DomElementsAnnotator)this.myClass2Annotator.get((Object)rootElementClass);
    }

    @Nullable
    final Class<? extends DomElement> getImplementation(Class concreteInterface) {
        return this.myCachedImplementationClasses.get(concreteInterface);
    }

    public final void registerImplementation(Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, @Nullable Disposable parentDisposable) {
        this.myCachedImplementationClasses.registerImplementation(domElementClass, implementationClass, parentDisposable);
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.myTypeChooserManager;
    }

    public final StaticGenericInfo getStaticGenericInfo(Type type) {
        return (StaticGenericInfo)this.myGenericInfos.get((Object)ReflectionUtil.getRawType((Type)type));
    }

    final InvocationCache getInvocationCache(Class type) {
        return (InvocationCache)this.myInvocationCaches.get((Object)type);
    }

    public final VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> aClass) {
        return (VisitorDescription)this.myVisitorDescriptions.get(aClass);
    }
}

