/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.presentation.Presentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Attribute")
public class AttributeChildDescriptionImpl
extends DomChildDescriptionImpl
implements DomAttributeChildDescription<Void> {
    private final JavaMethod myGetterMethod;

    protected AttributeChildDescriptionImpl(XmlName attributeName, @NotNull JavaMethod getter) {
        super(attributeName, getter.getGenericReturnType());
        this.myGetterMethod = getter;
    }

    public AttributeChildDescriptionImpl(XmlName attributeName, @NotNull Type type) {
        super(attributeName, type);
        this.myGetterMethod = null;
    }

    @Override
    @NotNull
    public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.getType()), true);
        return strategy == null ? parent.getNameStrategy() : strategy;
    }

    public final JavaMethod getGetterMethod() {
        return this.myGetterMethod;
    }

    public String toString() {
        return "Attribute:" + this.getXmlName();
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        JavaMethod method = this.getGetterMethod();
        return (T)(method == null ? super.getAnnotation(annotationClass) : method.getAnnotation(annotationClass));
    }

    @NotNull
    public List<? extends DomElement> getValues(@NotNull DomElement parent) {
        return Arrays.asList(this.getDomAttributeValue(parent));
    }

    @NotNull
    public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
        throw new UnsupportedOperationException("Method getCommonPresentableName is not yet implemented in " + this.getClass().getName());
    }

    public GenericAttributeValue getDomAttributeValue(DomElement parent) {
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(parent);
        if (handler2 != null) {
            return this.getDomAttributeValue(handler2);
        }
        return (GenericAttributeValue)this.myGetterMethod.invoke((Object)parent, ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    public GenericAttributeValue getDomAttributeValue(DomInvocationHandler handler2) {
        return (GenericAttributeValue)handler2.getAttributeChild(this).getProxy();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AttributeChildDescriptionImpl that = (AttributeChildDescriptionImpl)o;
        return !(this.myGetterMethod != null ? !this.myGetterMethod.equals((Object)that.myGetterMethod) : that.myGetterMethod != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.myGetterMethod != null ? this.myGetterMethod.hashCode() : 0);
        return result;
    }
}

