/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementsProblemsHolderImpl
implements DomElementsProblemsHolder {
    private final Map<DomElement, Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>>> myCachedErrors = ContainerUtil.newConcurrentMap();
    private final Map<DomElement, Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>>> myCachedChildrenErrors = ContainerUtil.newConcurrentMap();
    private final List<Annotation> myAnnotations = new ArrayList<Annotation>();
    private final Function<DomElement, List<DomElementProblemDescriptor>> myDomProblemsGetter = new Function<DomElement, List<DomElementProblemDescriptor>>(){

        public List<DomElementProblemDescriptor> fun(DomElement s) {
            Map map = (Map)DomElementsProblemsHolderImpl.this.myCachedErrors.get(s);
            return map != null ? ContainerUtil.concat(map.values()) : Collections.emptyList();
        }
    };
    private final DomFileElement myElement;
    private static final Factory<Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>>> CONCURRENT_HASH_MAP_FACTORY = new Factory<Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>>>(){

        public Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>> create() {
            return ContainerUtil.newConcurrentMap();
        }
    };
    private static final Factory<List<DomElementProblemDescriptor>> SMART_LIST_FACTORY = new Factory<List<DomElementProblemDescriptor>>(){

        public List<DomElementProblemDescriptor> create() {
            return new SmartList();
        }
    };
    private final Set<Class<? extends DomElementsInspection>> myPassedInspections = new THashSet();

    public DomElementsProblemsHolderImpl(DomFileElement element) {
        this.myElement = element;
    }

    public final void appendProblems(DomElementAnnotationHolderImpl holder, Class<? extends DomElementsInspection> inspectionClass) {
        if (this.isInspectionCompleted(inspectionClass)) {
            return;
        }
        Iterator iterator = holder.iterator();
        while (iterator.hasNext()) {
            DomElementProblemDescriptor descriptor = (DomElementProblemDescriptor)iterator.next();
            this.addProblem(descriptor, inspectionClass);
        }
        this.myAnnotations.addAll((Collection<Annotation>)holder.getAnnotations());
        this.myPassedInspections.add(inspectionClass);
    }

    public final boolean isInspectionCompleted(@NotNull DomElementsInspection inspection) {
        return this.isInspectionCompleted(inspection.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInspectionCompleted(Class<? extends DomElementsInspection> inspectionClass) {
        Object object = DomElementAnnotationsManagerImpl.LOCK;
        synchronized (object) {
            return this.myPassedInspections.contains(inspectionClass);
        }
    }

    public final List<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public final void addProblem(DomElementProblemDescriptor descriptor, Class<? extends DomElementsInspection> inspection) {
        ((List)ContainerUtil.getOrCreate((Map)((Map)ContainerUtil.getOrCreate(this.myCachedErrors, (Object)descriptor.getDomElement(), CONCURRENT_HASH_MAP_FACTORY)), inspection, SMART_LIST_FACTORY)).add(descriptor);
        this.myCachedChildrenErrors.clear();
    }

    @NotNull
    public synchronized List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
        if (domElement == null || !domElement.isValid()) {
            return Collections.emptyList();
        }
        return (List)this.myDomProblemsGetter.fun((Object)domElement);
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems) {
        return this.getProblems(domElement);
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
        if (!withChildren || domElement == null || !domElement.isValid()) {
            return this.getProblems(domElement);
        }
        return ContainerUtil.concat(this.getProblemsMap(domElement).values());
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren, HighlightSeverity minSeverity) {
        return this.getProblems(domElement, withChildren, minSeverity);
    }

    public List<DomElementProblemDescriptor> getProblems(final DomElement domElement, boolean withChildren, final HighlightSeverity minSeverity) {
        return ContainerUtil.findAll(this.getProblems(domElement, true, withChildren), (Condition)new Condition<DomElementProblemDescriptor>(){

            public boolean value(DomElementProblemDescriptor object) {
                return SeverityRegistrar.getSeverityRegistrar(domElement.getManager().getProject()).compare(object.getHighlightSeverity(), minSeverity) >= 0;
            }
        });
    }

    @NotNull
    private Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>> getProblemsMap(DomElement domElement) {
        Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>> map = this.myCachedChildrenErrors.get(domElement);
        if (map != null) {
            return map;
        }
        THashMap problems = new THashMap();
        if (domElement == this.myElement) {
            for (Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>> listMap : this.myCachedErrors.values()) {
                DomElementsProblemsHolderImpl.mergeMaps(problems, listMap);
            }
        } else {
            DomElementsProblemsHolderImpl.mergeMaps(problems, this.myCachedErrors.get(domElement));
            if (DomUtil.hasXml((DomElement)domElement)) {
                domElement.acceptChildren(new DomElementVisitor((Map)problems){
                    final /* synthetic */ Map val$problems;
                    {
                        this.val$problems = map;
                    }

                    public void visitDomElement(DomElement element) {
                        DomElementsProblemsHolderImpl.mergeMaps(this.val$problems, DomElementsProblemsHolderImpl.this.getProblemsMap(element));
                    }
                });
            }
        }
        this.myCachedChildrenErrors.put(domElement, (Map<Class<? extends DomElementsInspection>, List<DomElementProblemDescriptor>>)problems);
        return problems;
    }

    private static <T> void mergeMaps(Map<T, List<DomElementProblemDescriptor>> accumulator, @Nullable Map<T, List<DomElementProblemDescriptor>> toAdd) {
        if (toAdd == null) {
            return;
        }
        for (Map.Entry<T, List<DomElementProblemDescriptor>> entry : toAdd.entrySet()) {
            ((List)ContainerUtil.getOrCreate(accumulator, entry.getKey(), SMART_LIST_FACTORY)).addAll((Collection)entry.getValue());
        }
    }

    public List<DomElementProblemDescriptor> getAllProblems() {
        return this.getProblems((DomElement)this.myElement, false, true);
    }

    public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
        if (!this.myElement.isValid()) {
            return Collections.emptyList();
        }
        List<DomElementProblemDescriptor> list = this.getProblemsMap((DomElement)this.myElement).get(inspection.getClass());
        return list != null ? new ArrayList<DomElementProblemDescriptor>(list) : Collections.emptyList();
    }
}

