/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class DefineAttributeQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.model.highlighting.DefineAttributeQuickFix");
    private final String myAttrName;
    private final String myNamespace;

    public DefineAttributeQuickFix(String attrName) {
        this(attrName, "");
    }

    public DefineAttributeQuickFix(@NotNull String attrName, @NotNull String namespace) {
        this.myAttrName = attrName;
        this.myNamespace = namespace;
    }

    @NotNull
    public String getName() {
        return "Define " + this.myAttrName + " attribute";
    }

    @NotNull
    public String getFamilyName() {
        return "Define attribute";
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        try {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)descriptor.getPsiElement().getContainingFile())) {
                return;
            }
            XmlAttribute attribute = tag.setAttribute(this.myAttrName, this.myNamespace, "");
            new OpenFileDescriptor(project2, tag.getContainingFile().getVirtualFile(), attribute.getValueElement().getTextRange().getStartOffset() + 1).navigate(true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

