/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassArrayConverterImpl
extends ClassArrayConverter {
    private static final JavaClassReferenceProvider REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s != null) {
            int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
            ArrayList<PsiReference> list = new ArrayList<PsiReference>();
            int pos = -1;
            while (true) {
                if (pos + 1 < s.length() && Character.isWhitespace(s.charAt(pos + 1))) {
                    ++pos;
                    continue;
                }
                int nextPos = s.indexOf(44, pos + 1);
                if (nextPos == -1) break;
                ClassArrayConverterImpl.createReference(element, s.substring(pos + 1, nextPos), pos + 1 + offset, list);
                pos = nextPos;
            }
            ClassArrayConverterImpl.createReference(element, s.substring(pos + 1), pos + 1 + offset, list);
            return list.toArray(new PsiReference[list.size()]);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static void createReference(PsiElement element, String s, int offset, List<PsiReference> list) {
        PsiReference[] references;
        for (PsiReference ref : references = REFERENCE_PROVIDER.getReferencesByString(s, element, offset)) {
            list.add(ref);
        }
    }

    static {
        REFERENCE_PROVIDER.setSoft(true);
        REFERENCE_PROVIDER.setAllowEmpty(true);
    }
}

