/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.util.Iconable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IconTableCellRenderer<T>
extends DefaultTableCellRenderer {
    public static final IconTableCellRenderer<Iconable> ICONABLE = new IconTableCellRenderer<Iconable>(){

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Iconable value, JTable table, int row) {
            return value.getIcon(1);
        }
    };

    public static TableCellRenderer create(final @NotNull Icon icon) {
        return new IconTableCellRenderer(){

            @Nullable
            protected Icon getIcon(@NotNull Object value, JTable table, int row) {
                return icon;
            }
        };
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
        super.getTableCellRendererComponent(table, value, selected, focus, row, column);
        this.setIcon(value == null ? null : this.getIcon(value, table, row));
        if (this.isCenterAlignment()) {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }
        return this;
    }

    protected boolean isCenterAlignment() {
        return false;
    }

    @Nullable
    protected abstract Icon getIcon(@NotNull T var1, JTable var2, int var3);
}

