/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ComponentsListFocusTraversalPolicy
extends FocusTraversalPolicy {
    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        List<Component> components = this.getOrderedComponents();
        int i = components.indexOf(aComponent);
        if (i != -1) {
            if (++i >= components.size()) {
                if (this.isFocusCycleRoot()) {
                    i = 0;
                } else {
                    return null;
                }
            }
            return components.get(i);
        }
        return null;
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        List<Component> components = this.getOrderedComponents();
        int i = components.indexOf(aComponent);
        if (i != -1) {
            if (--i == -1) {
                if (this.isFocusCycleRoot()) {
                    i = components.size() - 1;
                } else {
                    return null;
                }
            }
            return components.get(i);
        }
        return null;
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        List<Component> components = this.getOrderedComponents();
        return components.isEmpty() ? null : components.get(0);
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        List<Component> components = this.getOrderedComponents();
        return components.isEmpty() ? null : components.get(components.size() - 1);
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        List<Component> components = this.getOrderedComponents();
        return components.isEmpty() ? null : components.get(0);
    }

    @NotNull
    protected abstract List<Component> getOrderedComponents();

    protected boolean isFocusCycleRoot() {
        return true;
    }
}

