/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwingHelper {
    private static final Logger LOG = Logger.getInstance(SwingHelper.class);
    private static final String DIALOG_RESIZED_TO_FIT_TEXT = "INTELLIJ_DIALOG_RESIZED_TO_FIT_TEXT";
    public static final String ELLIPSIS = "...";
    public static final String ERROR_STR = "www";

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, Component ... children2) {
        return SwingHelper.newGenericBoxPanel(true, childAlignmentX, children2);
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(Component ... children2) {
        return SwingHelper.newVerticalPanel(0.0f, children2);
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(@NotNull Collection<Component> children2) {
        return SwingHelper.newVerticalPanel(0.0f, children2);
    }

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, @NotNull Collection<Component> children2) {
        return SwingHelper.newVerticalPanel(childAlignmentX, children2.toArray(new Component[children2.size()]));
    }

    @NotNull
    public static JPanel newHorizontalPanel(float childAlignmentY, Component ... children2) {
        return SwingHelper.newGenericBoxPanel(false, childAlignmentY, children2);
    }

    @NotNull
    public static JPanel newHorizontalPanel(float childAlignmentY, @NotNull Collection<Component> children2) {
        return SwingHelper.newHorizontalPanel(childAlignmentY, children2.toArray(new Component[children2.size()]));
    }

    private static JPanel newGenericBoxPanel(boolean verticalOrientation, float childAlignment, Component ... children2) {
        JPanel panel = new JPanel();
        int axis = verticalOrientation ? 1 : 0;
        panel.setLayout(new BoxLayout(panel, axis));
        for (Component child : children2) {
            panel.add(child, Float.valueOf(childAlignment));
            if (!(child instanceof JComponent)) continue;
            JComponent jChild = (JComponent)child;
            if (verticalOrientation) {
                jChild.setAlignmentX(childAlignment);
                continue;
            }
            jChild.setAlignmentY(childAlignment);
        }
        return panel;
    }

    @NotNull
    public static JPanel wrapWithoutStretch(@NotNull JComponent component) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(component);
        return panel;
    }

    @NotNull
    public static JPanel wrapWithHorizontalStretch(@NotNull JComponent component) {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)component, "North");
        return panel;
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithHistoryWithBrowseButton component) {
        int childWidth = SwingHelper.calcWidthToFitText(((TextFieldWithHistory)component.getChildComponent()).getTextEditor(), JBUI.scale((int)32));
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component, childWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithBrowseButton component) {
        int childWidth = SwingHelper.calcWidthToFitText((JTextField)component.getChildComponent(), JBUI.scale((int)20));
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component, childWidth);
    }

    private static <T extends JComponent> void setPreferredWidthForComponentWithBrowseButton(@NotNull ComponentWithBrowseButton<T> component, int childPrefWidth) {
        Dimension buttonPrefSize = component.getButton().getPreferredSize();
        SwingHelper.setPreferredWidth(component, childPrefWidth + buttonPrefSize.width);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField) {
        SwingHelper.setPreferredWidthToFitText(textField, JBUI.scale((int)15));
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField, int additionalWidth) {
        SwingHelper.setPreferredSizeToFitText(textField, StringUtil.notNullize((String)textField.getText()), additionalWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField, @NotNull String text) {
        SwingHelper.setPreferredSizeToFitText(textField, text, JBUI.scale((int)15));
    }

    private static void setPreferredSizeToFitText(@NotNull JTextField textField, @NotNull String text, int additionalWidth) {
        int width = SwingHelper.calcWidthToFitText(textField, text, additionalWidth);
        SwingHelper.setPreferredWidth(textField, width);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField, int additionalWidth) {
        return SwingHelper.calcWidthToFitText(textField, textField.getText(), additionalWidth);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField, @NotNull String text, int additionalWidth) {
        return textField.getFontMetrics(textField.getFont()).stringWidth(text) + additionalWidth;
    }

    public static void adjustDialogSizeToFitPreferredSize(@NotNull DialogWrapper dialogWrapper) {
        JRootPane rootPane = dialogWrapper.getRootPane();
        Dimension componentSize = rootPane.getSize();
        Dimension componentPreferredSize = rootPane.getPreferredSize();
        if (componentPreferredSize.width <= componentSize.width && componentPreferredSize.height <= componentSize.height) {
            return;
        }
        int dw = Math.max(0, componentPreferredSize.width - componentSize.width);
        int dh = Math.max(0, componentPreferredSize.height - componentSize.height);
        Dimension oldDialogSize = dialogWrapper.getSize();
        Dimension newDialogSize = new Dimension(oldDialogSize.width + dw, oldDialogSize.height + dh);
        dialogWrapper.setSize(newDialogSize.width, newDialogSize.height);
        rootPane.revalidate();
        rootPane.repaint();
        LOG.info("DialogWrapper '" + dialogWrapper.getTitle() + "' has been re-sized (added width: " + dw + ", added height: " + dh + ")");
    }

    public static void resizeDialogToFitTextFor(final JComponent ... components) {
        if (components.length == 0) {
            return;
        }
        SwingHelper.doWithDialogWrapper(components[0], new Consumer<DialogWrapper>(){

            public void consume(final DialogWrapper dialogWrapper) {
                if (dialogWrapper instanceof SettingsDialog || dialogWrapper instanceof SingleConfigurableEditor) {
                    for (JComponent component : components) {
                        if (component instanceof TextFieldWithHistoryWithBrowseButton) {
                            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)component);
                            continue;
                        }
                        if (component instanceof TextFieldWithBrowseButton) {
                            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)component);
                            continue;
                        }
                        if (!(component instanceof JTextField)) continue;
                        SwingHelper.setPreferredWidthToFitText((JTextField)component);
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingHelper.adjustDialogSizeToFitPreferredSize(dialogWrapper);
                        }
                    }, ModalityState.any());
                }
            }
        });
    }

    private static void doWithDialogWrapper(final @NotNull JComponent component, final @NotNull Consumer<DialogWrapper> consumer) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (component.getClientProperty(SwingHelper.DIALOG_RESIZED_TO_FIT_TEXT) != null) {
                    return;
                }
                component.putClientProperty(SwingHelper.DIALOG_RESIZED_TO_FIT_TEXT, true);
                DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
                if (dialogWrapper != null) {
                    consumer.consume((Object)dialogWrapper);
                } else {
                    UiNotifyConnector.doWhenFirstShown((JComponent)component, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
                            if (dialogWrapper != null) {
                                consumer.consume((Object)dialogWrapper);
                            }
                        }
                    });
                }
            }
        });
    }

    public static <T> void updateItems(@NotNull JComboBox<T> comboBox, @NotNull List<T> newItems, @Nullable T newSelectedItemIfSelectionCannotBePreserved) {
        if (!SwingHelper.shouldUpdate(comboBox, newItems)) {
            return;
        }
        Object itemToSelect = comboBox.getSelectedItem();
        boolean preserveSelection = true;
        if (!newItems.contains(itemToSelect)) {
            if (newItems.contains(newSelectedItemIfSelectionCannotBePreserved)) {
                itemToSelect = newSelectedItemIfSelectionCannotBePreserved;
            } else {
                itemToSelect = null;
                preserveSelection = false;
            }
        }
        comboBox.removeAllItems();
        for (T newItem : newItems) {
            comboBox.addItem(newItem);
        }
        if (preserveSelection) {
            int count = comboBox.getItemCount();
            for (int i = 0; i < count; ++i) {
                T item = comboBox.getItemAt(i);
                if (!ComparatorUtil.equalsNullable((Object)itemToSelect, item)) continue;
                comboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    private static <T> boolean shouldUpdate(@NotNull JComboBox<T> comboBox, @NotNull List<T> newItems) {
        int count = comboBox.getItemCount();
        if (newItems.size() != count) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            T newItem;
            T oldItem = comboBox.getItemAt(i);
            if (ComparatorUtil.equalsNullable(oldItem, newItem = newItems.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void setNoBorderCellRendererFor(@NotNull TableColumn column) {
        final TableCellRenderer previous = column.getCellRenderer();
        column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = previous != null ? previous.getTableCellRendererComponent(table, value, isSelected, false, row, column) : super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(null);
                }
                return component;
            }
        });
    }

    public static void addHistoryOnExpansion(final @NotNull TextFieldWithHistory textFieldWithHistory, final @NotNull NotNullProducer<List<String>> historyProvider) {
        textFieldWithHistory.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                List history = (List)historyProvider.produce();
                SwingHelper.setHistory(textFieldWithHistory, ContainerUtil.notNullize((List)history), true);
                textFieldWithHistory.removePopupMenuListener((PopupMenuListener)this);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public static void setHistory(@NotNull TextFieldWithHistory textFieldWithHistory, @NotNull List<String> history, boolean mergeWithPrevHistory) {
        HashSet newHistorySet = ContainerUtil.newHashSet(history);
        List prevHistory = textFieldWithHistory.getHistory();
        ArrayList mergedHistory = ContainerUtil.newArrayListWithCapacity((int)history.size());
        if (mergeWithPrevHistory) {
            for (String item : prevHistory) {
                if (newHistorySet.contains(item)) continue;
                mergedHistory.add(item);
            }
        }
        mergedHistory.addAll(history);
        String oldText = StringUtil.notNullize((String)textFieldWithHistory.getText());
        String oldSelectedItem = (String)ObjectUtils.tryCast((Object)textFieldWithHistory.getSelectedItem(), String.class);
        if (!mergedHistory.contains(oldSelectedItem)) {
            oldSelectedItem = null;
        }
        textFieldWithHistory.setHistory((List)mergedHistory);
        SwingHelper.setLongestAsPrototype((JComboBox)textFieldWithHistory, mergedHistory);
        if (oldSelectedItem != null) {
            textFieldWithHistory.setSelectedItem((Object)oldSelectedItem);
        }
        if (!oldText.equals(oldSelectedItem)) {
            textFieldWithHistory.setText(oldText);
        }
    }

    private static void setLongestAsPrototype(@NotNull JComboBox comboBox, @NotNull List<String> variants) {
        Object prototypeDisplayValue = comboBox.getPrototypeDisplayValue();
        String prototypeDisplayValueStr = null;
        if (prototypeDisplayValue instanceof String) {
            prototypeDisplayValueStr = (String)prototypeDisplayValue;
        } else if (prototypeDisplayValue != null) {
            return;
        }
        String longest = StringUtil.notNullize((String)prototypeDisplayValueStr);
        boolean updated = false;
        for (String s : variants) {
            if (longest.length() >= s.length()) continue;
            longest = s;
            updated = true;
        }
        if (updated) {
            comboBox.setPrototypeDisplayValue(longest);
        }
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project2, @NotNull TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        SwingHelper.doInstall(project2, textFieldWithHistoryWithBrowseButton, ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getTextEditor(), browseDialogTitle, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project2, @NotNull TextFieldWithBrowseButton textFieldWithBrowseButton, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        SwingHelper.doInstall(project2, textFieldWithBrowseButton, textFieldWithBrowseButton.getTextField(), browseDialogTitle, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    private static <T extends JComponent> void doInstall(@Nullable Project project2, @NotNull ComponentWithBrowseButton<T> componentWithBrowseButton, @NotNull JTextField textField, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor, @NotNull TextComponentAccessor<T> textComponentAccessor) {
        fileChooserDescriptor = fileChooserDescriptor.withShowHiddenFiles(SystemInfo.isUnix);
        componentWithBrowseButton.addBrowseFolderListener(project2, new ComponentWithBrowseButton.BrowseFolderActionListener(browseDialogTitle, null, componentWithBrowseButton, project2, fileChooserDescriptor, textComponentAccessor), true);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, (Disposable)project2);
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String url) {
        return SwingHelper.createWebHyperlink(url, url);
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String text, @NotNull String url) {
        HyperlinkLabel hyperlink = new HyperlinkLabel(text);
        hyperlink.setHyperlinkTarget(url);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new OpenLinkInBrowser(url));
        actionGroup.add((AnAction)new CopyLinkAction(url));
        hyperlink.setComponentPopupMenu(ActionManager.getInstance().createActionPopupMenu("web hyperlink", (ActionGroup)actionGroup).getComponent());
        return hyperlink;
    }

    public static void setPreferredWidth(@NotNull Component component, int width) {
        Dimension preferredSize = component.getPreferredSize();
        preferredSize.width = width;
        component.setPreferredSize(preferredSize);
    }

    public static boolean scrollToReference(JEditorPane view, String reference) {
        reference = StringUtil.trimStart((String)reference, (String)"#");
        List<String> toCheck = Arrays.asList("a", "h1", "h2", "h3", "h4");
        Document document = view.getDocument();
        if (document instanceof HTMLDocument) {
            ArrayList<Element> list = new ArrayList<Element>();
            for (Element root : document.getRootElements()) {
                SwingHelper.getAllElements(root, list, toCheck);
            }
            for (Element element : list) {
                AttributeSet attributes = element.getAttributes();
                String nm = (String)attributes.getAttribute(HTML.Attribute.NAME);
                if (nm == null) {
                    nm = (String)attributes.getAttribute(HTML.Attribute.ID);
                }
                if (nm == null || !nm.equals(reference)) continue;
                try {
                    int pos = element.getStartOffset();
                    Rectangle r = view.modelToView(pos);
                    if (r == null) continue;
                    Rectangle vis = view.getVisibleRect();
                    r.y -= 5;
                    r.height = vis.height;
                    view.scrollRectToVisible(r);
                    return true;
                }
                catch (BadLocationException badLocationException) {
                }
            }
        }
        return false;
    }

    private static void getAllElements(Element root, List<Element> list, List<String> toCheck) {
        if (toCheck.contains(root.getName().toLowerCase())) {
            list.add(root);
        }
        for (int i = 0; i < root.getElementCount(); ++i) {
            SwingHelper.getAllElements(root.getElement(i), list, toCheck);
        }
    }

    @NotNull
    public static JEditorPane createHtmlViewer(boolean carryTextOver, @Nullable Font font, @Nullable Color background, @Nullable Color foreground) {
        JEditorPane textPane = carryTextOver ? new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 0;
                return dimension;
            }
        } : new JEditorPane();
        textPane.setFont(font != null ? font : UIUtil.getLabelFont());
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        if (background != null) {
            textPane.setBackground(background);
        } else {
            textPane.setOpaque(false);
        }
        textPane.setForeground(foreground != null ? foreground : UIUtil.getLabelForeground());
        textPane.setFocusable(false);
        return textPane;
    }

    public static void setHtml(@NotNull JEditorPane editorPane, @NotNull String bodyInnerHtml, @Nullable Color foregroundColor) {
        String html = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)editorPane.getFont(), (Color)foregroundColor, null, null), bodyInnerHtml);
        editorPane.setText(html);
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createTextFieldWithHistoryWithBrowseButton(@Nullable Project project2, @NotNull String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor, @Nullable NotNullProducer<List<String>> historyProvider) {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        if (historyProvider != null) {
            SwingHelper.addHistoryOnExpansion(textFieldWithHistory, historyProvider);
        }
        SwingHelper.installFileCompletionAndBrowseDialog(project2, textFieldWithHistoryWithBrowseButton, browseDialogTitle, fileChooserDescriptor);
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static <C extends JComponent> ComponentWithBrowseButton<C> wrapWithInfoButton(@NotNull C component, @NotNull String infoButtonTooltip, @NotNull ActionListener listener2) {
        ComponentWithBrowseButton comp = new ComponentWithBrowseButton(component, listener2);
        FixedSizeButton uiHelpButton = comp.getButton();
        uiHelpButton.setToolTipText(infoButtonTooltip);
        uiHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        uiHelpButton.setHorizontalAlignment(0);
        uiHelpButton.setVerticalAlignment(0);
        return comp;
    }

    public static String truncateStringWithEllipsis(String text, int maxWidth, final FontMetrics fm) {
        return SwingHelper.truncateStringWithEllipsis(text, maxWidth, new WidthCalculator(){

            @Override
            public int stringWidth(String s) {
                return fm.stringWidth(s);
            }

            @Override
            public int charWidth(char c) {
                return fm.charWidth(c);
            }
        });
    }

    public static String truncateStringWithEllipsis(@NotNull String text, int maxWidth, WidthCalculator fm) {
        int error = fm.stringWidth(ERROR_STR);
        int wholeWidth = fm.stringWidth(text) + error;
        if (wholeWidth <= maxWidth || text.isEmpty()) {
            return text;
        }
        int ellipsisWidth = fm.stringWidth(ELLIPSIS) + error;
        if (ellipsisWidth >= maxWidth) {
            return ELLIPSIS;
        }
        int availableWidth = maxWidth - ellipsisWidth;
        int currentLen = (int)Math.floor((double)availableWidth / ((double)wholeWidth / (double)text.length()));
        String currentSubstring = text.substring(0, currentLen);
        int realWidth = fm.stringWidth(currentSubstring);
        if (realWidth >= availableWidth) {
            int delta = 0;
            for (int i = currentLen - 1; i >= 0; --i) {
                if (realWidth - delta < availableWidth) {
                    return text.substring(0, i) + ELLIPSIS;
                }
                delta += fm.charWidth(currentSubstring.charAt(i));
            }
            return text.substring(0, 1) + ELLIPSIS;
        }
        int delta = 0;
        for (int i = currentLen; i < text.length(); ++i) {
            if (realWidth + delta >= availableWidth) {
                return text.substring(0, i) + ELLIPSIS;
            }
            delta += fm.charWidth(text.charAt(i));
        }
        return text.substring(0, currentLen) + ELLIPSIS;
    }

    public static JEditorPane createHtmlLabel(@NotNull String innerHtml, @Nullable String disabledHtml, final @Nullable Consumer<String> hyperlinkListener) {
        disabledHtml = disabledHtml == null ? innerHtml : disabledHtml;
        Font font = UIUtil.getLabelFont();
        String html = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getInactiveTextColor(), null, null), innerHtml);
        String disabled = String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getInactiveTextColor(), null, null), disabledHtml);
        JEditorPane pane = new HtmlViewerBuilder().setCarryTextOver(false).setFont(UIUtil.getLabelFont()).setDisabledHtml(disabled).create();
        pane.setText(html);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hyperlinkListener != null) {
                        hyperlinkListener.consume((Object)(e.getURL() == null ? "" : e.getURL().toString()));
                    } else {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            }
        });
        return pane;
    }

    public static interface WidthCalculator {
        public int stringWidth(String var1);

        public int charWidth(char var1);
    }

    private static class OpenLinkInBrowser
    extends AnAction {
        private final String myUrl;

        private OpenLinkInBrowser(@NotNull String url) {
            super("Open Link in Browser", null, PlatformIcons.WEB_ICON);
            this.myUrl = url;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(AnActionEvent e) {
            BrowserUtil.browse((String)this.myUrl);
        }
    }

    private static class CopyLinkAction
    extends AnAction {
        private final String myUrl;

        private CopyLinkAction(@NotNull String url) {
            super("Copy Link Address", null, PlatformIcons.COPY_ICON);
            this.myUrl = url;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(AnActionEvent e) {
            StringSelection content = new StringSelection(this.myUrl);
            CopyPasteManager.getInstance().setContents((Transferable)content);
        }
    }

    public static class HtmlViewerBuilder {
        private boolean myCarryTextOver;
        private String myDisabledHtml;
        private Font myFont;
        private Color myBackground;
        private Color myForeground;

        public JEditorPane create() {
            JEditorPane textPane = new JEditorPane(){
                private boolean myEnabled = true;
                private String myEnabledHtml;

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    if (myCarryTextOver) {
                        dimension.width = 0;
                    }
                    return dimension;
                }

                @Override
                public void setText(String t) {
                    if (myDisabledHtml != null && this.myEnabled) {
                        this.myEnabledHtml = t;
                    }
                    super.setText(t);
                }

                @Override
                public void setEnabled(boolean enabled) {
                    if (myDisabledHtml != null) {
                        this.myEnabled = enabled;
                        if (this.myEnabled) {
                            this.setText(this.myEnabledHtml);
                        } else {
                            this.setText(myDisabledHtml);
                        }
                        super.setEnabled(true);
                    } else {
                        super.setEnabled(enabled);
                    }
                }
            };
            textPane.setFont(this.myFont != null ? this.myFont : UIUtil.getLabelFont());
            textPane.setContentType("text/html");
            textPane.setEditable(false);
            if (this.myBackground != null) {
                textPane.setBackground(this.myBackground);
            } else {
                textPane.setOpaque(false);
            }
            textPane.setForeground(this.myForeground != null ? this.myForeground : UIUtil.getLabelForeground());
            textPane.setFocusable(false);
            return textPane;
        }

        public HtmlViewerBuilder setCarryTextOver(boolean carryTextOver) {
            this.myCarryTextOver = carryTextOver;
            return this;
        }

        public HtmlViewerBuilder setDisabledHtml(String disabledHtml) {
            this.myDisabledHtml = disabledHtml;
            return this;
        }

        public HtmlViewerBuilder setFont(Font font) {
            this.myFont = font;
            return this;
        }

        public HtmlViewerBuilder setBackground(Color background) {
            this.myBackground = background;
            return this;
        }

        public HtmlViewerBuilder setForeground(Color foreground) {
            this.myForeground = foreground;
            return this;
        }
    }
}

