/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckBoxListModelEditor<T> {
    private final CheckBoxList<T> list;
    private final ToolbarDecorator toolbarDecorator;
    private final Function<T, String> toNameConverter;

    public CheckBoxListModelEditor(@NotNull Function<T, String> toNameConverter, @NotNull String emptyText) {
        this.toNameConverter = toNameConverter;
        this.list = new CheckBoxList();
        this.list.setEmptyText(emptyText);
        this.list.setBorder(null);
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.list);
    }

    @NotNull
    public CheckBoxListModelEditor<T> editAction(final @NotNull Function<T, T> consumer) {
        final Runnable action = new Runnable(){

            @Override
            public void run() {
                Object item = CheckBoxListModelEditor.this.getSelectedItem();
                if (item != null) {
                    Object newItem = consumer.fun(item);
                    if (newItem != null) {
                        CheckBoxListModelEditor.this.list.updateItem(item, newItem, StringUtil.notNullize((String)((String)CheckBoxListModelEditor.this.toNameConverter.fun(newItem))));
                    }
                    CheckBoxListModelEditor.this.list.requestFocus();
                }
            }
        };
        this.toolbarDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                action.run();
            }
        });
        EditSourceOnDoubleClickHandler.install(this.list, (Runnable)action);
        return this;
    }

    @NotNull
    public CheckBoxListModelEditor<T> copyAction(final @NotNull Consumer<T> consumer) {
        this.toolbarDecorator.addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                int[] indices = CheckBoxListModelEditor.this.list.getSelectedIndices();
                if (indices == null || indices.length == 0) {
                    return;
                }
                for (int index : indices) {
                    Object item = CheckBoxListModelEditor.this.list.getItemAt(index);
                    if (item == null) continue;
                    consumer.consume(item);
                }
            }
        });
        return this;
    }

    public ToolbarDecorator getToolbar() {
        return this.toolbarDecorator;
    }

    @NotNull
    public JComponent createComponent() {
        return this.toolbarDecorator.createPanel();
    }

    @NotNull
    public DefaultListModel getModel() {
        return (DefaultListModel)this.list.getModel();
    }

    public void selectItemByName(@NotNull String name) {
        for (int i = 0; i < this.list.getItemsCount(); ++i) {
            Object item = this.list.getItemAt(i);
            if (item == null || !name.equalsIgnoreCase((String)this.toNameConverter.fun(item))) continue;
            this.list.setSelectedIndex(i);
        }
    }

    @Nullable
    private T getSelectedItem() {
        int index = this.list.getSelectedIndex();
        return (T)(index == -1 ? null : this.list.getItemAt(index));
    }

    public CheckBoxList<T> getList() {
        return this.list;
    }

    public void reset(@NotNull List<Pair<T, Boolean>> items) {
        this.list.clear();
        for (Pair<T, Boolean> item : items) {
            this.list.addItem(item.first, (String)this.toNameConverter.fun(item.first), ((Boolean)item.second).booleanValue());
        }
    }

    public boolean isModified(@NotNull List<Pair<T, Boolean>> oldItems) {
        if (oldItems.size() != this.list.getItemsCount()) {
            return true;
        }
        for (int i = 0; i < this.list.getItemsCount(); ++i) {
            Object item = this.list.getItemAt(i);
            if (item == null) {
                return true;
            }
            Pair<T, Boolean> oldItem = oldItems.get(i);
            if (((Boolean)oldItem.second).booleanValue() == this.list.isItemSelected(i) && oldItem.first.equals(item)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<T> getItems() {
        int count = this.list.getItemsCount();
        ArrayList<Object> result = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.list.getItemAt(i);
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    @NotNull
    public List<Pair<T, Boolean>> apply() {
        int count = this.list.getItemsCount();
        ArrayList<Pair<T, Boolean>> result = new ArrayList<Pair<T, Boolean>>(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.list.getItemAt(i);
            if (item == null) continue;
            result.add(Pair.create((Object)item, (Object)this.list.isItemSelected(i)));
        }
        return result;
    }
}

