/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.profiling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResolveProfiler {
    @NonNls
    private static final String PATH = "../../resolve_info/";
    private static final boolean DISABLED = true;
    private static final ThreadLocal<ThreadInfo> threadMap = new ThreadLocal();
    private static volatile int fileCount = 0;

    public static void start() {
    }

    public static long finish() {
        return -1L;
    }

    public static void write(String prefix, @NotNull PsiElement expression, long time) {
        ResolveProfiler.write(ResolveProfiler.getInfo(prefix, expression, time));
    }

    public static void write(@NotNull String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static ThreadInfo getThreadInfo() {
        ThreadInfo info = threadMap.get();
        if (info != null) return info;
        Class<ResolveProfiler> clazz = ResolveProfiler.class;
        synchronized (ResolveProfiler.class) {
            info = new ThreadInfo("../../resolve_info/out" + fileCount + ".txt");
            ++fileCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            threadMap.set(info);
            return info;
        }
    }

    public static String getInfo(String prefix, @NotNull PsiElement expression, long time) {
        PsiFile file2 = expression.getContainingFile();
        String text = expression.getText();
        String textInfo = text != null ? StringUtil.escapeLineBreak((String)text) : "<null>";
        return prefix + " :: " + (file2 != null ? file2.getName() : "<no file>") + " :: " + textInfo + " :: " + expression.hashCode() + " :: " + time;
    }

    private static class ThreadInfo {
        private final String myFileName;
        private final Deque<Long> myTimeStack = new ArrayDeque<Long>();
        private String myPrefix = "";

        private ThreadInfo(@NotNull String name) {
            this.myFileName = name;
        }

        @NotNull
        public String getName() {
            return this.myFileName;
        }

        public void start() {
            this.myTimeStack.push(System.nanoTime());
            this.myPrefix = this.myPrefix + "  ";
        }

        public long finish() {
            this.myPrefix = this.myPrefix.substring(2);
            Long time = this.myTimeStack.pop();
            return (System.nanoTime() - time) / 1000L;
        }

        private String getPrefix() {
            return this.myPrefix;
        }

        static /* synthetic */ String access$000(ThreadInfo x0) {
            return x0.getPrefix();
        }
    }
}

