/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.AbstractResponseToRequestHandler;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.RequestWriter;
import com.intellij.util.io.socketConnection.SocketConnection;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.util.io.socketConnection.impl.ResponseProcessor;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SocketConnectionBase<Request extends AbstractRequest, Response extends AbstractResponse>
implements SocketConnection<Request, Response> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.ServerSocketConnectionImpl");
    private final Object myLock = new Object();
    private int myPort = -1;
    private final AtomicReference<ConnectionState> myState = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    private boolean myStopping;
    private final EventDispatcher<SocketConnectionListener> myDispatcher = EventDispatcher.create(SocketConnectionListener.class);
    private final List<Thread> myThreadsToInterrupt = new ArrayList<Thread>();
    private final RequestResponseExternalizerFactory<Request, Response> myExternalizerFactory;
    private final LinkedBlockingQueue<Request> myRequests = new LinkedBlockingQueue();
    private final TIntObjectHashMap<TimeoutInfo> myTimeouts = new TIntObjectHashMap();
    private final ResponseProcessor<Response> myResponseProcessor = new ResponseProcessor(this);

    public SocketConnectionBase(@NotNull RequestResponseExternalizerFactory<Request, Response> factory) {
        this.myExternalizerFactory = factory;
    }

    @Override
    public void sendRequest(@NotNull Request request) {
        this.sendRequest(request, null);
    }

    @Override
    public void sendRequest(@NotNull Request request, @Nullable AbstractResponseToRequestHandler<? extends Response> handler2) {
        if (handler2 != null) {
            this.myResponseProcessor.registerHandler(request.getId(), handler2);
        }
        try {
            this.myRequests.put(request);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void sendRequest(@NotNull Request request, @Nullable AbstractResponseToRequestHandler<? extends Response> handler2, int timeout, @NotNull Runnable onTimeout) {
        this.myTimeouts.put(request.getId(), (Object)new TimeoutInfo(timeout, onTimeout));
        this.sendRequest(request, handler2);
    }

    @Override
    public <R extends Response> void registerHandler(@NotNull Class<R> responseClass, @NotNull AbstractResponseHandler<R> handler2) {
        this.myResponseProcessor.registerHandler(responseClass, handler2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStopping() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStopping;
        }
    }

    protected void processRequests(RequestWriter<Request> writer) throws IOException {
        this.addThreadToInterrupt();
        try {
            while (!this.isStopping()) {
                AbstractRequest request = (AbstractRequest)this.myRequests.take();
                LOG.debug("sending request: " + request);
                TimeoutInfo timeoutInfo = (TimeoutInfo)this.myTimeouts.remove(request.getId());
                if (timeoutInfo != null) {
                    this.myResponseProcessor.registerTimeoutHandler(request.getId(), timeoutInfo.myTimeout, timeoutInfo.myOnTimeout);
                }
                writer.writeRequest(request);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setStatus(ConnectionStatus.DISCONNECTED, null);
        this.removeThreadToInterrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addThreadToInterrupt() {
        Object object = this.myLock;
        synchronized (object) {
            this.myThreadsToInterrupt.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeThreadToInterrupt() {
        Object object = this.myLock;
        synchronized (object) {
            this.myThreadsToInterrupt.remove(Thread.currentThread());
        }
    }

    public void dispose() {
        LOG.debug("Firefox connection disposed");
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(@NotNull ConnectionStatus status, @Nullable String message) {
        Object object = this.myLock;
        synchronized (object) {
            this.myState.set(new ConnectionState(status, message, null));
        }
        ((SocketConnectionListener)this.myDispatcher.getMulticaster()).statusChanged(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ConnectionState getState() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.get();
        }
    }

    @Override
    public void addListener(@NotNull SocketConnectionListener listener2, @Nullable Disposable parentDisposable) {
        if (parentDisposable != null) {
            this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
        } else {
            this.myDispatcher.addListener((EventListener)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStopping) {
                return;
            }
            this.myStopping = true;
        }
        LOG.debug("closing connection");
        object = this.myLock;
        synchronized (object) {
            for (Thread thread : this.myThreadsToInterrupt) {
                thread.interrupt();
            }
        }
        this.onClosing();
        this.myResponseProcessor.stopReading();
        Disposer.dispose((Disposable)this);
    }

    protected void onClosing() {
    }

    protected void attachToSocket(Socket socket) throws IOException {
        this.setStatus(ConnectionStatus.CONNECTED, null);
        LOG.debug("connected");
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        this.myResponseProcessor.startReading(this.myExternalizerFactory.createResponseReader(inputStream));
        this.processRequests(this.myExternalizerFactory.createRequestWriter(outputStream));
    }

    protected void setPort(int port) {
        this.myPort = port;
    }

    private static class TimeoutInfo {
        private final int myTimeout;
        private final Runnable myOnTimeout;

        private TimeoutInfo(int timeout, Runnable onTimeout) {
            this.myTimeout = timeout;
            this.myOnTimeout = onTimeout;
        }
    }
}

