/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.ID;
import java.io.File;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexInfrastructure {
    private static final boolean ourUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static final String STUB_VERSIONS = ".versions";
    private static final String PERSISTENT_INDEX_DIRECTORY_NAME = ".persistent";

    private IndexInfrastructure() {
    }

    @NotNull
    public static File getVersionFile(@NotNull ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexDirectory(indexName, true), indexName + ".ver");
    }

    @NotNull
    public static File getStorageFile(@NotNull ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName.toString());
    }

    @NotNull
    public static File getInputIndexStorageFile(@NotNull ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName + "_inputs");
    }

    @NotNull
    public static File getIndexRootDir(@NotNull ID<?, ?> indexName) {
        return IndexInfrastructure.getIndexDirectory(indexName, false);
    }

    public static File getPersistentIndexRoot() {
        File indexDir = new File(PathManager.getIndexRoot() + File.separator + PERSISTENT_INDEX_DIRECTORY_NAME);
        indexDir.mkdirs();
        return indexDir;
    }

    @NotNull
    public static File getPersistentIndexRootDir(@NotNull ID<?, ?> indexName) {
        return IndexInfrastructure.getIndexDirectory(indexName, false, PERSISTENT_INDEX_DIRECTORY_NAME);
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion) {
        return IndexInfrastructure.getIndexDirectory(indexName, forVersion, "");
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion, String relativePath) {
        File indexDir;
        String dirName = indexName.toString().toLowerCase(Locale.US);
        if (indexName instanceof StubIndexKey) {
            indexDir = new File(IndexInfrastructure.getIndexDirectory(StubUpdatingIndex.INDEX_ID, false, relativePath), forVersion ? STUB_VERSIONS : dirName);
        } else {
            if (relativePath.length() > 0) {
                relativePath = File.separator + relativePath;
            }
            indexDir = new File(PathManager.getIndexRoot() + relativePath, dirName);
        }
        indexDir.mkdirs();
        return indexDir;
    }

    @Nullable
    public static VirtualFile findFileById(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileById(id);
    }

    @Nullable
    public static VirtualFile findFileByIdIfCached(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileByIdIfCached(id);
    }

    @Nullable
    private static VirtualFile findTestFile(int id) {
        return DummyFileSystem.getInstance().findById(id);
    }
}

