/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.AppTopics;
import com.intellij.history.LocalHistory;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.FileASTNode;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DeletedVirtualFileStub;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexedFilesListener;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InputIndexDataExternalizer;
import com.intellij.util.indexing.MapIndexStorage;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.SilentProgressIndicator;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.TaskQueue;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import jsr166e.extra.SequenceLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexImpl
extends FileBasedIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexImpl");
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private static final NotificationGroup NOTIFICATIONS = new NotificationGroup("Indexing", NotificationDisplayType.BALLOON, false);
    private final Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> myIndices = new THashMap();
    private final List<ID<?, ?>> myIndicesWithoutFileTypeInfo = new ArrayList();
    private final Map<FileType, List<ID<?, ?>>> myFileType2IndicesWithFileTypeInfoMap = new THashMap();
    private final List<ID<?, ?>> myIndicesForDirectories = new SmartList();
    private final Map<ID<?, ?>, DocumentUpdateTask> myUnsavedDataUpdateTasks = new THashMap();
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();
    private final Set<ID<?, ?>> myNotRequiringContentIndices = new THashSet();
    private final Set<ID<?, ?>> myRequiringContentIndices = new THashSet();
    private final Set<ID<?, ?>> myPsiDependentIndices = new THashSet();
    private final Set<FileType> myNoLimitCheckTypes = new THashSet();
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
    @NotNull
    private final ChangedFilesCollector myChangedFilesCollector;
    private final List<IndexableFileSet> myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap = new THashMap();
    private static final int OK = 1;
    private static final int REQUIRES_REBUILD = 2;
    private static final Map<ID<?, ?>, AtomicInteger> ourRebuildStatus = new THashMap();
    private final MessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final FileTypeManagerImpl myFileTypeManager;
    private final SerializationManagerEx mySerializationManagerEx;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
    private volatile SmartFMap<Document, PsiFile> myTransactionMap = SmartFMap.emptyMap();
    @Nullable
    private final String myConfigPath;
    @Nullable
    private final String myLogPath;
    private final boolean myIsUnitTestMode;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    private volatile int myLocalModCount;
    private volatile int myFilesModCount;
    private final AtomicInteger myUpdatingFiles = new AtomicInteger();
    private final Set<Project> myProjectsBeingUpdated = ContainerUtil.newConcurrentSet();
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile boolean myInitialized;
    private final AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);
    private static final ThreadLocal<Integer> myUpToDateCheckState = new ThreadLocal();
    private final ThreadLocal<Boolean> myReentrancyGuard = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final Key<SoftReference<ProjectIndexableFilesFilter>> ourProjectFilesSetKey = Key.create((String)"projectFiles");
    private final Lock myCalcIndexableFilesLock = new SequenceLock();
    private static final Key<WeakReference<FileContentImpl>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final TaskQueue myContentlessIndicesUpdateQueue = new TaskQueue(10000);
    private final StorageGuard myStorageLock = new StorageGuard();
    private volatile boolean myPreviousDataBufferingState;
    private final Object myBufferingStateUpdateLock = new Object();
    static final Key<Boolean> ourPhysicalContentKey = Key.create((String)"physical.content.flag");
    private final VirtualFileUpdateTask myForceUpdateTask = new VirtualFileUpdateTask();
    private final AtomicInteger myForceUpdateRequests = new AtomicInteger();

    public FileBasedIndexImpl(VirtualFileManager vfManager, FileDocumentManager fdm, FileTypeManagerImpl fileTypeManager, @NotNull MessageBus bus, SerializationManagerEx sm) {
        this.myFileDocumentManager = fdm;
        this.myFileTypeManager = fileTypeManager;
        this.mySerializationManagerEx = sm;
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myConfigPath = FileBasedIndexImpl.calcConfigPath(PathManager.getConfigPath());
        this.myLogPath = FileBasedIndexImpl.calcConfigPath(PathManager.getLogPath());
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file2);
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){
            @Nullable
            private Map<FileType, Set<String>> myTypeToExtensionMap;

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                FileBasedIndexImpl.cleanupProcessedFlag();
                this.myTypeToExtensionMap = new THashMap();
                for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                    this.myTypeToExtensionMap.put(type, this.getExtensions(type));
                }
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                Map<FileType, Set<String>> oldExtensions = this.myTypeToExtensionMap;
                this.myTypeToExtensionMap = null;
                if (oldExtensions != null) {
                    THashMap newExtensions = new THashMap();
                    for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                        newExtensions.put(type, this.getExtensions(type));
                    }
                    if (!newExtensions.keySet().containsAll(oldExtensions.keySet())) {
                        this.rebuildAllIndices();
                        return;
                    }
                    for (Map.Entry entry : oldExtensions.entrySet()) {
                        FileType fileType = (FileType)entry.getKey();
                        Set strings = (Set)entry.getValue();
                        if (((Set)newExtensions.get(fileType)).containsAll(strings)) continue;
                        this.rebuildAllIndices();
                        return;
                    }
                }
            }

            @NotNull
            private Set<String> getExtensions(@NotNull FileType type) {
                THashSet set = new THashSet();
                for (FileNameMatcher matcher : FileBasedIndexImpl.this.myFileTypeManager.getAssociations(type)) {
                    set.add(matcher.getPresentableString());
                }
                return set;
            }

            private void rebuildAllIndices() {
                IndexingStamp.flushCaches();
                for (ID indexId : FileBasedIndexImpl.this.myIndices.keySet()) {
                    try {
                        FileBasedIndexImpl.this.clearIndex(indexId);
                    }
                    catch (StorageException e) {
                        LOG.info((Throwable)e);
                    }
                }
                FileBasedIndexImpl.scheduleIndexRebuild("File type change");
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                FileBasedIndexImpl.this.cleanupMemoryStorage();
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage();
            }
        });
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void writeActionStarted(Object action) {
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }
        });
        this.myChangedFilesCollector = new ChangedFilesCollector();
        this.myConnection = connection;
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)fileType);
    }

    static boolean belongsToScope(VirtualFile file2, VirtualFile restrictedTo, GlobalSearchScope filter) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return (restrictedTo == null || Comparing.equal((Object)file2, (Object)restrictedTo)) && (filter == null || restrictedTo != null || filter.accept(file2));
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        this.myChangedFilesCollector.invalidateIndicesRecursively(file2, true);
    }

    private void initExtensions() {
        try {
            File indexRoot = PathManager.getIndexRoot();
            File corruptionMarker = new File(indexRoot, CORRUPTION_MARKER_NAME);
            boolean currentVersionCorrupted = corruptionMarker.exists();
            if (currentVersionCorrupted) {
                FileUtil.deleteWithRenaming((File)indexRoot);
                indexRoot.mkdirs();
                this.mySerializationManagerEx.reinitializeNameStorage();
            }
            FileBasedIndexExtension[] extensions = (FileBasedIndexExtension[])Extensions.getExtensions((ExtensionPointName)FileBasedIndexExtension.EXTENSION_POINT_NAME);
            boolean versionChanged = false;
            for (FileBasedIndexExtension extension : extensions) {
                try {
                    ourRebuildStatus.put(extension.getName(), new AtomicInteger(1));
                    versionChanged |= this.registerIndexer(extension);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable t) {
                    PluginManager.handleComponentError(t, extension.getClass().getName(), null);
                }
            }
            for (List list : this.myFileType2IndicesWithFileTypeInfoMap.values()) {
                list.addAll(this.myIndicesWithoutFileTypeInfo);
            }
            FileUtil.delete((File)corruptionMarker);
            String rebuildNotification = null;
            if (currentVersionCorrupted) {
                rebuildNotification = "Index files on disk are corrupted. Indices will be rebuilt.";
            } else if (versionChanged) {
                rebuildNotification = "Index file format has changed for some indices. These indices will be rebuilt.";
            }
            if (rebuildNotification != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && Registry.is((String)"ide.showIndexRebuildMessage")) {
                NOTIFICATIONS.createNotification("Index Rebuild", rebuildNotification, NotificationType.INFORMATION, null).notify(null);
            }
            this.dropUnregisteredIndices();
            for (ID<?, ?> indexId : this.myIndices.keySet()) {
                if (!ourRebuildStatus.get(indexId).compareAndSet(2, 1)) continue;
                try {
                    this.clearIndex(indexId);
                }
                catch (StorageException e) {
                    this.requestRebuild(indexId);
                    LOG.error((Throwable)e);
                }
            }
            this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myChangedFilesCollector);
            this.registerIndexableSet(new AdditionalIndexableFileSet(), null);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        FileBasedIndexImpl.this.performShutdown();
                    }
                });
                FileBasedIndexImpl.saveRegisteredIndices(this.myIndices.keySet());
                this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                    private int lastModCount;

                    @Override
                    public void run() {
                        FileBasedIndexImpl.this.mySerializationManagerEx.flushNameStorage();
                        if (this.lastModCount == FileBasedIndexImpl.this.myLocalModCount) {
                            FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                        }
                        this.lastModCount = FileBasedIndexImpl.this.myLocalModCount;
                    }
                });
                this.myInitialized = true;
                throw throwable;
            }
        }
        ShutDownTracker.getInstance().registerShutdownTask(new /* invalid duplicate definition of identical inner class */);
        FileBasedIndexImpl.saveRegisteredIndices(this.myIndices.keySet());
        this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new /* invalid duplicate definition of identical inner class */);
        this.myInitialized = true;
    }

    public void initComponent() {
        this.initExtensions();
    }

    @Nullable
    private static String calcConfigPath(@NotNull String path) {
        try {
            String _path = FileUtil.toSystemIndependentName((String)new File(path).getCanonicalPath());
            return _path.endsWith("/") ? _path : _path + "/";
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private <K, V> boolean registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension) throws IOException {
        ID name = extension.getName();
        int version = extension.getVersion();
        File versionFile = IndexInfrastructure.getVersionFile(name);
        boolean versionFileExisted = versionFile.exists();
        boolean versionChanged = false;
        if (IndexingStamp.versionDiffers(versionFile, version)) {
            if (versionFileExisted) {
                versionChanged = true;
                LOG.info("Version has changed for index " + name + ". The index will be rebuilt.");
            }
            if (extension.hasSnapshotMapping() && versionChanged) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
            }
            File rootDir = IndexInfrastructure.getIndexRootDir(name);
            if (versionFileExisted) {
                FileUtil.deleteWithRenaming((File)rootDir);
            }
            IndexingStamp.rewriteVersion(versionFile, version);
        }
        this.initIndexStorage(extension, version, versionFile);
        return versionChanged;
    }

    private <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension, int version, @NotNull File versionFile) throws IOException {
        MapIndexStorage storage2 = null;
        final ID name = extension.getName();
        boolean contentHashesEnumeratorOk = false;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                if (extension.hasSnapshotMapping()) {
                    ContentHashesSupport.initContentHashesEnumerator();
                    contentHashesEnumeratorOk = true;
                }
                storage2 = new MapIndexStorage(IndexInfrastructure.getStorageFile(name), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.keyIsUniqueForIndexedFile(), extension.traceKeyHashToVirtualFileMapping());
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage2);
                UpdatableIndex<K, V, FileContent> index = this.createIndex(name, extension, memStorage);
                FileBasedIndex.InputFilter inputFilter = extension.getInputFilter();
                this.myIndices.put(name, new Pair(index, (Object)new IndexableFilesFilter(inputFilter)));
                if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                    ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing((Consumer)new Consumer<FileType>(){
                        final Set<FileType> addedTypes = new THashSet();

                        public void consume(FileType type) {
                            if (type == null || !this.addedTypes.add(type)) {
                                return;
                            }
                            ArrayList<ID> ids = (ArrayList<ID>)FileBasedIndexImpl.this.myFileType2IndicesWithFileTypeInfoMap.get(type);
                            if (ids == null) {
                                ids = new ArrayList<ID>(5);
                                FileBasedIndexImpl.this.myFileType2IndicesWithFileTypeInfoMap.put(type, ids);
                            }
                            ids.add(name);
                        }
                    });
                } else {
                    this.myIndicesWithoutFileTypeInfo.add(name);
                }
                this.myUnsavedDataUpdateTasks.put(name, new DocumentUpdateTask(name));
                this.myIndexIdToVersionMap.put((Object)name, version);
                if (!extension.dependsOnFileContent()) {
                    if (extension.indexDirectories()) {
                        this.myIndicesForDirectories.add(name);
                    }
                    this.myNotRequiringContentIndices.add(name);
                } else {
                    this.myRequiringContentIndices.add(name);
                }
                if (extension instanceof PsiDependentIndex) {
                    this.myPsiDependentIndices.add(name);
                }
                this.myNoLimitCheckTypes.addAll(extension.getFileTypesWithSizeLimitNotApplicable());
                break;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                boolean instantiatedStorage = storage2 != null;
                try {
                    if (storage2 != null) {
                        storage2.close();
                    }
                    storage2 = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(name));
                if (extension.hasSnapshotMapping() && (!contentHashesEnumeratorOk || instantiatedStorage)) {
                    FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
                }
                IndexingStamp.rewriteVersion(versionFile, version);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRegisteredIndices(@NotNull Collection<ID<?, ?>> ids) {
        File file2 = FileBasedIndexImpl.getRegisteredIndicesFile();
        try {
            FileUtil.createIfDoesntExist((File)file2);
            try (DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file2)));){
                os.writeInt(ids.size());
                for (ID<?, ?> id : ids) {
                    IOUtil.writeString((String)id.toString(), (DataOutput)os);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Set<String> readRegisteredIndexNames() {
        THashSet result = new THashSet();
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(FileBasedIndexImpl.getRegisteredIndicesFile())));){
            int size = in.readInt();
            for (int idx = 0; idx < size; ++idx) {
                result.add(IOUtil.readString((DataInput)in));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @NotNull
    private static File getRegisteredIndicesFile() {
        return new File(PathManager.getIndexRoot(), "registered");
    }

    @NotNull
    private <K, V> UpdatableIndex<K, V, FileContent> createIndex(@NotNull ID<K, V> indexId, final @NotNull FileBasedIndexExtension<K, V> extension, final @NotNull MemoryIndexStorage<K, V> storage2) throws StorageException, IOException {
        MapReduceIndex index;
        if (extension instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex custom = ((CustomImplementationFileBasedIndexExtension)extension).createIndexImplementation(indexId, this, storage2);
            if (!(custom instanceof MapReduceIndex)) {
                return custom;
            }
            index = (MapReduceIndex)custom;
        } else {
            DataExternalizer<Collection<K>> externalizer = extension.hasSnapshotMapping() && IdIndex.ourSnapshotMappingsEnabled ? FileBasedIndexImpl.createInputsIndexExternalizer(extension, indexId, extension.getKeyDescriptor()) : null;
            index = new MapReduceIndex(indexId, extension.getIndexer(), storage2, externalizer, extension.getValueExternalizer(), extension instanceof PsiDependentIndex);
        }
        index.setInputIdToDataKeysIndex(new Factory<PersistentHashMap<Integer, Collection<K>>>(){

            public PersistentHashMap<Integer, Collection<K>> create() {
                try {
                    return FileBasedIndexImpl.createIdToDataKeysIndex(extension, storage2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return index;
    }

    @NotNull
    public static <K> PersistentHashMap<Integer, Collection<K>> createIdToDataKeysIndex(@NotNull FileBasedIndexExtension<K, ?> extension, @NotNull MemoryIndexStorage<K, ?> storage2) throws IOException {
        ID indexId = extension.getName();
        KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile(indexId);
        final AtomicBoolean isBufferingMode = new AtomicBoolean();
        final TIntObjectHashMap tempMap = new TIntObjectHashMap();
        final PersistentHashMap map = new PersistentHashMap<Integer, Collection<K>>(indexStorageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, FileBasedIndexImpl.createInputsIndexExternalizer(extension, indexId, keyDescriptor)){

            protected Collection<K> doGet(Integer integer) throws IOException {
                Collection collection;
                if (isBufferingMode.get() && (collection = (Collection)tempMap.get(integer.intValue())) != null) {
                    return collection;
                }
                return (Collection)super.doGet((Object)integer);
            }

            protected void doPut(Integer integer, @Nullable Collection<K> ks) throws IOException {
                if (isBufferingMode.get()) {
                    tempMap.put(integer.intValue(), ks == null ? Collections.emptySet() : ks);
                } else {
                    super.doPut((Object)integer, ks);
                }
            }

            protected void doRemove(Integer integer) throws IOException {
                if (isBufferingMode.get()) {
                    tempMap.put(integer.intValue(), Collections.emptySet());
                } else {
                    super.doRemove((Object)integer);
                }
            }
        };
        storage2.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bufferingStateChanged(boolean newState) {
                PersistentHashMap persistentHashMap = map;
                synchronized (persistentHashMap) {
                    isBufferingMode.set(newState);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void memoryStorageCleared() {
                PersistentHashMap persistentHashMap = map;
                synchronized (persistentHashMap) {
                    tempMap.clear();
                }
            }
        });
        return map;
    }

    private static <K> DataExternalizer<Collection<K>> createInputsIndexExternalizer(FileBasedIndexExtension<K, ?> extension, ID<K, ?> indexId, KeyDescriptor<K> keyDescriptor) {
        Object externalizer = extension instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer() : new InputIndexDataExternalizer<K>(keyDescriptor, indexId);
        return externalizer;
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                for (VirtualFile virtualFile : this.myChangedFilesCollector.getAllFilesToUpdate()) {
                    if (virtualFile.isValid()) continue;
                    this.removeDataFromIndicesForFile(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(virtualFile)));
                }
                IndexingStamp.flushCaches();
                for (ID iD : this.myIndices.keySet()) {
                    UpdatableIndex index = this.getIndex(iD);
                    assert (index != null);
                    if (ourRebuildStatus.get(iD).get() != 1) {
                        this.doClearIndex(iD);
                    }
                    index.dispose();
                }
                ContentHashesSupport.flushContentHashes();
                this.myConnection.disconnect();
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    private void removeDataFromIndicesForFile(final int fileId) {
        List<ID<?, ?>> currentFileIndexedStates;
        Collection<Object> states = currentFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        for (ID<?, ?> currentFileIndexedState : currentFileIndexedStates) {
            if (this.myIndices.containsKey(currentFileIndexedState)) continue;
            states = ContainerUtil.intersection(currentFileIndexedStates, this.myIndices.keySet());
            break;
        }
        if (!states.isEmpty()) {
            final List<ID<?, ?>> finalStates = states;
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    FileBasedIndexImpl.this.removeFileDataFromIndices(finalStates, fileId);
                }
            });
        }
    }

    private void removeFileDataFromIndices(@NotNull Collection<ID<?, ?>> affectedIndices, int inputId) {
        Throwable unexpectedError = null;
        for (ID<?, ?> indexId : affectedIndices) {
            try {
                this.updateSingleIndex(indexId, inputId, null);
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
                this.requestRebuild(indexId);
            }
            catch (ProcessCanceledException pce) {
                LOG.error((Throwable)pce);
            }
            catch (Throwable e) {
                LOG.info(e);
                if (unexpectedError != null) continue;
                unexpectedError = e;
            }
        }
        IndexingStamp.flushCache(inputId);
        if (unexpectedError != null) {
            LOG.error(unexpectedError);
        }
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        for (ID<?, ?> indexId : new ArrayList(this.myIndices.keySet())) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
                this.requestRebuild(indexId);
            }
        }
        ContentHashesSupport.flushContentHashes();
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project2) {
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexId, (Processor<K>)new CommonProcessors.CollectProcessor((Collection)allKeys), project2);
        return allKeys;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor2, @Nullable Project project2) {
        return this.processAllKeys(indexId, processor2, (GlobalSearchScope)(project2 == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project2)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        try {
            UpdatableIndex<K, ?, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            this.ensureUpToDate(indexId, scope.getProject(), scope);
            return index.processAllKeys(processor2, scope, idFilter);
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    public static void disableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        myUpToDateCheckState.set(currentValue == null ? 1 : currentValue + 1);
    }

    public static void enableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        if (currentValue != null) {
            int newValue = currentValue - 1;
            if (newValue != 0) {
                myUpToDateCheckState.set(newValue);
            } else {
                myUpToDateCheckState.remove();
            }
        }
    }

    private static boolean isUpToDateCheckEnabled() {
        Integer value = myUpToDateCheckState.get();
        return value == null || value == 0;
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project2, @Nullable GlobalSearchScope filter) {
        this.ensureUpToDate(indexId, project2, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project2, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        block12: {
            ProgressManager.checkCanceled();
            this.myContentlessIndicesUpdateQueue.ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.needsFileContentLoading(indexId)) {
                return;
            }
            if (filter == GlobalSearchScope.EMPTY_SCOPE) {
                return;
            }
            if (ActionUtil.isDumbMode((Project)project2)) {
                FileBasedIndexImpl.handleDumbMode(project2);
            }
            if (this.myReentrancyGuard.get().booleanValue()) {
                return;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) break block12;
                try {
                    if (ourRebuildStatus.get(indexId).get() != 1) {
                        throw new ProcessCanceledException();
                    }
                    this.forceUpdate(project2, filter, restrictedFile);
                    this.indexUnsavedDocuments(indexId, project2, filter, restrictedFile);
                }
                catch (StorageException e) {
                    this.scheduleRebuild(indexId, e);
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof StorageException || cause instanceof IOException) {
                        this.scheduleRebuild(indexId, e);
                        break block12;
                    }
                    throw e;
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
    }

    private static void handleDumbMode(@Nullable Project project2) {
        BackgroundableProcessIndicator indicator;
        ProgressIndicator progressIndicator;
        ProgressManager.checkCanceled();
        if (project2 != null && (progressIndicator = ProgressManager.getInstance().getProgressIndicator()) instanceof BackgroundableProcessIndicator && (indicator = (BackgroundableProcessIndicator)progressIndicator).getDumbModeAction() == DumbModeAction.WAIT) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            DumbService.getInstance((Project)project2).waitForSmartMode();
            return;
        }
        throw new IndexNotReadyException(project2 == null ? null : DumbServiceImpl.getInstance(project2).getDumbModeStartTrace());
    }

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        Iterator virtualFileIterator;
        SmartList values = new SmartList();
        VirtualFile restrictToFile = null;
        if (filter instanceof Iterable && (virtualFileIterator = ((Iterable)filter).iterator()).hasNext()) {
            VirtualFile restrictToFileCandidate = (VirtualFile)virtualFileIterator.next();
            if (!virtualFileIterator.hasNext()) {
                restrictToFile = restrictToFileCandidate;
            }
        }
        this.processValuesImpl(indexId, dataKey, true, restrictToFile, new FileBasedIndex.ValueProcessor<V>((List)values){
            final /* synthetic */ List val$values;
            {
                this.val$values = list;
            }

            public boolean process(VirtualFile file2, V value) {
                this.val$values.add(value);
                return true;
            }
        }, filter, null);
        return values;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        THashSet files = new THashSet();
        this.processValuesImpl(indexId, dataKey, false, null, new FileBasedIndex.ValueProcessor<V>((Set)files){
            final /* synthetic */ Set val$files;
            {
                this.val$files = set;
            }

            public boolean process(VirtualFile file2, V value) {
                this.val$files.add(file2);
                return true;
            }
        }, filter, null);
        return files;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor2, @NotNull GlobalSearchScope filter) {
        return this.processValues(indexId, dataKey, inFile, processor2, filter, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor2, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        return this.processValuesImpl(indexId, dataKey, false, inFile, processor2, filter, idFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter, @NotNull ThrowableConvertor<UpdatableIndex<K, V, FileContent>, R, StorageException> computable) {
        try {
            UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return null;
            }
            Project project2 = filter.getProject();
            this.ensureUpToDate(indexId, project2, filter, restrictToFile);
            this.myAccessValidator.checkAccessingIndexDuringOtherIndexProcessing(indexId);
            try {
                index.getReadLock().lock();
                this.myAccessValidator.startedProcessingActivityForIndex(indexId);
                Object object = computable.convert(index);
                return (R)object;
            }
            finally {
                this.myAccessValidator.stoppedProcessingActivityForIndex(indexId);
                index.getReadLock().unlock();
            }
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
            return null;
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause == null) throw e;
            this.scheduleRebuild(indexId, cause);
            return null;
        }
        catch (AssertionError ae) {
            this.scheduleRebuild(indexId, (Throwable)((Object)ae));
        }
        return null;
    }

    private <K, V> boolean processValuesImpl(@NotNull ID<K, V> indexId, final @NotNull K dataKey, final boolean ensureValueProcessedOnce, final @Nullable VirtualFile restrictToFile, final @NotNull FileBasedIndex.ValueProcessor<V> processor2, final @NotNull GlobalSearchScope scope, final @Nullable IdFilter idFilter) {
        ThrowableConvertor keyProcessor = new ThrowableConvertor<UpdatableIndex<K, V, FileContent>, Boolean, StorageException>(){

            public Boolean convert(@NotNull UpdatableIndex<K, V, FileContent> index) throws StorageException {
                boolean shouldContinue;
                block4: {
                    ValueContainer container;
                    block5: {
                        container = index.getData(dataKey);
                        shouldContinue = true;
                        if (restrictToFile == null) break block5;
                        if (!(restrictToFile instanceof VirtualFileWithId)) break block4;
                        int restrictedFileId = FileBasedIndex.getFileId((VirtualFile)restrictToFile);
                        ValueContainer.ValueIterator valueIt = container.getValueIterator();
                        while (valueIt.hasNext()) {
                            Object value = valueIt.next();
                            if (!valueIt.getValueAssociationPredicate().contains(restrictedFileId) || (shouldContinue = processor2.process(restrictToFile, value))) continue;
                            break block4;
                        }
                        break block4;
                    }
                    PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
                    IdFilter filter = idFilter != null ? idFilter : FileBasedIndexImpl.this.projectIndexableFiles(scope.getProject());
                    ValueContainer.ValueIterator valueIt = container.getValueIterator();
                    block1: while (valueIt.hasNext()) {
                        Object value = valueIt.next();
                        ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                        while (inputIdsIterator.hasNext()) {
                            VirtualFile file2;
                            int id = inputIdsIterator.next();
                            if (filter != null && !filter.containsFileId(id) || (file2 = IndexInfrastructure.findFileByIdIfCached(fs, id)) == null || !scope.accept(file2)) continue;
                            shouldContinue = processor2.process(file2, value);
                            if (shouldContinue) {
                                if (!ensureValueProcessedOnce) continue;
                                continue block1;
                            }
                            break block4;
                        }
                    }
                }
                return shouldContinue;
            }
        };
        Boolean result = (Boolean)this.processExceptions(indexId, restrictToFile, scope, keyProcessor);
        return result == null || result != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<V> valueChecker, @NotNull Processor<VirtualFile> processor2) {
        ProjectIndexableFilesFilter filesSet = this.projectIndexableFiles(filter.getProject());
        TIntHashSet set = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter, valueChecker, filesSet);
        return set != null && FileBasedIndexImpl.processVirtualFiles(set, filter, processor2);
    }

    public void filesUpdateEnumerationFinished() {
        this.myContentlessIndicesUpdateQueue.ensureUpToDate();
        this.myContentlessIndicesUpdateQueue.signalUpdateEnd();
    }

    public void cleanupForNextTest() {
        this.myTransactionMap = SmartFMap.emptyMap();
    }

    void filesUpdateStarted(Project project2) {
        this.myContentlessIndicesUpdateQueue.signalUpdateStart();
        this.myContentlessIndicesUpdateQueue.ensureUpToDate();
        this.myProjectsBeingUpdated.add(project2);
        ++this.myFilesModCount;
    }

    void filesUpdateFinished(@NotNull Project project2) {
        this.myProjectsBeingUpdated.remove(project2);
        ++this.myFilesModCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project project2) {
        if (project2 == null || this.myUpdatingFiles.get() > 0) {
            return null;
        }
        if (this.myProjectsBeingUpdated.contains(project2)) {
            return null;
        }
        SoftReference reference = (SoftReference)project2.getUserData(ourProjectFilesSetKey);
        ProjectIndexableFilesFilter data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
        if (data != null && data.myModificationCount == this.myFilesModCount) {
            return data;
        }
        if (this.myCalcIndexableFilesLock.tryLock()) {
            try {
                reference = (SoftReference)project2.getUserData(ourProjectFilesSetKey);
                data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
                if (data != null && data.myModificationCount == this.myFilesModCount) {
                    ProjectIndexableFilesFilter projectIndexableFilesFilter = data;
                    return projectIndexableFilesFilter;
                }
                long start = System.currentTimeMillis();
                final TIntArrayList filesSet = new TIntArrayList();
                this.iterateIndexableFiles(new ContentIterator(){

                    public boolean processFile(@NotNull VirtualFile fileOrDir) {
                        filesSet.add(((VirtualFileWithId)fileOrDir).getId());
                        return true;
                    }
                }, project2, (ProgressIndicator)SilentProgressIndicator.create());
                ProjectIndexableFilesFilter filter = new ProjectIndexableFilesFilter(filesSet, this.myFilesModCount);
                project2.putUserData(ourProjectFilesSetKey, new SoftReference<ProjectIndexableFilesFilter>(filter));
                long finish = System.currentTimeMillis();
                LOG.debug(filesSet.size() + " files iterated in " + (finish - start) + " ms");
                ProjectIndexableFilesFilter projectIndexableFilesFilter = filter;
                return projectIndexableFilesFilter;
            }
            finally {
                this.myCalcIndexableFilesLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    private <K, V> TIntHashSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, final @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter, final @Nullable Condition<V> valueChecker, final @Nullable ProjectIndexableFilesFilter projectFilesFilter) {
        ThrowableConvertor convertor = new ThrowableConvertor<UpdatableIndex<K, V, FileContent>, TIntHashSet, StorageException>(){

            @Nullable
            public TIntHashSet convert(@NotNull UpdatableIndex<K, V, FileContent> index) throws StorageException {
                TIntHashSet mainIntersection = null;
                for (Object dataKey : dataKeys) {
                    ProgressManager.checkCanceled();
                    final TIntHashSet copy = new TIntHashSet();
                    ValueContainer container = index.getData(dataKey);
                    final ValueContainer.ValueIterator valueIt = container.getValueIterator();
                    while (valueIt.hasNext()) {
                        Object value = valueIt.next();
                        if (valueChecker != null && !valueChecker.value(value)) continue;
                        ValueContainer.IntIterator iterator = valueIt.getInputIdsIterator();
                        if (mainIntersection == null || iterator.size() < mainIntersection.size()) {
                            while (iterator.hasNext()) {
                                int id = iterator.next();
                                if ((mainIntersection != null || projectFilesFilter != null && !projectFilesFilter.containsFileId(id)) && (mainIntersection == null || !mainIntersection.contains(id))) continue;
                                copy.add(id);
                            }
                            continue;
                        }
                        mainIntersection.forEach(new TIntProcedure(){
                            final ValueContainer.IntPredicate predicate;
                            {
                                this.predicate = valueIt.getValueAssociationPredicate();
                            }

                            public boolean execute(int id) {
                                if (this.predicate.contains(id)) {
                                    copy.add(id);
                                }
                                return true;
                            }
                        });
                    }
                    mainIntersection = copy;
                    if (!mainIntersection.isEmpty()) continue;
                    return new TIntHashSet();
                }
                return mainIntersection;
            }
        };
        return (TIntHashSet)this.processExceptions(indexId, null, filter, convertor);
    }

    private static boolean processVirtualFiles(@NotNull TIntHashSet ids, final @NotNull GlobalSearchScope filter, final @NotNull Processor<VirtualFile> processor2) {
        final PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        return ids.forEach(new TIntProcedure(){

            public boolean execute(int id) {
                ProgressManager.checkCanceled();
                VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id);
                if (file2 != null && filter.accept(file2)) {
                    return processor2.process((Object)file2);
                }
                return true;
            }
        });
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<K> dataKeys, @NotNull Processor<VirtualFile> processor2, @NotNull GlobalSearchScope filter) {
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter, null, processor2);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        this.requestRebuild(indexId, new Throwable(e));
    }

    private static void scheduleIndexRebuild(String reason) {
        LOG.info("scheduleIndexRebuild, reason: " + reason);
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DumbService.getInstance((Project)project2).queueTask((DumbModeTask)new UnindexedFilesUpdater(project2, false));
        }
    }

    private void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        this.advanceIndexVersion(indexId);
        this.doClearIndex(indexId);
    }

    private void doClearIndex(ID<?, ?> indexId) throws StorageException {
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null) : "Index with key " + indexId + " not found or not registered properly";
        index.clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexingStamp.rewriteVersion(IndexInfrastructure.getVersionFile(indexId), this.myIndexIdToVersionMap.get(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Set<Document> getUnsavedDocuments() {
        Document[] documents = this.myFileDocumentManager.getUnsavedDocuments();
        if (documents.length == 0) {
            return Collections.emptySet();
        }
        if (documents.length == 1) {
            return Collections.singleton(documents[0]);
        }
        return new THashSet(Arrays.asList(documents));
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        return this.myTransactionMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project2, final GlobalSearchScope filter, final VirtualFile restrictedFile) throws StorageException {
        List documentsToProcessForProject;
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        THashSet documents = this.getUnsavedDocuments();
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(indexId);
        if (psiBasedIndex) {
            Set<Document> transactedDocuments = this.getTransactedDocuments();
            if (documents.size() == 0) {
                documents = transactedDocuments;
            } else if (transactedDocuments.size() > 0) {
                documents = new THashSet(documents);
                documents.addAll(transactedDocuments);
            }
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, (Condition)new Condition<Document>(){

            public boolean value(Document document) {
                return FileBasedIndexImpl.belongsToScope(FileBasedIndexImpl.this.myFileDocumentManager.getFile(document), restrictedFile, filter);
            }
        })).isEmpty()) {
            StorageGuard.StorageModeExitHandler guard = this.setDataBufferingEnabled(true);
            try {
                boolean processedAll;
                DocumentUpdateTask task = this.myUnsavedDataUpdateTasks.get(indexId);
                assert (task != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
                boolean bl = processedAll = task.processAll(documentsToProcessForProject, project2) && documentsToProcessForProject.size() == documents.size();
                if (processedAll && !this.hasActiveTransactions()) {
                    ProgressManager.checkCanceled();
                    this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
                }
            }
            finally {
                guard.leave();
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    private boolean indexUnsavedDocument(final @NotNull Document document, final @NotNull ID<?, ?> requestedIndexId, final Project project2, final @NotNull VirtualFile vFile) {
        final PsiFile dominantContentFile = project2 == null ? null : FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project2);
        final DocumentContent content = dominantContentFile != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(requestedIndexId);
        final long currentDocStamp = psiBasedIndex ? PsiDocumentManager.getInstance((Project)project2).getLastCommittedStamp(document) : content.getModificationStamp();
        final long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return false;
        }
        final CharSequence contentText = content.getText();
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(vFile, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!FileBasedIndexImpl.this.isTooLarge(vFile, contentText.length()) && FileBasedIndexImpl.this.getAffectedIndexCandidates(vFile).contains(requestedIndexId) && FileBasedIndexImpl.this.getInputFilter(requestedIndexId).acceptInput(vFile)) {
                    FileContentImpl newFc;
                    WeakReference previousContentRef = (WeakReference)document.getUserData(ourFileContentKey);
                    FileContentImpl previousContent = (FileContentImpl)((Object)com.intellij.reference.SoftReference.dereference((Reference)previousContentRef));
                    if (previousContent != null && previousContent.getStamp() == currentDocStamp) {
                        newFc = previousContent;
                    } else {
                        newFc = new FileContentImpl(vFile, contentText, vFile.getCharset(), currentDocStamp);
                        document.putUserData(ourFileContentKey, new WeakReference<FileContentImpl>(newFc));
                    }
                    FileBasedIndexImpl.initFileContent(newFc, project2, dominantContentFile);
                    if (content instanceof AuthenticContent) {
                        newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                    }
                    int inputId = Math.abs(FileBasedIndex.getFileId((VirtualFile)vFile));
                    try {
                        FileBasedIndexImpl.this.getIndex(requestedIndexId).update(inputId, newFc).compute();
                    }
                    finally {
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                }
                long previousState = FileBasedIndexImpl.this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
                assert (previousState == previousDocStamp);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private StorageGuard.StorageModeExitHandler setDataBufferingEnabled(boolean enabled) {
        StorageGuard.StorageModeExitHandler storageModeExitHandler = this.myStorageLock.enter(enabled);
        if (this.myPreviousDataBufferingState != enabled) {
            Object object = this.myBufferingStateUpdateLock;
            synchronized (object) {
                if (this.myPreviousDataBufferingState != enabled) {
                    for (ID<?, ?> indexId : this.myIndices.keySet()) {
                        MapReduceIndex index = (MapReduceIndex)this.getIndex(indexId);
                        assert (index != null);
                        ((MemoryIndexStorage)index.getStorage()).setBufferingEnabled(enabled);
                    }
                    this.myPreviousDataBufferingState = enabled;
                }
            }
        }
        return storageModeExitHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupMemoryStorage() {
        this.myLastIndexedDocStamps.clear();
        for (ID<?, ?> indexId : this.myIndices.keySet()) {
            MapReduceIndex index = (MapReduceIndex)this.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            index.getWriteLock().lock();
            try {
                memStorage.clearMemoryMap();
            }
            finally {
                index.getWriteLock().unlock();
            }
            memStorage.fireMemoryStorageCleared();
        }
    }

    private void dropUnregisteredIndices() {
        Set<String> indicesToDrop = FileBasedIndexImpl.readRegisteredIndexNames();
        for (ID<?, ?> key : this.myIndices.keySet()) {
            indicesToDrop.remove(key.toString());
        }
        for (String s : indicesToDrop) {
            FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s)));
        }
    }

    public void requestRebuild(final ID<?, ?> indexId, Throwable throwable) {
        FileBasedIndexImpl.cleanupProcessedFlag();
        final AtomicInteger status = ourRebuildStatus.get(indexId);
        boolean requiresRebuildWasSet = status.compareAndSet(1, 2);
        if (requiresRebuildWasSet) {
            String message = "Rebuild requested for index " + indexId;
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() && app.isReadAccessAllowed() && !app.isDispatchThread()) {
                LOG.error(message, throwable);
            } else {
                LOG.info(message, throwable);
            }
            FileBasedIndexImpl.cleanupProcessedFlag();
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = new Runnable(){

                @Override
                public void run() {
                    final Ref success = Ref.create((Object)true);
                    new Task.Modal(null, "Updating index", false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            indicator.setIndeterminate(true);
                            try {
                                FileBasedIndexImpl.this.doClearIndex(indexId);
                            }
                            catch (StorageException e) {
                                success.set((Object)false);
                                FileBasedIndexImpl.this.requestRebuild(indexId);
                                LOG.info((Throwable)e);
                            }
                        }
                    }.queue();
                    if (((Boolean)success.get()).booleanValue()) {
                        FileBasedIndexImpl.scheduleIndexRebuild("checkRebuild");
                        status.compareAndSet(2, 1);
                    }
                }
            };
            if (this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(rebuildRunnable, ModalityState.NON_MODAL);
            }
        }
    }

    private <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair = this.myIndices.get(indexId);
        assert (pair != null) : "Index data is absent for index " + indexId;
        return (UpdatableIndex)pair.getFirst();
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair = this.myIndices.get(indexId);
        assert (pair != null) : "Index data is absent for index " + indexId;
        return (FileBasedIndex.InputFilter)pair.getSecond();
    }

    public int getChangedFileCount() {
        return this.myChangedFilesCollector.getAllFilesToUpdate().size();
    }

    @NotNull
    public Collection<VirtualFile> getFilesToUpdate(final Project project2) {
        return ContainerUtil.findAll(this.myChangedFilesCollector.getAllFilesToUpdate(), (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                if (virtualFile instanceof DeletedVirtualFileStub) {
                    return true;
                }
                for (IndexableFileSet set : FileBasedIndexImpl.this.myIndexableSets) {
                    Project proj = (Project)FileBasedIndexImpl.this.myIndexableSetToProjectMap.get(set);
                    if (proj != null && !proj.equals(project2) || !set.isInSet(virtualFile)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return !this.myChangedFilesCollector.myFilesToUpdate.containsKey(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)));
    }

    void processRefreshedFile(@Nullable Project project2, @NotNull com.intellij.ide.caches.FileContent fileContent) {
        VirtualFile file2 = fileContent.getVirtualFile();
        if (this.myChangedFilesCollector.myFilesToUpdate.containsKey(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)))) {
            this.indexFileContent(project2, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFileContent(@Nullable Project project2, @NotNull com.intellij.ide.caches.FileContent content) {
        VirtualFile file2 = content.getVirtualFile();
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        try {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.removeDataFromIndicesForFile(fileId);
                if (file2 instanceof DeletedVirtualFileStub && ((DeletedVirtualFileStub)file2).isResurrected()) {
                    this.doIndexFileContent(project2, new com.intellij.ide.caches.FileContent(((DeletedVirtualFileStub)file2).getOriginalFile()));
                }
            } else {
                this.doIndexFileContent(project2, content);
            }
        }
        finally {
            IndexingStamp.flushCache(fileId);
        }
        this.myChangedFilesCollector.myFilesToUpdate.remove(fileId);
    }

    private void doIndexFileContent(@Nullable Project project2, final @NotNull com.intellij.ide.caches.FileContent content) {
        final VirtualFile file2 = content.getVirtualFile();
        final FileType fileType = file2.getFileType();
        final Project finalProject = project2 == null ? ProjectUtil.guessProjectForFile((VirtualFile)file2) : project2;
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = null;
                FileContentImpl fc = null;
                int inputId = -1;
                List affectedIndexCandidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file2);
                int size = affectedIndexCandidates.size();
                for (int i = 0; i < size; ++i) {
                    ID indexId = (ID)affectedIndexCandidates.get(i);
                    if (!FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                    if (fc == null) {
                        byte[] currentBytes;
                        try {
                            currentBytes = content.getBytes();
                        }
                        catch (IOException e) {
                            currentBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
                        }
                        fc = new FileContentImpl(file2, currentBytes);
                        if (!fileType.isBinary() && IdIndex.ourSnapshotMappingsEnabled) {
                            try {
                                byte[] hash = ContentHashesSupport.calcContentHashWithFileType(currentBytes, fc.getCharset(), SubstitutedFileType.substituteFileType(file2, fileType, finalProject));
                                fc.setHash(hash);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                        psiFile = (PsiFile)content.getUserData(IndexingDataKeys.PSI_FILE);
                        FileBasedIndexImpl.initFileContent(fc, finalProject, psiFile);
                        inputId = Math.abs(FileBasedIndex.getFileId((VirtualFile)file2));
                    }
                    try {
                        ProgressManager.checkCanceled();
                        FileBasedIndexImpl.this.updateSingleIndex(indexId, inputId, fc);
                        continue;
                    }
                    catch (ProcessCanceledException e) {
                        FileBasedIndexImpl.cleanFileContent(fc, psiFile);
                        throw e;
                    }
                    catch (StorageException e) {
                        FileBasedIndexImpl.this.requestRebuild(indexId);
                        LOG.info((Throwable)e);
                    }
                }
                if (psiFile != null) {
                    psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
                }
            }
        });
    }

    public boolean isIndexingCandidate(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        return !this.isTooLarge(file2) && this.getAffectedIndexCandidates(file2).contains(indexId);
    }

    @NotNull
    private List<ID<?, ?>> getAffectedIndexCandidates(@NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, null) ? Collections.emptyList() : this.myIndicesForDirectories;
        }
        FileType fileType = file2.getFileType();
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, fileType)) {
            return Collections.emptyList();
        }
        List<ID<?, ?>> ids = this.myFileType2IndicesWithFileTypeInfoMap.get(fileType);
        if (ids == null) {
            ids = this.myIndicesWithoutFileTypeInfo;
        }
        return ids;
    }

    private static void cleanFileContent(@NotNull FileContentImpl fc, PsiFile psiFile) {
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc, Project project2, PsiFile psiFile) {
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
        fc.putUserData(IndexingDataKeys.PROJECT, project2);
    }

    void updateSingleIndex(@NotNull ID<?, ?> indexId, int inputId, @Nullable FileContent currentFC) throws StorageException {
        boolean hasContent;
        if (ourRebuildStatus.get(indexId).get() == 2 && !this.myIsUnitTestMode) {
            return;
        }
        ++this.myLocalModCount;
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null);
        boolean bl = hasContent = currentFC != null;
        if (hasContent && currentFC.getUserData(ourPhysicalContentKey) == null) {
            currentFC.putUserData(ourPhysicalContentKey, (Object)Boolean.TRUE);
        }
        boolean updateCalculated = false;
        try {
            Computable<Boolean> update = index.update(inputId, currentFC);
            updateCalculated = true;
            this.scheduleUpdate(indexId, update, inputId, hasContent);
        }
        catch (RuntimeException exception) {
            Throwable causeToRebuildIndex = FileBasedIndexImpl.getCauseToRebuildIndex(exception);
            if (causeToRebuildIndex != null && (updateCalculated || causeToRebuildIndex instanceof IOException)) {
                this.requestRebuild(indexId, exception);
                return;
            }
            throw exception;
        }
    }

    private void forceUpdate(@Nullable Project project2, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.myChangedFilesCollector.getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && (this.myForceUpdateRequests.incrementAndGet() & 0x3F) == 0;
            List virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, (Condition)new ProjectFilesCondition(this.projectIndexableFiles(project2), filter, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate(final @NotNull ID<?, ?> indexId, final Computable<Boolean> update, final int inputId, final boolean hasContent) {
        if (this.myNotRequiringContentIndices.contains(indexId) && !Registry.is((String)"idea.concurrent.scanning.files.to.index")) {
            this.myContentlessIndicesUpdateQueue.submit(new Computable<Boolean>(){

                public Boolean compute() {
                    return FileBasedIndexImpl.this.updateWithBufferingEnabled((Computable<Boolean>)update);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    FileBasedIndexImpl.this.indexedStampUpdate(indexId, inputId, hasContent);
                }
            });
        } else if (this.updateWithBufferingEnabled(update)) {
            AccessToken accessToken = ReadAction.start();
            try {
                this.indexedStampUpdate(indexId, inputId, hasContent);
            }
            finally {
                accessToken.finish();
            }
        }
    }

    protected void indexedStampUpdate(@NotNull ID<?, ?> indexId, int fileId, boolean hasContent) {
        if (hasContent) {
            IndexingStamp.setFileIndexedStateCurrent(fileId, indexId);
        } else {
            IndexingStamp.setFileIndexedStateOutdated(fileId, indexId);
        }
        if (this.myNotRequiringContentIndices.contains(indexId)) {
            IndexingStamp.flushCache(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateWithBufferingEnabled(@NotNull Computable<Boolean> update) {
        StorageGuard.StorageModeExitHandler lock = this.setDataBufferingEnabled(false);
        try {
            boolean bl = (Boolean)update.compute();
            return bl;
        }
        finally {
            lock.leave();
        }
    }

    private boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        return !this.myNotRequiringContentIndices.contains(indexId);
    }

    @Nullable
    private IndexableFileSet getIndexableSetForFile(VirtualFile file2) {
        for (IndexableFileSet set : this.myIndexableSets) {
            if (!set.isInSet(file2)) continue;
            return set;
        }
        return null;
    }

    private void doInvalidateIndicesForFile(@NotNull VirtualFile file2, boolean contentChanged) {
        FileBasedIndexImpl.cleanProcessedFlag(file2);
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        IndexingStamp.flushCache(fileId);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!contentChanged) {
            for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
                if (!this.myNotRequiringContentIndices.contains(indexId)) continue;
                try {
                    this.updateSingleIndex(indexId, fileId, null);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                    this.requestRebuild(indexId);
                }
            }
            this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
        }
        Collection fileIndexedStatesToUpdate = ContainerUtil.intersection(nontrivialFileIndexedStates, this.myRequiringContentIndices);
        if (contentChanged) {
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                int size = nontrivialFileIndexedStates.size();
                for (int i = 0; i < size; ++i) {
                    ID<?, ?> indexId = nontrivialFileIndexedStates.get(i);
                    if (!this.needsFileContentLoading(indexId) || !IndexingStamp.isFileIndexedStateCurrent(fileId, indexId)) continue;
                    IndexingStamp.setFileIndexedStateOutdated(fileId, indexId);
                }
                this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(file2);
                if (!this.isTooLarge(file2)) {
                    this.myChangedFilesCollector.scheduleForUpdate(file2);
                }
            }
        } else if (!fileIndexedStatesToUpdate.isEmpty()) {
            this.myChangedFilesCollector.scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
        }
        IndexingStamp.flushCache(fileId);
    }

    private void scheduleFileForIndexing(final VirtualFile file2, boolean contentChange) {
        boolean fileIsDirectory = file2.isDirectory();
        if (!contentChange) {
            FileContentImpl fileContent = null;
            int inputId = -1;
            for (ID<?, ?> indexId : fileIsDirectory ? this.myIndicesForDirectories : this.myNotRequiringContentIndices) {
                if (!this.getInputFilter(indexId).acceptInput(file2)) continue;
                try {
                    if (fileContent == null) {
                        fileContent = new FileContentImpl(file2);
                        inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)file2));
                    }
                    this.updateSingleIndex(indexId, inputId, fileContent);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                    this.requestRebuild(indexId);
                }
            }
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
            } else {
                this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, new Runnable(){

                    @Override
                    public void run() {
                        List candidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file2);
                        int fileId = FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2);
                        boolean scheduleForUpdate = false;
                        boolean resetStamp = false;
                        int size = candidates.size();
                        for (int i = 0; i < size; ++i) {
                            ID indexId = (ID)candidates.get(i);
                            if (!FileBasedIndexImpl.this.needsFileContentLoading(indexId) || !FileBasedIndexImpl.this.getInputFilter(indexId).acceptInput(file2)) continue;
                            if (IndexingStamp.isFileIndexedStateCurrent(fileId, indexId)) {
                                IndexingStamp.setFileIndexedStateOutdated(fileId, indexId);
                                resetStamp = true;
                            }
                            scheduleForUpdate = true;
                        }
                        if (scheduleForUpdate) {
                            if (resetStamp) {
                                IndexingStamp.flushCache(fileId);
                            }
                            FileBasedIndexImpl.this.myChangedFilesCollector.scheduleForUpdate(file2);
                        }
                        if (!FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
                            FileBasedIndexImpl.this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(file2);
                        }
                    }
                });
            }
        }
    }

    private boolean clearUpToDateStateForPsiIndicesOfUnsavedDocuments(@NotNull VirtualFile file2) {
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
                for (ID<?, ?> psiBackedIndex : this.myPsiDependentIndices) {
                    this.myUpToDateIndicesForUnsavedOrTransactedDocuments.remove(psiBackedIndex);
                }
            }
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return true;
        }
        return false;
    }

    private static int getIdMaskingNonIdBasedFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWithId ? ((VirtualFileWithId)file2).getId() : 0;
    }

    private boolean shouldIndexFile(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        return this.getInputFilter(indexId).acceptInput(file2) && (FileBasedIndexImpl.isMock(file2) || !IndexingStamp.isFileIndexedStateCurrent(((NewVirtualFile)file2).getId(), indexId));
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file2) {
        String filePath = file2.getPath();
        return this.myConfigPath != null && FileUtil.startsWith((String)filePath, (String)this.myConfigPath) || this.myLogPath != null && FileUtil.startsWith((String)filePath, (String)this.myLogPath);
    }

    private static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    private boolean isTooLarge(@NotNull VirtualFile file2) {
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
        }
        return false;
    }

    private boolean isTooLarge(@NotNull VirtualFile file2, long contentSize) {
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    @NotNull
    public CollectingContentIterator createContentIterator(@Nullable ProgressIndicator indicator) {
        return new UnindexedFilesFinder(indicator);
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set, @Nullable Project project2) {
        this.myIndexableSets.add(set);
        this.myIndexableSetToProjectMap.put(set, project2);
        if (project2 != null) {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).addTreeChangePreprocessor(new PsiTreeChangePreprocessor(){

                @Override
                public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
                    VirtualFile virtualFile;
                    PsiFile file2;
                    if (event.isGenericChange() && event.getCode() == PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED && (file2 = event.getFile()) != null && !FileBasedIndexImpl.this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(virtualFile = file2.getVirtualFile()) && virtualFile instanceof VirtualFileWithId) {
                        int fileId = ((VirtualFileWithId)virtualFile).getId();
                        boolean wasIndexed = false;
                        for (ID psiBackedIndex : FileBasedIndexImpl.this.myPsiDependentIndices) {
                            if (!IndexingStamp.isFileIndexedStateCurrent(fileId, psiBackedIndex)) continue;
                            IndexingStamp.setFileIndexedStateOutdated(fileId, psiBackedIndex);
                            wasIndexed = true;
                        }
                        if (wasIndexed) {
                            FileBasedIndexImpl.this.myChangedFilesCollector.scheduleForUpdate(virtualFile);
                            IndexingStamp.flushCache(fileId);
                        }
                    }
                }
            });
        }
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set) {
        if (!this.myIndexableSetToProjectMap.containsKey(set)) {
            return;
        }
        this.myIndexableSets.remove(set);
        this.myIndexableSetToProjectMap.remove(set);
        for (VirtualFile file2 : this.myChangedFilesCollector.getAllFilesToUpdate()) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId);
                this.myChangedFilesCollector.myFilesToUpdate.remove(fileId);
                continue;
            }
            if (this.getIndexableSetForFile(file2) != null) continue;
            this.myChangedFilesCollector.myFilesToUpdate.remove(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project2, int id) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project2) {
        return PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(doc);
    }

    private static void cleanupProcessedFlag() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots()) {
            FileBasedIndexImpl.cleanProcessedFlag(root);
        }
    }

    private static void cleanProcessedFlag(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileSystemEntry)) {
            return;
        }
        VirtualFileSystemEntry nvf = (VirtualFileSystemEntry)file2;
        if (file2.isDirectory()) {
            nvf.setFileIndexed(false);
            for (VirtualFile child : nvf.getCachedChildren()) {
                FileBasedIndexImpl.cleanProcessedFlag(child);
            }
        } else {
            nvf.setFileIndexed(false);
        }
    }

    public void iterateIndexableFilesConcurrently(@NotNull ContentIterator processor2, @NotNull Project project2, ProgressIndicator indicator) {
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(FileBasedIndexImpl.collectScanRootRunnables(processor2, project2, indicator));
    }

    public void iterateIndexableFiles(@NotNull ContentIterator processor2, @NotNull Project project2, ProgressIndicator indicator) {
        for (Runnable r : FileBasedIndexImpl.collectScanRootRunnables(processor2, project2, indicator)) {
            r.run();
        }
    }

    @NotNull
    private static List<Runnable> collectScanRootRunnables(final @NotNull ContentIterator processor2, final @NotNull Project project2, final ProgressIndicator indicator) {
        if (project2.isDisposed()) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        tasks.add(new Runnable(){

            @Override
            public void run() {
                projectFileIndex.iterateContent(processor2);
            }
        });
        final Set visitedRoots = ContainerUtil.newConcurrentSet();
        for (IndexableSetContributor indexableSetContributor : (IndexableSetContributor[])Extensions.getExtensions((ExtensionPointName)IndexableSetContributor.EP_NAME)) {
            if (project2.isDisposed()) {
                return tasks;
            }
            for (final VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)indexableSetContributor)) {
                if (!visitedRoots.add(root)) continue;
                tasks.add(new Runnable(){

                    @Override
                    public void run() {
                        if (project2.isDisposed() || !root.isValid()) {
                            return;
                        }
                        FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, null);
                    }
                });
            }
            for (final VirtualFile root : IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)indexableSetContributor, (Project)project2)) {
                if (!visitedRoots.add(root)) continue;
                tasks.add(new Runnable(){

                    @Override
                    public void run() {
                        if (project2.isDisposed() || !root.isValid()) {
                            return;
                        }
                        FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, null);
                    }
                });
            }
        }
        for (IndexableSetContributor indexableSetContributor : ModuleManager.getInstance((Project)project2).getModules()) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)indexableSetContributor).getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid()) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] libSources = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
                VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{libSources, libClasses};
                int n = virtualFileArrayArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile[] roots;
                    for (VirtualFile root : roots = virtualFileArrayArray[i]) {
                        if (!visitedRoots.add(root)) continue;
                        tasks.add(new Runnable((Module)indexableSetContributor, root, processor2, indicator, visitedRoots, projectFileIndex){
                            final /* synthetic */ Module val$module;
                            final /* synthetic */ VirtualFile val$root;
                            final /* synthetic */ ContentIterator val$processor;
                            final /* synthetic */ ProgressIndicator val$indicator;
                            final /* synthetic */ Set val$visitedRoots;
                            final /* synthetic */ ProjectFileIndex val$projectFileIndex;
                            {
                                this.val$module = module2;
                                this.val$root = virtualFile;
                                this.val$processor = contentIterator;
                                this.val$indicator = progressIndicator;
                                this.val$visitedRoots = set;
                                this.val$projectFileIndex = projectFileIndex;
                            }

                            @Override
                            public void run() {
                                if (project2.isDisposed() || this.val$module.isDisposed() || !this.val$root.isValid()) {
                                    return;
                                }
                                FileBasedIndex.iterateRecursively((VirtualFile)this.val$root, (ContentIterator)this.val$processor, (ProgressIndicator)this.val$indicator, (Set)this.val$visitedRoots, (ProjectFileIndex)this.val$projectFileIndex);
                            }
                        });
                    }
                }
            }
        }
        return tasks;
    }

    private final class DocumentUpdateTask
    extends UpdateTask<Document> {
        private final ID<?, ?> myIndexId;

        public DocumentUpdateTask(ID<?, ?> indexId) {
            this.myIndexId = indexId;
        }

        @Override
        void doProcess(Document document, Project project2) {
            FileBasedIndexImpl.this.indexUnsavedDocument(document, this.myIndexId, project2, FileBasedIndexImpl.this.myFileDocumentManager.getFile(document));
        }
    }

    private static class StorageGuard {
        private int myHolds;
        private int myWaiters;
        private final StorageModeExitHandler myTrueStorageModeExitHandler = new StorageModeExitHandler(){

            @Override
            public void leave() {
                this.leave(true);
            }
        };
        private final StorageModeExitHandler myFalseStorageModeExitHandler = new StorageModeExitHandler(){

            @Override
            public void leave() {
                this.leave(false);
            }
        };

        private StorageGuard() {
        }

        @NotNull
        private synchronized StorageModeExitHandler enter(boolean mode) {
            if (mode) {
                while (this.myHolds < 0) {
                    this.doWait();
                }
                ++this.myHolds;
                return this.myTrueStorageModeExitHandler;
            }
            while (this.myHolds > 0) {
                this.doWait();
            }
            --this.myHolds;
            return this.myFalseStorageModeExitHandler;
        }

        private void doWait() {
            try {
                ++this.myWaiters;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                --this.myWaiters;
            }
        }

        private synchronized void leave(boolean mode) {
            this.myHolds += mode ? -1 : 1;
            if (this.myHolds == 0 && this.myWaiters > 0) {
                this.notifyAll();
            }
        }

        public static interface StorageModeExitHandler {
            public void leave();
        }
    }

    private static class IndexableFilesFilter
    implements FileBasedIndex.InputFilter {
        private final FileBasedIndex.InputFilter myDelegate;

        private IndexableFilesFilter(FileBasedIndex.InputFilter delegate) {
            this.myDelegate = delegate;
        }

        public boolean acceptInput(@NotNull VirtualFile file2) {
            return file2 instanceof VirtualFileWithId && this.myDelegate.acceptInput(file2);
        }
    }

    private class UnindexedFilesFinder
    implements CollectingContentIterator {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        @Nullable
        private final ProgressIndicator myProgressIndicator;

        private UnindexedFilesFinder(ProgressIndicator indicator) {
            this.myProgressIndicator = indicator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<VirtualFile> getFiles() {
            List<VirtualFile> files;
            List<VirtualFile> list = this.myFiles;
            synchronized (list) {
                files = this.myFiles;
            }
            BitSet usedFileIds = new BitSet(files.size());
            ArrayList<VirtualFile> localFileSystemFiles = new ArrayList<VirtualFile>(files.size() / 2);
            ArrayList<VirtualFile> archiveFiles = new ArrayList<VirtualFile>(files.size() / 2);
            for (VirtualFile file2 : files) {
                int fileId = ((VirtualFileWithId)file2).getId();
                if (fileId > 0) {
                    if (usedFileIds.get(fileId)) continue;
                    usedFileIds.set(fileId);
                }
                if (file2.getFileSystem() instanceof LocalFileSystem) {
                    localFileSystemFiles.add(file2);
                    continue;
                }
                archiveFiles.add(file2);
            }
            localFileSystemFiles.addAll(archiveFiles);
            return localFileSystemFiles;
        }

        public boolean processFile(final @NotNull VirtualFile file2) {
            if (!file2.isValid()) {
                return true;
            }
            if (file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed()) {
                return true;
            }
            if (!(file2 instanceof VirtualFileWithId)) {
                return true;
            }
            FileBasedIndexImpl.this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean oldStuff = true;
                    if (file2.isDirectory() || !FileBasedIndexImpl.this.isTooLarge(file2)) {
                        List affectedIndexCandidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file2);
                        int size = affectedIndexCandidates.size();
                        for (int i = 0; i < size; ++i) {
                            ID indexId = (ID)affectedIndexCandidates.get(i);
                            try {
                                if (!FileBasedIndexImpl.this.needsFileContentLoading(indexId) || !FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                                List list = UnindexedFilesFinder.this.myFiles;
                                synchronized (list) {
                                    UnindexedFilesFinder.this.myFiles.add(file2);
                                }
                                oldStuff = false;
                                break;
                            }
                            catch (RuntimeException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException || cause instanceof StorageException) {
                                    LOG.info((Throwable)e);
                                    FileBasedIndexImpl.this.requestRebuild(indexId);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    FileContentImpl fileContent = null;
                    int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                    for (ID indexId : FileBasedIndexImpl.this.myNotRequiringContentIndices) {
                        if (!FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                        oldStuff = false;
                        try {
                            if (fileContent == null) {
                                fileContent = new FileContentImpl(file2);
                            }
                            FileBasedIndexImpl.this.updateSingleIndex(indexId, inputId, fileContent);
                        }
                        catch (StorageException e) {
                            LOG.info((Throwable)e);
                            FileBasedIndexImpl.this.requestRebuild(indexId);
                        }
                    }
                    IndexingStamp.flushCache(inputId);
                    if (oldStuff && file2 instanceof VirtualFileSystemEntry) {
                        ((VirtualFileSystemEntry)file2).setFileIndexed(true);
                    }
                }
            });
            if (this.myProgressIndicator != null && file2.isDirectory()) {
                this.myProgressIndicator.checkCanceled();
                this.myProgressIndicator.setText("Scanning files to index");
            }
            return true;
        }
    }

    private final class ChangedFilesCollector
    extends IndexedFilesListener {
        private final ConcurrentIntObjectMap<VirtualFile> myFilesToUpdate = ContainerUtil.createConcurrentIntObjectMap();
        private final ManagingFS myManagingFS = ManagingFS.getInstance();

        private ChangedFilesCollector() {
        }

        @Override
        protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
            FileBasedIndexImpl.cleanProcessedFlag(file2);
            if (!contentChange) {
                FileBasedIndexImpl.this.myUpdatingFiles.incrementAndGet();
            }
            super.buildIndicesForFileRecursively(file2, contentChange);
            IndexingStamp.flushCaches();
            if (!contentChange && FileBasedIndexImpl.this.myUpdatingFiles.decrementAndGet() == 0) {
                ++FileBasedIndexImpl.this.myFilesModCount;
            }
        }

        @Override
        protected void iterateIndexableFiles(VirtualFile file2, ContentIterator iterator) {
            for (IndexableFileSet set : FileBasedIndexImpl.this.myIndexableSets) {
                if (!set.isInSet(file2)) continue;
                set.iterateIndexableFilesIn(file2, iterator);
            }
        }

        @Override
        protected void buildIndicesForFile(VirtualFile file2, boolean contentChange) {
            FileBasedIndexImpl.this.scheduleFileForIndexing(file2, contentChange);
        }

        @Override
        protected boolean invalidateIndicesForFile(VirtualFile file2, boolean contentChange) {
            if (FileBasedIndexImpl.this.isUnderConfigOrSystem(file2)) {
                return false;
            }
            if (file2.isDirectory()) {
                FileBasedIndexImpl.this.doInvalidateIndicesForFile(file2, contentChange);
                if (!FileBasedIndexImpl.isMock(file2) && !this.myManagingFS.wereChildrenAccessed(file2)) {
                    return false;
                }
            } else {
                FileBasedIndexImpl.this.doInvalidateIndicesForFile(file2, contentChange);
            }
            return true;
        }

        void scheduleForUpdate(VirtualFile file2) {
            IndexableFileSet setForFile;
            if (!(file2 instanceof DeletedVirtualFileStub) && (setForFile = FileBasedIndexImpl.this.getIndexableSetForFile(file2)) == null) {
                return;
            }
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.put(fileId, (Object)file2);
            if (previousVirtualFile instanceof DeletedVirtualFileStub && !previousVirtualFile.equals(file2)) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(true);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        private void removeScheduledFileFromUpdate(VirtualFile file2) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.remove(fileId);
            if (previousVirtualFile instanceof DeletedVirtualFileStub) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(false);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        public Collection<VirtualFile> getAllFilesToUpdate() {
            if (this.myFilesToUpdate.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
        }

        @Override
        public void before(@NotNull List<? extends VFileEvent> events) {
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.signalUpdateStart();
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.ensureUpToDate();
            for (VFileEvent vFileEvent : events) {
                if (!this.memoryStorageCleaningNeeded(vFileEvent)) continue;
                FileBasedIndexImpl.this.cleanupMemoryStorage();
                break;
            }
            super.before(events);
        }

        private boolean memoryStorageCleaningNeeded(VFileEvent event) {
            Object requestor = event.getRequestor();
            return requestor instanceof FileDocumentManager || requestor instanceof PsiManager || requestor == LocalHistory.VFS_EVENT_REQUESTOR;
        }

        @Override
        public void after(@NotNull List<? extends VFileEvent> events) {
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.ensureUpToDate();
            super.after(events);
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.signalUpdateEnd();
        }
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        @Override
        void doProcess(VirtualFile item, Project project2) {
            FileBasedIndexImpl.this.processRefreshedFile(project2, new com.intellij.ide.caches.FileContent(item));
        }
    }

    private static class PsiContent
    implements DocumentContent {
        private final Document myDocument;
        private final PsiFile myFile;

        private PsiContent(Document document, PsiFile file2) {
            this.myDocument = document;
            this.myFile = file2;
        }

        @Override
        public CharSequence getText() {
            if (this.myFile.getViewProvider().getModificationStamp() != this.myDocument.getModificationStamp()) {
                FileASTNode node = this.myFile.getNode();
                assert (node != null);
                return node.getChars();
            }
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myFile.getViewProvider().getModificationStamp();
        }
    }

    private static class AuthenticContent
    implements DocumentContent {
        private final Document myDocument;

        private AuthenticContent(Document document) {
            this.myDocument = document;
        }

        @Override
        public CharSequence getText() {
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myDocument.getModificationStamp();
        }
    }

    private static interface DocumentContent {
        public CharSequence getText();

        public long getModificationStamp();
    }

    public static final class ProjectIndexableFilesFilter
    extends IdFilter {
        private static final int SHIFT = 6;
        private static final int MASK = 63;
        private final long[] myBitMask;
        private final int myModificationCount;
        private final int myMinId;
        private final int myMaxId;

        private ProjectIndexableFilesFilter(@NotNull TIntArrayList set, int modificationCount) {
            this.myModificationCount = modificationCount;
            final int[] minMax = new int[2];
            if (!set.isEmpty()) {
                minMax[0] = minMax[1] = set.get(0);
            }
            set.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    if (value < 0) {
                        value = -value;
                    }
                    minMax[0] = Math.min(minMax[0], value);
                    minMax[1] = Math.max(minMax[1], value);
                    return true;
                }
            });
            this.myMaxId = minMax[1];
            this.myMinId = minMax[0];
            this.myBitMask = new long[(this.myMaxId - this.myMinId >> 6) + 1];
            set.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    if (value < 0) {
                        value = -value;
                    }
                    long[] lArray = myBitMask;
                    int n = (value -= myMinId) >> 6;
                    lArray[n] = lArray[n] | 1L << (value & 0x3F);
                    return true;
                }
            });
        }

        public boolean containsFileId(int id) {
            if (id < this.myMinId) {
                return false;
            }
            if (id > this.myMaxId) {
                return false;
            }
            return (this.myBitMask[(id -= this.myMinId) >> 6] & 1L << (id & 0x3F)) != 0L;
        }
    }
}

