/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Chunk;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.impl.CycleFinder;
import com.intellij.util.graph.impl.KShortestPathsFinder;
import com.intellij.util.graph.impl.ShortestPathFinder;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraphAlgorithmsImpl
extends GraphAlgorithms {
    public <Node> List<Node> findShortestPath(@NotNull Graph<Node> graph, @NotNull Node start, @NotNull Node finish) {
        return new ShortestPathFinder<Node>(graph).findPath(start, finish);
    }

    @NotNull
    public <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> graph, @NotNull Node start, @NotNull Node finish, int k, @NotNull ProgressIndicator progressIndicator) {
        return new KShortestPathsFinder<Node>(graph, start, finish, progressIndicator).findShortestPaths(k);
    }

    @NotNull
    public <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> graph, @NotNull Node node) {
        return new CycleFinder<Node>(graph).getNodeCycles(node);
    }

    @NotNull
    public <Node> Graph<Node> invertEdgeDirections(final @NotNull Graph<Node> graph) {
        return new Graph<Node>(){

            public Collection<Node> getNodes() {
                return graph.getNodes();
            }

            public Iterator<Node> getIn(Node n) {
                return graph.getOut(n);
            }

            public Iterator<Node> getOut(Node n) {
                return graph.getIn(n);
            }
        };
    }

    @NotNull
    public <Node> Graph<Chunk<Node>> computeSCCGraph(final @NotNull Graph<Node> graph) {
        final DFSTBuilder builder = new DFSTBuilder(graph);
        TIntArrayList sccs = builder.getSCCs();
        final ArrayList chunks = new ArrayList(sccs.size());
        final LinkedHashMap nodeToChunkMap = new LinkedHashMap();
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                LinkedHashSet<Object> chunkNodes = new LinkedHashSet<Object>();
                Chunk chunk = new Chunk(chunkNodes);
                chunks.add(chunk);
                for (int j = 0; j < size; ++j) {
                    Object node = builder.getNodeByTNumber(this.myTNumber + j);
                    chunkNodes.add(node);
                    nodeToChunkMap.put(node, chunk);
                }
                this.myTNumber += size;
                return true;
            }
        });
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Chunk<Node>>(){

            public Collection<Chunk<Node>> getNodes() {
                return chunks;
            }

            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet ins = new LinkedHashSet();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add(nodeToChunkMap.get(in));
                    }
                }
                return ins.iterator();
            }
        }));
    }

    public <Node> void collectOutsRecursively(@NotNull Graph<Node> graph, Node start, Set<Node> set) {
        if (!set.add(start)) {
            return;
        }
        Iterator iterator = graph.getOut(start);
        while (iterator.hasNext()) {
            Object node = iterator.next();
            this.collectOutsRecursively(graph, node, set);
        }
    }

    @NotNull
    public <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> graph) {
        return this.computeSCCGraph(graph).getNodes();
    }

    @NotNull
    public <Node> List<List<Node>> removePathsWithCycles(@NotNull List<List<Node>> paths) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        for (List<Node> path : paths) {
            if (GraphAlgorithmsImpl.containsCycle(path)) continue;
            result.add(path);
        }
        return result;
    }

    private static boolean containsCycle(List<?> path) {
        return new HashSet(path).size() != path.size();
    }
}

