/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.text.UniqueNameGenerator;
import org.jetbrains.annotations.NotNull;

public class DownloadableFileDescriptionImpl
implements DownloadableFileDescription {
    private final String myFileName;
    private final String myFileExtension;
    private final String myDownloadUrl;

    public DownloadableFileDescriptionImpl(@NotNull String downloadUrl, @NotNull String fileName, @NotNull String fileExtension) {
        this.myFileName = fileName;
        this.myFileExtension = fileExtension.length() > 0 && !fileExtension.startsWith(".") ? "." + fileExtension : fileExtension;
        this.myDownloadUrl = downloadUrl;
    }

    @NotNull
    public String getDownloadUrl() {
        return this.myDownloadUrl;
    }

    @NotNull
    public String getPresentableFileName() {
        return this.myFileName + this.myFileExtension;
    }

    @NotNull
    public String getPresentableDownloadUrl() {
        return this.myDownloadUrl;
    }

    @NotNull
    public String getDefaultFileName() {
        return this.generateFileName((Condition<String>)Conditions.alwaysTrue());
    }

    @NotNull
    public String generateFileName(@NotNull Condition<String> validator) {
        return UniqueNameGenerator.generateUniqueName((String)"", (String)this.myFileName, (String)this.myFileExtension, (String)"_", (String)"", validator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadableFileDescriptionImpl that = (DownloadableFileDescriptionImpl)o;
        return this.myDownloadUrl.equals(that.myDownloadUrl);
    }

    public int hashCode() {
        return this.myDownloadUrl.hashCode();
    }
}

