/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Couple;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class UriUtil {
    public static final CharMatcher PARAM_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"?#;");
    public static final CharMatcher SLASH_MATCHER = CharMatcher.is((char)'/');

    private UriUtil() {
    }

    @NotNull
    public static String trimTrailingSlashes(@NotNull String url) {
        return SLASH_MATCHER.trimTrailingFrom((CharSequence)url);
    }

    @NotNull
    public static String trimLeadingSlashes(@NotNull String url) {
        return SLASH_MATCHER.trimLeadingFrom((CharSequence)url);
    }

    public static String trimParameters(@NotNull String url) {
        int end = PARAM_CHAR_MATCHER.indexIn((CharSequence)url);
        return end != -1 ? url.substring(0, end) : url;
    }

    @NotNull
    public static Couple<String> splitScheme(@NotNull String url) {
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"://").limit(2).split((CharSequence)url));
        if (list.size() == 1) {
            return Couple.of((Object)"", list.get(0));
        }
        return Couple.of(list.get(0), list.get(1));
    }
}

