/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldCompletionProvider {
    static final Key<TextFieldCompletionProvider> COMPLETING_TEXT_FIELD_KEY = Key.create((String)"COMPLETING_TEXT_FIELD_KEY");
    protected boolean myCaseInsensitivity;

    protected TextFieldCompletionProvider() {
        this(false);
    }

    protected TextFieldCompletionProvider(boolean caseInsensitivity) {
        this.myCaseInsensitivity = caseInsensitivity;
    }

    public void apply(@NotNull EditorTextField field, @NotNull String text) {
        Project project2 = field.getProject();
        if (project2 != null) {
            field.setDocument(this.createDocument(project2, text));
        }
    }

    public void apply(@NotNull EditorTextField field) {
        this.apply(field, "");
    }

    private Document createDocument(Project project2, @NotNull String text) {
        LanguageFileType fileType = PlainTextLanguage.INSTANCE.getAssociatedFileType();
        assert (fileType != null);
        long stamp = LocalTimeCounter.currentTime();
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)text, stamp, true, false);
        psiFile.putUserData(COMPLETING_TEXT_FIELD_KEY, (Object)this);
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        assert (document != null);
        return document;
    }

    public boolean isCaseInsensitivity() {
        return this.myCaseInsensitivity;
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        return currentTextPrefix;
    }

    protected abstract void addCompletionVariants(@NotNull String var1, int var2, @NotNull String var3, @NotNull CompletionResultSet var4);

    @NotNull
    public EditorTextField createEditor(Project project2) {
        return this.createEditor(project2, true);
    }

    @NotNull
    public EditorTextField createEditor(Project project2, boolean shouldHaveBorder) {
        return this.createEditor(project2, shouldHaveBorder, null);
    }

    @NotNull
    public EditorTextField createEditor(Project project2, final boolean shouldHaveBorder, final @Nullable Consumer<Editor> editorConstructionCallback) {
        return new EditorTextField(this.createDocument(project2, ""), project2, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType()){

            @Override
            protected boolean shouldHaveBorder() {
                return shouldHaveBorder;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (shouldHaveBorder) {
                    super.updateBorder(editor);
                } else {
                    editor.setBorder(null);
                }
            }

            @Override
            protected EditorEx createEditor() {
                EditorEx result = super.createEditor();
                if (editorConstructionCallback != null) {
                    editorConstructionCallback.consume((Object)result);
                }
                return result;
            }
        };
    }
}

