/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class MessageBusUtil {
    private static <T> Runnable createPublisherRunnable(final Project project2, final Topic<T> topic, final Consumer<T> listener2) {
        return new Runnable(){

            @Override
            public void run() {
                if (project2.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                listener2.consume(project2.getMessageBus().syncPublisher(topic));
            }
        };
    }

    public static <T> void invokeLaterIfNeededOnSyncPublisher(Project project2, Topic<T> topic, Consumer<T> listener2) {
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = MessageBusUtil.createPublisherRunnable(project2, topic, listener2);
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2);
        }
    }

    @NotNull
    public static Disposable newMessageBusDisposer(final @NotNull MessageBus messageBus) {
        return new Disposable(){

            public void dispose() {
                messageBus.dispose();
            }
        };
    }
}

