/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ProjectTopics;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootType;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VirtualFileLogicalRoot;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogicalRootsManagerImpl
extends LogicalRootsManager {
    private Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> myRoots = null;
    private final MultiValuesMap<LogicalRootType, NotNullFunction> myProviders = new MultiValuesMap();
    private final MultiValuesMap<FileType, LogicalRootType> myFileTypes2RootTypes = new MultiValuesMap();
    private final ModuleManager myModuleManager;
    private final Project myProject;

    public LogicalRootsManagerImpl(final MessageBus bus, ModuleManager moduleManager, Project project2) {
        this.myModuleManager = moduleManager;
        this.myProject = project2;
        MessageBusConnection connection = bus.connect();
        connection.subscribe(LOGICAL_ROOTS, (Object)new LogicalRootsManager.LogicalRootListener(){

            public void logicalRootsChanged() {
                LogicalRootsManagerImpl.this.clear();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ((LogicalRootsManager.LogicalRootListener)bus.asyncPublisher(LogicalRootsManager.LOGICAL_ROOTS)).logicalRootsChanged();
            }
        });
        this.registerLogicalRootProvider(LogicalRootType.SOURCE_ROOT, new NotNullFunction<Module, List<VirtualFileLogicalRoot>>(){

            @NotNull
            public List<VirtualFileLogicalRoot> fun(Module module2) {
                return ContainerUtil.map2List((Object[])ModuleRootManager.getInstance((Module)module2).getSourceRoots(), (Function)new Function<VirtualFile, VirtualFileLogicalRoot>(){

                    public VirtualFileLogicalRoot fun(VirtualFile s) {
                        return new VirtualFileLogicalRoot(s);
                    }
                });
            }
        });
    }

    private synchronized void clear() {
        this.myRoots = null;
    }

    private synchronized Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> getRoots(ModuleManager moduleManager) {
        if (this.myRoots == null) {
            Module[] modules;
            this.myRoots = new THashMap();
            for (Module module2 : modules = moduleManager.getModules()) {
                MultiValuesMap map = new MultiValuesMap();
                for (Map.Entry entry : this.myProviders.entrySet()) {
                    Collection functions = (Collection)entry.getValue();
                    for (NotNullFunction function : functions) {
                        map.putAll(entry.getKey(), (Collection)((List)function.fun((Object)module2)));
                    }
                }
                this.myRoots.put(module2, (MultiValuesMap<LogicalRootType, LogicalRoot>)map);
            }
        }
        return this.myRoots;
    }

    @Nullable
    public LogicalRoot findLogicalRoot(@NotNull VirtualFile file2) {
        Module module2 = ModuleUtil.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
        if (module2 == null) {
            return null;
        }
        LogicalRoot result = null;
        List<LogicalRoot> list = this.getLogicalRoots(module2);
        for (LogicalRoot root : list) {
            VirtualFile rootFile = root.getVirtualFile();
            if (rootFile == null || !VfsUtil.isAncestor((VirtualFile)rootFile, (VirtualFile)file2, (boolean)false)) continue;
            result = root;
            break;
        }
        return result;
    }

    public List<LogicalRoot> getLogicalRoots() {
        return ContainerUtil.concat((Object[])this.myModuleManager.getModules(), (Function)new Function<Module, Collection<? extends LogicalRoot>>(){

            public Collection<? extends LogicalRoot> fun(Module module2) {
                return LogicalRootsManagerImpl.this.getLogicalRoots(module2);
            }
        });
    }

    public List<LogicalRoot> getLogicalRoots(@NotNull Module module2) {
        Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> roots = this.getRoots(this.myModuleManager);
        MultiValuesMap<LogicalRootType, LogicalRoot> valuesMap = roots.get(module2);
        if (valuesMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<LogicalRoot>(valuesMap.values());
    }

    public List<LogicalRoot> getLogicalRootsOfType(final @NotNull Module module2, LogicalRootType ... types) {
        return ContainerUtil.concat((Object[])types, (Function)new Function<LogicalRootType, Collection<? extends LogicalRoot>>(){

            public Collection<? extends LogicalRoot> fun(LogicalRootType s) {
                return LogicalRootsManagerImpl.this.getLogicalRootsOfType(module2, s);
            }
        });
    }

    public <T extends LogicalRoot> List<T> getLogicalRootsOfType(@NotNull Module module2, @NotNull LogicalRootType<T> type) {
        Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> roots = this.getRoots(this.myModuleManager);
        MultiValuesMap<LogicalRootType, LogicalRoot> map = roots.get(module2);
        if (map == null) {
            return Collections.emptyList();
        }
        Collection collection = map.get(type);
        if (collection == null) {
            return Collections.emptyList();
        }
        return new ArrayList(collection);
    }

    @NotNull
    public LogicalRootType[] getRootTypes(@NotNull FileType type) {
        Collection rootTypes = this.myFileTypes2RootTypes.get((Object)type);
        if (rootTypes == null) {
            return new LogicalRootType[0];
        }
        return rootTypes.toArray(new LogicalRootType[rootTypes.size()]);
    }

    public void registerRootType(@NotNull FileType fileType, LogicalRootType ... rootTypes) {
        this.myFileTypes2RootTypes.putAll((Object)fileType, (Object[])rootTypes);
    }

    public <T extends LogicalRoot> void registerLogicalRootProvider(@NotNull LogicalRootType<T> rootType, @NotNull NotNullFunction<Module, List<T>> provider) {
        this.myProviders.put(rootType, provider);
        this.clear();
    }
}

