/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInBulk(@NotNull Document document, boolean executeInBulk, @NotNull Runnable task) {
        if (!(document instanceof DocumentEx)) {
            task.run();
            return;
        }
        DocumentEx documentEx = (DocumentEx)document;
        if (executeInBulk == documentEx.isInBulkUpdate()) {
            task.run();
            return;
        }
        documentEx.setInBulkUpdate(executeInBulk);
        try {
            task.run();
            documentEx.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            documentEx.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void writeInRunUndoTransparentAction(final @NotNull Runnable runnable2) {
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }
        });
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int line) {
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int startOffset, int endOffset) {
        CharSequence text = document.getImmutableCharSequence();
        for (int i = startOffset; i < endOffset; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return startOffset;
    }

    public static boolean isValidOffset(int offset, @NotNull Document document) {
        return offset >= 0 && offset <= document.getTextLength();
    }

    public static int getLineStartOffset(int offset, @NotNull Document document) {
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineStartOffset(lineNumber);
    }

    public static int getLineEndOffset(int offset, @NotNull Document document) {
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    @NotNull
    public static TextRange getLineTextRange(@NotNull Document document, int line) {
        return TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
    }

    public static boolean isAtLineStart(int offset, @NotNull Document document) {
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineStartOffset(document.getLineNumber(offset));
    }
}

