/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project2, CachedValuesFactory factory) {
        this.myProject = project2;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project2) : factory;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        return this.myFactory.createCachedValue(provider, trackValue);
    }

    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        return this.myFactory.createParameterizedCachedValue(provider, trackValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue value;
        CachedValueChecker.checkProvider(provider, key, dataHolder);
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = (CachedValue)dh.getUserData(key);
            if (value instanceof CachedValueBase && !((CachedValueBase)value).isFromMyProject(this.myProject)) {
                value = null;
                dh.putUserData(key, null);
            }
            if (value == null) {
                value = this.createCachedValue(provider, trackValue);
                assert (((CachedValueBase)value).isFromMyProject(this.myProject));
                value = (CachedValue)dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = (CachedValue)dataHolder.getUserData(key);
                if (value instanceof CachedValueBase && !((CachedValueBase)value).isFromMyProject(this.myProject)) {
                    value = null;
                }
                if (value == null) {
                    value = this.createCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return (T)value.getValue();
    }

    public Project getProject() {
        return this.myProject;
    }
}

